
/*========================================================================================
  / 
  /      File:		BRTime.h
  /      Release Version:	$ 1.0d1 $
  / 
  /      Creation Date:	November 3, 1989
  / 
  /      COPYRIGHT 1989-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
  /      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
  /      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
  / 
  /      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
  /      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
  /      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
  / 
  /      RESTRICTED RIGHTS LEGEND
  /      Use, duplication, or disclosure by the Government is subject to restrictions as Set
  /      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
  /      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
  /      Cupertino, CA 95014.
  / 
  /=======================================================================================*/


/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef BRTIME_H
#define BRTIME_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif


typedef enum
{
	BR_CalendarType_kGregorian, BR_CalendarType_kJulian, BR_CalendarType_kLunar, BR_CalendarType_kHebrew
} BR_CalendarType;

typedef	unsigned short BR_Year;
typedef	unsigned short BR_Month;
typedef	unsigned short BR_Week;
typedef	unsigned short BR_Day;
typedef	unsigned short BR_Hour;
typedef	unsigned short BR_Minute;
typedef	unsigned short BR_Second;
typedef	unsigned short BR_Hundredths;
typedef	unsigned long  BR_LongHundredths;
typedef	unsigned long  BR_Ticks;
typedef	short			BR_Duration;

typedef struct BR_SDateTime
{
	BR_CalendarType			fCalendar;
	BR_Year 				fYear;
	BR_Month 				fMonth;
	BR_Week 				fWeek;
	BR_Week 				fWeekOfMonth;
	BR_Day 					fDay;
	BR_Day 					fDayOfYear;
	BR_Day 					fDayOfWeek;
	BR_Hour 				fHour;
	BR_Minute 				fMinute;
	BR_Second 				fSecond;
	BR_Hundredths 			fHundredths;
	BR_Boolean 				fLeapYear;
	BR_Boolean 				fDaylightSavings;
} BR_SDateTime, FAR* BR_SDateTimePtr;

typedef struct BR_SPackedDateTime
{
	BR_Year 				fYear;
	BR_LongHundredths	 	fHundredths;
} BR_SPackedDateTime, FAR* BR_SPackedDateTimePtr;

typedef long BR_FastDateTime, FAR* BR_FastDateTimePtr;


typedef enum
{
	BR_DateTimeSet_kYear = (0x0001),
	BR_DateTimeSet_kMonth = (0x0002),
	BR_DateTimeSet_kWeek = (0x0004), 
	BR_DateTimeSet_kWeekOfMonth = (0x0008),
	BR_DateTimeSet_kDay = (0x0010),
	BR_DateTimeSet_kDayOfYear = (0x0020),
	BR_DateTimeSet_kDayOfWeek = (0x0040),
	BR_DateTimeSet_kHour = (0x0080),
	BR_DateTimeSet_kMinute = (0x0100),
	BR_DateTimeSet_kSecond = (0x0200),
	BR_DateTimeSet_kHundredth = (0x0400)
} BR_DateTimeSet;

typedef enum
{
	BR_DurationUnit_kYears, BR_DurationUnit_kMonths, BR_DurationUnit_kWeeks, BR_DurationUnit_kDays, BR_DurationUnit_kHours, BR_DurationUnit_kMinutes, BR_DurationUnit_kSeconds, BR_DurationUnit_kHundredths
} BR_DurationUnit;


/* Date Time Procedures */

EXPENTRY(short)BR_DTInit(void);

BR_EXPORTENTRY(BR_SystemError) BR_GetDateTime(BR_SDateTimePtr dt);

BR_EXPORTENTRY(BR_SystemError) BR_SetDateTime(BR_SDateTimePtr dt);

BR_EXPORTENTRY(BR_SystemError) BR_AdjustDateTime(BR_SDateTimePtr dt, BR_DateTimeSet valid);


BR_EXPORTENTRY(BR_SystemError) BR_SetFastDateTimeBase(BR_SDateTimePtr dt, long inc);



BR_EXPORTENTRY(BR_SystemError) BR_DateTimeToFastDateTime(
	BR_FastDateTimePtr fastDT,
	BR_SDateTimePtr dt);

BR_EXPORTENTRY(BR_SystemError) BR_FastDateTimeToDateTime(
	BR_SDateTimePtr dt, 
	BR_FastDateTimePtr fastDT);


BR_EXPORTENTRY(BR_SystemError) BR_DurationToFastDateTime(
	BR_FastDateTimePtr fastDT,
	BR_Duration duration, 
	BR_DurationUnit unit);

BR_EXPORTENTRY(BR_SystemError) BR_AddDurationToFastDateTime(
	BR_FastDateTimePtr fastDT,
	BR_Duration duration,
	BR_DurationUnit unit);

BR_EXPORTENTRY(BR_SystemError) BR_AddDurationToDateTime(
	BR_SDateTimePtr dt,
	BR_Duration duration, 
	BR_DurationUnit unit);


BR_EXPORTENTRY(BR_SDateTimePtr) BR_PackedDateTimeToDateTime(
	BR_SDateTimePtr dt,
	BR_SPackedDateTimePtr pdt);
	
BR_EXPORTENTRY(BR_SPackedDateTimePtr) BR_DateTimeToPackedDateTime(
	BR_SPackedDateTimePtr pdt,
	BR_SDateTimePtr dt);

BR_EXPORTENTRY(BR_SPackedDateTimePtr) BR_DateTimeToGMTPackedDateTime(
	BR_SPackedDateTimePtr pdt,
	BR_SDateTimePtr dt);
	
BR_EXPORTENTRY(BR_SDateTimePtr) BR_GMTPackedDateTimeToDateTime(
	BR_SDateTimePtr dt,
	BR_SPackedDateTimePtr pdt);

BR_EXPORTENTRY(BR_SystemError) BR_PackedDateTimeToFastDateTime(
	BR_FastDateTimePtr fdt,
	BR_SPackedDateTimePtr pdt);
	
BR_EXPORTENTRY(BR_SystemError) BR_FastDateTimeToPackedDateTime(
	BR_SPackedDateTimePtr pdt,
	BR_FastDateTimePtr fdt);

BR_EXPORTENTRY(short) BR_CompareDateTime(BR_SDateTimePtr dt1, BR_SDateTimePtr dt2);

BR_EXPORTENTRY(BR_Boolean) BR_IsLeapYear(BR_Year fYear);
BR_EXPORTENTRY(BR_Day) BR_DaysInYear(BR_Year fYear);
BR_EXPORTENTRY(BR_Day) BR_DaysInMonth(BR_Year fYear, BR_Month fMonth);
BR_EXPORTENTRY(BR_Day) BR_DayOfYear(BR_Year fYear, BR_Month fMonth, BR_Day fDay);
BR_EXPORTENTRY(void) BR_GetMonthAndDay (
	BR_Year fYear, 
	BR_Day fDayOfYear,
	BR_Month FAR * fMonth,
	BR_Day FAR * fDay);
	
BR_EXPORTENTRY(BR_Year) BR_LeapYearsTo(BR_Year fYear);
BR_EXPORTENTRY(BR_Day) BR_DayOfWeek(BR_Year fYear, BR_Month fMonth, BR_Day fDay);

BR_EXPORTENTRY(void) BR_FillInDateTime(BR_SDateTimePtr dt, BR_DateTimeSet valid);

#ifdef __cplusplus
}
#endif

#endif


