// BCLHeapAPI.h 
// Copyright  1985-1992 by Apple Computer, Inc.  All rights reserved.
//========================================================================================
//
//     File:		BRMVMDeb.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/22/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRHEAAPI_H
#define BRHEAAPI_H

#ifdef BR_BUILD_MAC
#ifndef __STDDEF__
#include <StdDef.h>
#endif
#endif

#ifdef BR_BUILD_WIN
#ifndef __STDDEF_H
#include <StdDef.h>
#endif
#endif

#ifndef BRVIRMEM_H
#include "BRVM.h"
#endif


#ifdef __cplusplus
extern "C" {
#endif

// ToDo list
//	 BedVMDIsOk checks the heap but breaks into Macsbug on invalid heaps.
//	 BedVMDIsValidHandle not implemented.
//	 BedVMDSetAutoTrap not Set up to deal with the noRoom parameter.
//	 Handle based calls are simply wrappers for system handles.
//	 BedVMGetError not implemented.

//----------------------------------------------------------------------------------------
// Genaral routines.
//----------------------------------------------------------------------------------------

FAR PASCAL void BedVMInitiate(BR_CMemoryHeap *heap,
							  size_t initialSize,
							  size_t incrementSize);

FAR PASCAL BR_Boolean BedVMDIsOk();

FAR PASCAL BR_Boolean BedVMDSetAutTrap(BR_Boolean state, BR_Boolean noRoom);


//----------------------------------------------------------------------------------------
// System handle based heap interface routines.
//----------------------------------------------------------------------------------------

FAR PASCAL BR_Boolean BedVMDIsValidPointer(void FAR *ptr);


//----------------------------------------------------------------------------------------
// Pointer based heap interface routines.
//----------------------------------------------------------------------------------------

FAR PASCAL BR_Boolean BedVMDIsValidHandle(BR_PlatformHandle handle);


#ifdef __cplusplus
}
#endif

#endif
