/*========================================================================================
/ 
/      File:		BRKeywor.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	May 1, 1990
/ 
/      COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/


/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef BRKEYWOR_H
#define BRKEYWOR_H

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifdef __cplusplus
  extern "C" {
#endif


   /* These are the possible keyword types */

typedef enum { BR_FmtVldKeys_kFillKey,
               BR_FmtVldKeys_kNumKey,
               BR_FmtVldKeys_kYearKey,
               BR_FmtVldKeys_kMonthKey,
               BR_FmtVldKeys_kDayKey,
               BR_FmtVldKeys_kHalfDayKey,
               BR_FmtVldKeys_kWeekKey,
               BR_FmtVldKeys_kSecondKey,
               BR_FmtVldKeys_kHundredthKey,
               BR_FmtVldKeys_kHourKey,
               BR_FmtVldKeys_kMinuteKey,
               BR_FmtVldKeys_kDayNameKey,
               BR_FmtVldKeys_kMonthNameKey,
               BR_FmtVldKeys_kTimeTrailerKey
             } BR_FormatAndValidationKeywords, FAR * BR_FormatAndValidationKeywordsPtr;

/* BR_InitializeFmtVldKeywords -- Set up the global structures needed to maintain the
                   list of valid keywords.
 */

BR_EXPORTENTRY(void) BR_InitializeFmtVldKeywords(void);




/* BR_MatchAKeyword -- see if the contents of s starting at position pos
                    matches a keyword.  If so, increment pos past that
                    keyword and return the type of Key.
*/

BR_EXPORTENTRY(BR_Boolean) BR_MatchAKeyword (
	BR_BedString s,
	unsigned short FAR * pos,
	BR_FormatAndValidationKeywordsPtr keytype,
	unsigned short FAR *  p2);

#ifdef __cplusplus
}
#endif

#endif
