/*========================================================================================
/ 
/      File:		BRIntlMa.h
/      Release Version:	$ 1.0d1 $
/ 
/      Creation Date:	12/1/92
/ 
/      COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
/      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
/      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
/ 
/      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
/      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
/      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
/ 
/      RESTRICTED RIGHTS LEGEND
/      Use, duplication, or disclosure by the Government is subject to restrictions as Set
/      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
/      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
/      Cupertino, CA 95014.
/ 
/=======================================================================================*/

/*--------------------------------------------------------------------------------------
//	This file is part of the old international implementation.
//	The Bedrock team is in the process of designing a totally new approach.
//	For more details on the new approach please look in the 
//	":BEDROCK:INTL:INCLUDES:" folder.
//	The new approach departs from the close tie to characters and characterSets.
//	Instead it bases all internationalization efforts on locale based
//	characters, and character sets, with Unicode as the central set.
/--------------------------------------------------------------------------------------*/


#ifndef BRINTLMA_H
#define BRINTLMA_H

typedef struct BR_SMappingHeaderEntry
       {
       unsigned short Page;
       unsigned short start;
       unsigned short end;
       unsigned short TOffset;
       } BR_SMappingHeaderEntry, FAR * BR_SMappingHeaderEntryPtr;

typedef struct BR_SMappingTranslateTable
       {
       unsigned short  entryCount;
       unsigned short FAR * transTable;
       BR_SMappingHeaderEntryPtr  head;
       } BR_SMappingTranslateTable, FAR * BR_SMappingTranslateTablePtr;
/*****  Macintosh code Page     *****/

#define TO_MAC_HDR_ENTRIES  42
/*======================================*/

unsigned short FROM_MAC[]=  // code map for translation from MAC to Unicode

{
        0x0000, 0x263A, 0x263B, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
        0x25D8, 0x25CB, 0x25D9, 0x2642, 0x2640, 0x266A, 0x266B, 0x263C,
        0x25BA, 0x25C4, 0x2195, 0x203C, 0x00B6, 0x00A7, 0x25AC, 0x21A8,
        0x201D, 0x2193, 0x2192, 0x2190, 0x2502, 0x2194, 0x25B2, 0x201C,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2302,
        0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7,
        0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x00C5,
        0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9,
        0x00FF, 0x00D6, 0x00DC, 0x00F8, 0x00A3, 0x00D8, 0x00D7, 0x0192,
        0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA,
        0x00BF, 0x00AE, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB,
        0x221E, 0x00B1, 0x2264, 0x2265, 0x00A5, 0x00C1, 0x00C2, 0x00C0,
        0x00A9, 0x220F, 0x222B, 0x00AA, 0x00B0, 0x00A2, 0x00A5, 0x00D8,
        0x00BF, 0x00A1, 0x02E5, 0x221A, 0x0192, 0x2248, 0x00E3, 0x00C3,
        0x226B, 0x22EF, 0x222B, 0x00C0, 0x0100, 0x014C, 0x0152, 0x00A4,
        0x00F0, 0x00D0, 0x00CA, 0x00CB, 0x00C8, 0x0131, 0x00CD, 0x00CE,
        0x00CF, 0x0178, 0x002F, 0x00A4, 0x003C, 0x00A6, 0x00CC, 0xAF00,
        0x00D3, 0x00DF, 0x00D4, 0x00D2, 0x00F5, 0x00D5, 0x00B5, 0x00FE,
        0x00DE, 0x00DA, 0x00DB, 0x00D9, 0x00FD, 0x00DD, 0x00AF, 0x00B4,
        0x00AD, 0x00B1, 0x2017, 0x00BE, 0x00B6, 0x00A7, 0x00F7, 0x00B8,
        0x00B0, 0x00A8, 0x00B7, 0x00B9, 0x00B3, 0x00B2, 0x0328, 0x0306
};

/*======================================*/

BR_SMappingHeaderEntry TO_MAC_HDR[TO_MAC_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x0,   0x0,    0x0,    0x0},
        {0x0,   0x20,   0x7E,   0x1},
        {0x0,   0xA1,   0xFF,   0x60},
        {0x1,   0x0,    0x0,    0xBF},
        {0x1,   0x31,   0x31,   0xC0},
        {0x1,   0x4C,   0x4C,   0xC1},
        {0x1,   0x52,   0x52,   0xC2},
        {0x1,   0x78,   0x78,   0xC3},
        {0x1,   0x92,   0x92,   0xC4},
        {0x2,   0xE5,   0xE5,   0xC5},
        {0x3,   0x6,    0x6,    0xC6},
        {0x3,   0x28,   0x28,   0xC7},
        {0x20,  0x17,   0x17,   0xC8},
        {0x20,  0x1C,   0x1D,   0xC9},
        {0x20,  0x22,   0x22,   0xCB},
        {0x20,  0x3C,   0x3C,   0xCC},
        {0x21,  0x90,   0x90,   0xCD},
        {0x21,  0x92,   0x95,   0xCE},
        {0x21,  0xA8,   0xA8,   0xD2},
        {0x22,  0xF,    0xF,    0xD3},
        {0x22,  0x1A,   0x1A,   0xD4},
        {0x22,  0x1E,   0x1E,   0xD5},
        {0x22,  0x2B,   0x2B,   0xD6},
        {0x22,  0x48,   0x48,   0xD7},
        {0x22,  0x64,   0x65,   0xD8},
        {0x22,  0x6B,   0x6B,   0xDA},
        {0x22,  0xEF,   0xEF,   0xDB},
        {0x23,  0x2,    0x2,    0xDC},
        {0x25,  0x2,    0x2,    0xDD},
        {0x25,  0xAC,   0xAC,   0xDE},
        {0x25,  0xB2,   0xB2,   0xDF},
        {0x25,  0xBA,   0xBA,   0xE0},
        {0x25,  0xC4,   0xC4,   0xE1},
        {0x25,  0xCB,   0xCB,   0xE2},
        {0x25,  0xD8,   0xD9,   0xE3},
        {0x26,  0x3A,   0x3C,   0xE5},
        {0x26,  0x40,   0x40,   0xE8},
        {0x26,  0x42,   0x42,   0xE9},
        {0x26,  0x60,   0x60,   0xEA},
        {0x26,  0x63,   0x63,   0xEB},
        {0x26,  0x65,   0x66,   0xEC},
        {0x26,  0x6A,   0x6B,   0xEE}
};
/*======================================*/

unsigned short TO_MAC_TBL[]=  // code map for translation from Unicode to MAC, it goes with the header above
{
        0x00,   0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,
        0x27,   0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,
        0x2F,   0xDA,   0x30,   0x31,   0x32,   0x33,   0x34,   0x35,
        0x36,   0x37,   0x38,   0x39,   0x3A,   0x3B,   0x3C,   0xDC,
        0x3D,   0x3E,   0x3F,   0x40,   0x41,   0x42,   0x43,   0x44,
        0x45,   0x46,   0x47,   0x48,   0x49,   0x4A,   0x4B,   0x4C,
        0x4D,   0x4E,   0x4F,   0x50,   0x51,   0x52,   0x53,   0x54,
        0x55,   0x56,   0x57,   0x58,   0x59,   0x5A,   0x5B,   0x5C,
        0x5D,   0x5E,   0x5F,   0x60,   0x61,   0x62,   0x63,   0x64,
        0x65,   0x66,   0x67,   0x68,   0x69,   0x6A,   0x6B,   0x6C,
        0x6D,   0x6E,   0x6F,   0x70,   0x71,   0x72,   0x73,   0x74,
        0x75,   0x76,   0x77,   0x78,   0x79,   0x7A,   0x7B,   0x7C,
        0x7D,   0x7E,   0xAD,   0xC1,   0xBD,   0x9C,   0xCF,   0xDB,
        0xB4,   0xBE,   0xDD,   0x15,   0xF5,   0xF9,   0xB8,   0xBB,
        0xA6,   0xAE,   0xAA,   0xF0,   0xA9,   0xEE,   0xBC,   0xF8,
        0xB1,   0xF1,   0xFD,   0xFC,   0xEF,   0xE6,   0x14,   0xF4,
        0xFA,   0xF7,   0xFB,   0xA7,   0xAF,   0xAC,   0xAB,   0xF3,
        0xA8,   0xC0,   0xB7,   0xCB,   0xB5,   0xB6,   0xC7,   0x8E,
        0x8F,   0x92,   0x80,   0xD4,   0x90,   0xD2,   0xD3,   0xDE,
        0xD6,   0xD7,   0xD8,   0xD1,   0xA5,   0xE3,   0xE0,   0xE2,
        0xE5,   0x99,   0x9E,   0x9D,   0xBF,   0xEB,   0xE9,   0xEA,
        0x9A,   0xED,   0xE8,   0xE1,   0x85,   0xA0,   0x83,   0xC6,
        0x84,   0x86,   0x91,   0x87,   0x8A,   0x82,   0x88,   0x89,
        0x8D,   0xA1,   0x8C,   0x8B,   0xD0,   0xA4,   0x95,   0xA2,
        0x93,   0xE4,   0x94,   0xF6,   0x9B,   0x97,   0xA3,   0x96,
        0x81,   0xEC,   0xE7,   0x98,   0xCC,   0xD5,   0xCD,   0xCE,
        0xD9,   0x9F,   0xC4,   0xC2,   0xFF,   0xFE,   0xF2,   0x1F,
        0x18,   0x07,   0x13,   0x1B,   0x1A,   0x19,   0x1D,   0x12,
        0x17,   0xB9,   0xC3,   0xB0,   0xBA,   0xCA,   0xC5,   0xB2,
        0xB3,   0xC8,   0xC9,   0x7F,   0x1C,   0x16,   0x1E,   0x10,
        0x11,   0x09,   0x08,   0x0A,   0x01,   0x02,   0x0F,   0x0C,
        0x0B,   0x06,   0x05,   0x03,   0x04,   0x0D,   0x0E,   0xDF
};

/********************************************************************************************************/
/*****  Windows 3.1 code Page   *****/

#define TO_WIN31_HDR_ENTRIES  15

/*======================================*/
unsigned short FROM_WIN31[]=  // code map for translation from Win3.1 to Unicode

{
        0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
        0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
        0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017,
        0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
        0x0080, 0x0081, 0x201A, 0x0192, 0x201E, 0x2026, 0x2020, 0x2021,
        0x02C6, 0x2030, 0xFFDE, 0x2039, 0x0152, 0xFFDE, 0xFFDE, 0xFFDE,
        0xFFDE, 0x2018, 0x2019, 0x201C, 0x201D, 0x2022, 0x2013, 0x2014,
        0x02DC, 0x2122, 0xFFDE, 0x203A, 0x0153, 0xFFDE, 0xFFDE, 0xFFDE,
        0x00A0, 0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7,
        0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF,
        0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7,
        0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF,
        0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
        0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
        0x00D0, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
        0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
        0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
        0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
        0x00F0, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
        0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF
};

/*======================================*/

BR_SMappingHeaderEntry TO_WIN31_HDR[TO_WIN31_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x00,  0x00,   0x81,   0x00},
        {0x0,   0xA0,   0xFF,   0x82},
        {0x1,   0x52,   0x53,   0xE2},
        {0x1,   0x92,   0x92,   0xE4},
        {0x2,   0xC6,   0xC6,   0xE5},
        {0x2,   0xDC,   0xDC,   0xE6},
        {0x20,  0x13,   0x14,   0xE7},
        {0x20,  0x18,   0x1A,   0xE9},
        {0x20,  0x1C,   0x1E,   0xEC},
        {0x20,  0x20,   0x22,   0xEF},
        {0x20,  0x26,   0x26,   0xF2},
        {0x20,  0x30,   0x30,   0xF3},
        {0x20,  0x39,   0x3A,   0xF4},
        {0x21,  0x22,   0x22,   0xF6},
        {0xFF,  0xDE,   0xDE,   0xF7}
};
/*======================================*/

unsigned short TO_WIN31_TBL[]=  // code map for translation from Unicode to MAC, it goes with the header above
{
        0x00,   0x01,   0x02,   0x03,   0x04,   0x05,   0x06,   0x07,
        0x08,   0x09,   0x0A,   0x0B,   0x0C,   0x0D,   0x0E,   0x0F,
        0x10,   0x11,   0x12,   0x13,   0x14,   0x15,   0x16,   0x17,
        0x18,   0x19,   0x1A,   0x1B,   0x1C,   0x1D,   0x1E,   0x1F,
        0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27,
        0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,   0x2F,
        0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,
        0x38,   0x39,   0x3A,   0x3B,   0x3C,   0x3D,   0x3E,   0x3F,
        0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,
        0x48,   0x49,   0x4A,   0x4B,   0x4C,   0x4D,   0x4E,   0x4F,
        0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,
        0x58,   0x59,   0x5A,   0x5B,   0x5C,   0x5D,   0x5E,   0x5F,
        0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,
        0x68,   0x69,   0x6A,   0x6B,   0x6C,   0x6D,   0x6E,   0x6F,
        0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,
        0x78,   0x79,   0x7A,   0x7B,   0x7C,   0x7D,   0x7E,   0x7F,
        0x80,   0x81,   0xA0,   0xA1,   0xA2,   0xA3,   0xA4,   0xA5,
        0xA6,   0xA7,   0xA8,   0xA9,   0xAA,   0xAB,   0xAC,   0xAD,
        0xAE,   0xAF,   0xB0,   0xB1,   0xB2,   0xB3,   0xB4,   0xB5,
        0xB6,   0xB7,   0xB8,   0xB9,   0xBA,   0xBB,   0xBC,   0xBD,
        0xBE,   0xBF,   0xC0,   0xC1,   0xC2,   0xC3,   0xC4,   0xC5,
        0xC6,   0xC7,   0xC8,   0xC9,   0xCA,   0xCB,   0xCC,   0xCD,
        0xCE,   0xCF,   0xD0,   0xD1,   0xD2,   0xD3,   0xD4,   0xD5,
        0xD6,   0xD7,   0xD8,   0xD9,   0xDA,   0xDB,   0xDC,   0xDD,
        0xDE,   0xDF,   0xE0,   0xE1,   0xE2,   0xE3,   0xE4,   0xE5,
        0xE6,   0xE7,   0xE8,   0xE9,   0xEA,   0xEB,   0xEC,   0xED,
        0xEE,   0xEF,   0xF0,   0xF1,   0xF2,   0xF3,   0xF4,   0xF5,
        0xF6,   0xF7,   0xF8,   0xF9,   0xFA,   0xFB,   0xFC,   0xFD,
        0xFE,   0xFF,   0x8C,   0x9C,   0x83,   0x88,   0x98,   0x96,
        0x97,   0x91,   0x92,   0x82,   0x93,   0x94,   0x84,   0x86,
        0x87,   0x95,   0x85,   0x89,   0x8B,   0x9B,   0x99,   0x8A,
        0x8D,   0x8E,   0x8F,   0x90,   0x9A,   0x9D,   0x9E,   0x9F
};

/********************************************************************************************************/
/********       The American DOS Code Page 437  ********/

#define TO_437_HDR_ENTRIES  78
/*====================================*/

unsigned short FROM_437[]=  // code map for translation from 437 to Unicode
{
        0X0000, 0X263A, 0X263B, 0X2665, 0X2666, 0X2663, 0X2660, 0X2022,
        0X25D8, 0X25CB, 0X25D9, 0X2642, 0X2640, 0X266A, 0X266B, 0X263C,
        0X25BA, 0X25C4, 0X2195, 0X203C, 0X00B6, 0X00A7, 0X25AC, 0X21A8,
        0X2191, 0X2193, 0X2192, 0X2190, 0X221F, 0X2194, 0X25B2, 0X25BC,
        0X0020, 0X0021, 0X0022, 0X0023, 0X0024, 0X0025, 0X0026, 0X0027,
        0X0028, 0X0029, 0X002A, 0X002B, 0X002C, 0X002D, 0X002E, 0X002F,
        0X0030, 0X0031, 0X0032, 0X0033, 0X0034, 0X0035, 0X0036, 0X0037,
        0X0038, 0X0039, 0X003A, 0X003B, 0X003C, 0X003D, 0X003E, 0X003F,
        0X0040, 0X0041, 0X0042, 0X0043, 0X0044, 0X0045, 0X0046, 0X0047,
        0X0048, 0X0049, 0X004A, 0X004B, 0X004C, 0X004D, 0X004E, 0X004F,
        0X0050, 0X0051, 0X0052, 0X0053, 0X0054, 0X0055, 0X0056, 0X0057,
        0X0058, 0X0059, 0X005A, 0X005B, 0X005C, 0X005D, 0X005E, 0X005F,
        0X0060, 0X0061, 0X0062, 0X0063, 0X0064, 0X0065, 0X0066, 0X0067,
        0X0068, 0X0069, 0X006A, 0X006B, 0X006C, 0X006D, 0X006E, 0X006F,
        0X0070, 0X0071, 0X0072, 0X0073, 0X0074, 0X0075, 0X0076, 0X0077,
        0X0078, 0X0079, 0X007A, 0X007B, 0X007C, 0X007D, 0X007E, 0X2302,
        0X00C7, 0X00FC, 0X00E9, 0X00E2, 0X00E4, 0X00E0, 0X00E5, 0X00E7,
        0X00EA, 0X00EB, 0X00E8, 0X00EF, 0X00EE, 0X00EC, 0X00C4, 0X00C5,
        0X00C9, 0X00E6, 0X00C6, 0X00F4, 0X00F6, 0X00F2, 0X00FB, 0X00F9,
        0X00FF, 0X00D6, 0X00DC, 0X00A2, 0X00A3, 0X00A5, 0X20A7, 0X0192,
        0X00E1, 0X00ED, 0X00F3, 0X00FA, 0X00F1, 0X00D1, 0X00AA, 0X00BA,
        0X00BF, 0X2310, 0X00AC, 0X00BD, 0X00BC, 0X00A1, 0X00AB, 0X00BB,
        0X2591, 0X2592, 0X2593, 0X2502, 0X2524, 0X2561, 0X2562, 0X2556,
        0X2555, 0X2563, 0X2551, 0X2557, 0X255D, 0X255C, 0X255B, 0X2510,
        0X2514, 0X2534, 0X252C, 0X251C, 0X2500, 0X253C, 0X255E, 0X255F,
        0X255A, 0X2554, 0X2569, 0X2566, 0X2560, 0X2550, 0X256C, 0X2567,
        0X2568, 0X2564, 0X2565, 0X2559, 0X2558, 0X2552, 0X2553, 0X256B,
        0X256A, 0X2518, 0X250C, 0X2588, 0X2584, 0X258C, 0X2590, 0X2580,
        0X03B1, 0X00DF, 0X0393, 0X03C0, 0X03A3, 0X03C3, 0X00B5, 0X03C4,
        0X03A6, 0X0398, 0X03A9, 0X03B4, 0X221E, 0X03C6, 0X03B5, 0X2229,
        0X2261, 0X00B1, 0X2265, 0X2264, 0X2320, 0X2321, 0X00F7, 0X2248,
        0X00B0, 0X2219, 0X00B7, 0X221A, 0X207F, 0X00B2, 0X25A0, 0X00A0
};

/*====================================*/

BR_SMappingHeaderEntry TO_437_HDR[TO_437_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x0,   0x20,   0x7E,   0x0},
        {0x0,   0xA0,   0xA3,   0x5F},
        {0x0,   0xA5,   0xA5,   0x63},
        {0x0,   0xA7,   0xA7,   0x64},
        {0x0,   0xAA,   0xAC,   0x65},
        {0x0,   0xB0,   0xB2,   0x68},
        {0x0,   0xB5,   0xB7,   0x6B},
        {0x0,   0xBA,   0xBD,   0x6E},
        {0x0,   0xBF,   0xBF,   0x72},
        {0x0,   0xC4,   0xC7,   0x73},
        {0x0,   0xC9,   0xC9,   0x77},
        {0x0,   0xD1,   0xD1,   0x78},
        {0x0,   0xD6,   0xD6,   0x79},
        {0x0,   0xDC,   0xDC,   0x7A},
        {0x0,   0xDF,   0xE2,   0x7B},
        {0x0,   0xE4,   0xEF,   0x7F},
        {0x0,   0xF1,   0xF4,   0x8B},
        {0x0,   0xF6,   0xF7,   0x8F},
        {0x0,   0xF9,   0xFC,   0x91},
        {0x0,   0xFF,   0xFF,   0x95},
        {0x1,   0x92,   0x92,   0x96},
        {0x3,   0x93,   0x93,   0x97},
        {0x3,   0x98,   0x98,   0x98},
        {0x3,   0xA3,   0xA3,   0x99},
        {0x3,   0xA6,   0xA6,   0x9A},
        {0x3,   0xA9,   0xA9,   0x9B},
        {0x3,   0xB1,   0xB1,   0x9C},
        {0x3,   0xB4,   0xB5,   0x9D},
        {0x3,   0xC0,   0xC0,   0x9F},
        {0x3,   0xC3,   0xC4,   0xA0},
        {0x3,   0xC6,   0xC6,   0xA2},
        {0x20,  0x22,   0x22,   0xA3},
        {0x20,  0x3C,   0x3C,   0xA4},
        {0x20,  0x7F,   0x7F,   0xA5},
        {0x20,  0xA7,   0xA7,   0xA6},
        {0x21,  0x90,   0x95,   0xA7},
        {0x21,  0xA8,   0xA8,   0xAD},
        {0x22,  0x19,   0x1A,   0xAE},
        {0x22,  0x1E,   0x1F,   0xB0},
        {0x22,  0x29,   0x29,   0xB2},
        {0x22,  0x48,   0x48,   0xB3},
        {0x22,  0x61,   0x61,   0xB4},
        {0x22,  0x64,   0x65,   0xB5},
        {0x23,  0x2,    0x2,    0xB7},
        {0x23,  0x10,   0x10,   0xB8},
        {0x23,  0x20,   0x21,   0xB9},
        {0x25,  0x0,    0x0,    0xBB},
        {0x25,  0x2,    0x2,    0xBC},
        {0x25,  0xC,    0xC,    0xBD},
        {0x25,  0x10,   0x10,   0xBE},
        {0x25,  0x14,   0x14,   0xBF},
        {0x25,  0x18,   0x18,   0xC0},
        {0x25,  0x1C,   0x1C,   0xC1},
        {0x25,  0x24,   0x24,   0xC2},
        {0x25,  0x2C,   0x2C,   0xC3},
        {0x25,  0x34,   0x34,   0xC4},
        {0x25,  0x3C,   0x3C,   0xC5},
        {0x25,  0x50,   0x6C,   0xC6},
        {0x25,  0x80,   0x80,   0xE3},
        {0x25,  0x84,   0x84,   0xE4},
        {0x25,  0x88,   0x88,   0xE5},
        {0x25,  0x8C,   0x8C,   0xE6},
        {0x25,  0x90,   0x93,   0xE7},
        {0x25,  0xA0,   0xA0,   0xEB},
        {0x25,  0xAC,   0xAC,   0xEC},
        {0x25,  0xB2,   0xB2,   0xED},
        {0x25,  0xBA,   0xBA,   0xEE},
        {0x25,  0xBC,   0xBC,   0xEF},
        {0x25,  0xC4,   0xC4,   0xF0},
        {0x25,  0xCB,   0xCB,   0xF1},
        {0x25,  0xD8,   0xD9,   0xF2},
        {0x26,  0x3A,   0x3C,   0xF4},
        {0x26,  0x40,   0x40,   0xF7},
        {0x26,  0x42,   0x42,   0xF8},
        {0x26,  0x60,   0x60,   0xF9},
        {0x26,  0x63,   0x63,   0xFA},
        {0x26,  0x65,   0x66,   0xFB},
        {0x26,  0x6A,   0x6B,   0xFD}
};
/*====================================*/

unsigned short TO_437_TBL[]=  // code map for translation from Unicode to 437, it goes with the header above
{
        0X20, 0X21, 0X22, 0X23, 0X24, 0X25, 0X26, 0X27, 0X28, 0X29, 0X2A, 0X2B, 0X2C, 0X2D, 0X2E, 0X2F,
        0X30, 0X31, 0X32, 0X33, 0X34, 0X35, 0X36, 0X37, 0X38, 0X39, 0X3A, 0X3B, 0X3C, 0X3D, 0X3E, 0X3F,
        0X40, 0X41, 0X42, 0X43, 0X44, 0X45, 0X46, 0X47, 0X48, 0X49, 0X4A, 0X4B, 0X4C, 0X4D, 0X4E, 0X4F,
        0X50, 0X51, 0X52, 0X53, 0X54, 0X55, 0X56, 0X57, 0X58, 0X59, 0X5A, 0X5B, 0X5C, 0X5D, 0X5E, 0X5F,
        0X60, 0X61, 0X62, 0X63, 0X64, 0X65, 0X66, 0X67, 0X68, 0X69, 0X6A, 0X6B, 0X6C, 0X6D, 0X6E, 0X6F,
        0X70, 0X71, 0X72, 0X73, 0X74, 0X75, 0X76, 0X77, 0X78, 0X79, 0X7A, 0X7B, 0X7C, 0X7D, 0X7E, 0XFF,
        0XAD, 0X9B, 0X9C, 0X9D, 0X15, 0XA6, 0XAE, 0XAA, 0XF8, 0XF1, 0XFD, 0XE6, 0X14, 0XFA, 0XA7, 0XAF,
        0XAC, 0XAB, 0XA8, 0X8E, 0X8F, 0X92, 0X80, 0X90, 0XA5, 0X99, 0X9A, 0XE1, 0X85, 0XA0, 0X83, 0X84,
        0X86, 0X91, 0X87, 0X8A, 0X82, 0X88, 0X89, 0X8D, 0XA1, 0X8C, 0X8B, 0XA4, 0X95, 0XA2, 0X93, 0X94,
        0XF6, 0X97, 0XA3, 0X96, 0X81, 0X98, 0X9F, 0XE2, 0XE9, 0XE4, 0XE8, 0XEA, 0XE0, 0XEB, 0XEE, 0XE3,
        0XE5, 0XE7, 0XED, 0X07, 0X13, 0XFC, 0X9E, 0X1B, 0X18, 0X1A, 0X19, 0X1D, 0X12, 0X17, 0XF9, 0XFB,
        0XEC, 0X1C, 0XEF, 0XF7, 0XF0, 0XF3, 0XF2, 0X7F, 0XA9, 0XF4, 0XF5, 0XC4, 0XB3, 0XDA, 0XBF, 0XC0,
        0XD9, 0XC3, 0XB4, 0XC2, 0XC1, 0XC5, 0XCD, 0XBA, 0XD5, 0XD6, 0XC9, 0XB8, 0XB7, 0XBB, 0XD4, 0XD3,
        0XC8, 0XBE, 0XBD, 0XBC, 0XC6, 0XC7, 0XCC, 0XB5, 0XB6, 0XB9, 0XD1, 0XD2, 0XCB, 0XCF, 0XD0, 0XCA,
        0XD8, 0XD7, 0XCE, 0XDF, 0XDC, 0XDB, 0XDD, 0XDE, 0XB0, 0XB1, 0XB2, 0XFE, 0X16, 0X1E, 0X10, 0X1F,
        0X11, 0X09, 0X08, 0X0A, 0X01, 0X02, 0X0F, 0X0C, 0X0B, 0X06, 0X05, 0X03, 0X04, 0X0D, 0X0E
} ;

/********************************************************************************************************/
/*****  The main Latin (I) code Page 850        *****/

#define TO_850_HDR_ENTRIES  51
/*======================================*/

unsigned short FROM_850[]=  // code map for translation from 850 to Unicode
{
        0X0000, 0X263A, 0X263B, 0X2665, 0X2666, 0X2663, 0X2660, 0X2022,
        0X25D8, 0X25CB, 0X25D9, 0X2642, 0X2640, 0X266A, 0X266B, 0X263C,
        0X25BA, 0X25C4, 0X2195, 0X203C, 0X00B6, 0X00A7, 0X25AC, 0X21A8,
        0X2191, 0X2193, 0X2192, 0X2190, 0X221F, 0X2194, 0X25B2, 0X25BC,
        0X0020, 0X0021, 0X0022, 0X0023, 0X0024, 0X0025, 0X0026, 0X0027,
        0X0028, 0X0029, 0X002A, 0X002B, 0X002C, 0X002D, 0X002E, 0X002F,
        0X0030, 0X0031, 0X0032, 0X0033, 0X0034, 0X0035, 0X0036, 0X0037,
        0X0038, 0X0039, 0X003A, 0X003B, 0X003C, 0X003D, 0X003E, 0X003F,
        0X0040, 0X0041, 0X0042, 0X0043, 0X0044, 0X0045, 0X0046, 0X0047,
        0X0048, 0X0049, 0X004A, 0X004B, 0X004C, 0X004D, 0X004E, 0X004F,
        0X0050, 0X0051, 0X0052, 0X0053, 0X0054, 0X0055, 0X0056, 0X0057,
        0X0058, 0X0059, 0X005A, 0X005B, 0X005C, 0X005D, 0X005E, 0X005F,
        0X0060, 0X0061, 0X0062, 0X0063, 0X0064, 0X0065, 0X0066, 0X0067,
        0X0068, 0X0069, 0X006A, 0X006B, 0X006C, 0X006D, 0X006E, 0X006F,
        0X0070, 0X0071, 0X0072, 0X0073, 0X0074, 0X0075, 0X0076, 0X0077,
        0X0078, 0X0079, 0X007A, 0X007B, 0X007C, 0X007D, 0X007E, 0X2302,
        0X00C7, 0X00FC, 0X00E9, 0X00E2, 0X00E4, 0X00E0, 0X00E5, 0X00E7,
        0X00EA, 0X00EB, 0X00E8, 0X00EF, 0X00EE, 0X00EC, 0X00C4, 0X00C5,
        0X00C9, 0X00E6, 0X00C6, 0X00F4, 0X00F6, 0X00F2, 0X00FB, 0X00F9,
        0X00FF, 0X00D6, 0X00DC, 0X00F8, 0X00A3, 0X00D8, 0X00D7, 0X0192,
        0X00E1, 0X00ED, 0X00F3, 0X00FA, 0X00F1, 0X00D1, 0X00AA, 0X00BA,
        0X00BF, 0X00AE, 0X00AC, 0X00BD, 0X00BC, 0X00A1, 0X00AB, 0X00BB,
        0X2591, 0X2592, 0X2593, 0X2502, 0X2524, 0X00C1, 0X00C2, 0X00C0,
        0X00A9, 0X2563, 0X2551, 0X2557, 0X255D, 0X00A2, 0X00A5, 0X2510,
        0X2514, 0X2534, 0X252C, 0X251C, 0X2500, 0X253C, 0X00E3, 0X00C3,
        0X255A, 0X2554, 0X2569, 0X2566, 0X2560, 0X2550, 0X256C, 0X00A4,
        0X00F0, 0X00D0, 0X00CA, 0X00CB, 0X00C8, 0X0131, 0X00CD, 0X00CE,
        0X00CF, 0X2518, 0X250C, 0X2588, 0X2584, 0X00A6, 0X00CC, 0X2580,
        0X00D3, 0X00DF, 0X00D4, 0X00D2, 0X00F5, 0X00D5, 0X00B5, 0X00FE,
        0X00DE, 0X00DA, 0X00DB, 0X00D9, 0X00FD, 0X00DD, 0X00AF, 0X00B4,
        0X00AD, 0X00B1, 0X2017, 0X00BE, 0X00B6, 0X00A7, 0X00F7, 0X00B8,
        0X00B0, 0X00A8, 0X00B7, 0X00B9, 0X00B3, 0X00B2, 0X25A0, 0X00A0
};
/*======================================*/

BR_SMappingHeaderEntry TO_850_HDR[TO_850_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x0,   0x20,   0x7E,   0x0},
        {0x0,   0xA0,   0xFF,   0x5F},
        {0x1,   0x31,   0x31,   0xBF},
        {0x1,   0x92,   0x92,   0xC0},
        {0x20,  0x17,   0x17,   0xC1},
        {0x20,  0x22,   0x22,   0xC2},
        {0x20,  0x3C,   0x3C,   0xC3},
        {0x21,  0x90,   0x95,   0xC4},
        {0x21,  0xA8,   0xA8,   0xCA},
        {0x22,  0x1F,   0x1F,   0xCB},
        {0x23,  0x2,    0x2,    0xCC},
        {0x25,  0x0,    0x0,    0xCD},
        {0x25,  0x2,    0x2,    0xCE},
        {0x25,  0xC,    0xC,    0xCF},
        {0x25,  0x10,   0x10,   0xD0},
        {0x25,  0x14,   0x14,   0xD1},
        {0x25,  0x18,   0x18,   0xD2},
        {0x25,  0x1C,   0x1C,   0xD3},
        {0x25,  0x24,   0x24,   0xD4},
        {0x25,  0x2C,   0x2C,   0xD5},
        {0x25,  0x34,   0x34,   0xD6},
        {0x25,  0x3C,   0x3C,   0xD7},
        {0x25,  0x50,   0x51,   0xD8},
        {0x25,  0x54,   0x54,   0xDA},
        {0x25,  0x57,   0x57,   0xDB},
        {0x25,  0x5A,   0x5A,   0xDC},
        {0x25,  0x5D,   0x5D,   0xDD},
        {0x25,  0x60,   0x60,   0xDE},
        {0x25,  0x63,   0x63,   0xDF},
        {0x25,  0x66,   0x66,   0xE0},
        {0x25,  0x69,   0x69,   0xE1},
        {0x25,  0x6C,   0x6C,   0xE2},
        {0x25,  0x80,   0x80,   0xE3},
        {0x25,  0x84,   0x84,   0xE4},
        {0x25,  0x88,   0x88,   0xE5},
        {0x25,  0x91,   0x93,   0xE6},
        {0x25,  0xA0,   0xA0,   0xE9},
        {0x25,  0xAC,   0xAC,   0xEA},
        {0x25,  0xB2,   0xB2,   0xEB},
        {0x25,  0xBA,   0xBA,   0xEC},
        {0x25,  0xBC,   0xBC,   0xED},
        {0x25,  0xC4,   0xC4,   0xEE},
        {0x25,  0xCB,   0xCB,   0xEF},
        {0x25,  0xD8,   0xD9,   0xF0},
        {0x26,  0x3A,   0x3C,   0xF2},
        {0x26,  0x40,   0x40,   0xF5},
        {0x26,  0x42,   0x42,   0xF6},
        {0x26,  0x60,   0x60,   0xF7},
        {0x26,  0x63,   0x63,   0xF8},
        {0x26,  0x65,   0x66,   0xF9},
        {0x26,  0x6A,   0x6B,   0xFB}
};

/*======================================*/

unsigned short TO_850_TBL[]=  // code map for translation from Unicode to 850, it goes with the header above
{
        0X20, 0X21, 0X22, 0X23, 0X24, 0X25, 0X26, 0X27, 0X28, 0X29, 0X2A, 0X2B, 0X2C, 0X2D, 0X2E, 0X2F,
        0X30, 0X31, 0X32, 0X33, 0X34, 0X35, 0X36, 0X37, 0X38, 0X39, 0X3A, 0X3B, 0X3C, 0X3D, 0X3E, 0X3F,
        0X40, 0X41, 0X42, 0X43, 0X44, 0X45, 0X46, 0X47, 0X48, 0X49, 0X4A, 0X4B, 0X4C, 0X4D, 0X4E, 0X4F,
        0X50, 0X51, 0X52, 0X53, 0X54, 0X55, 0X56, 0X57, 0X58, 0X59, 0X5A, 0X5B, 0X5C, 0X5D, 0X5E, 0X5F,
        0X60, 0X61, 0X62, 0X63, 0X64, 0X65, 0X66, 0X67, 0X68, 0X69, 0X6A, 0X6B, 0X6C, 0X6D, 0X6E, 0X6F,
        0X70, 0X71, 0X72, 0X73, 0X74, 0X75, 0X76, 0X77, 0X78, 0X79, 0X7A, 0X7B, 0X7C, 0X7D, 0X7E, 0XFF,
        0XAD, 0XBD, 0X9C, 0XCF, 0XBE, 0XDD, 0XF5, 0X15, 0XF9, 0XB8, 0XA6, 0XAE, 0XAA, 0XF0, 0XA9, 0XEE,
        0XF8, 0XF1, 0XFD, 0XFC, 0XEF, 0XE6, 0XF4, 0X14, 0XFA, 0XF7, 0XFB, 0XA7, 0XAF, 0XAC, 0XAB, 0XF3,
        0XA8, 0XB7, 0XB5, 0XB6, 0XC7, 0X8E, 0X8F, 0X92, 0X80, 0XD4, 0X90, 0XD2, 0XD3, 0XDE, 0XD6, 0XD7,
        0XD8, 0XD1, 0XA5, 0XE3, 0XE0, 0XE2, 0XE5, 0X99, 0X9E, 0X9D, 0XEB, 0XE9, 0XEA, 0X9A, 0XED, 0XE8,
        0XE1, 0X85, 0XA0, 0X83, 0XC6, 0X84, 0X86, 0X91, 0X87, 0X8A, 0X82, 0X88, 0X89, 0X8D, 0XA1, 0X8C,
        0X8B, 0XD0, 0XA4, 0X95, 0XA2, 0X93, 0XE4, 0X94, 0XF6, 0X9B, 0X97, 0XA3, 0X96, 0X81, 0XEC, 0XE7,
        0X98, 0XD5, 0X9F, 0XF2, 0X07, 0X13, 0X1B, 0X18, 0X1A, 0X19, 0X1D, 0X12, 0X17, 0X1C, 0X7F, 0XC4,
        0XB3, 0XDA, 0XBF, 0XC0, 0XD9, 0XC3, 0XB4, 0XC2, 0XC1, 0XC5, 0XCD, 0XBA, 0XC9, 0XBB, 0XC8, 0XBC,
        0XCC, 0XB9, 0XCB, 0XCA, 0XCE, 0XDF, 0XDC, 0XDB, 0XB0, 0XB1, 0XB2, 0XFE, 0X16, 0X1E, 0X10, 0X1F,
        0X11, 0X9, 0X8, 0X0A, 0X1, 0X2, 0X0F, 0X0C, 0X0B, 0X6, 0X5, 0X3, 0X4, 0X0D, 0X0E
};

//********************************************************************************************************

#define TO_852_HDR_ENTRIES      94
//*======================================*

unsigned short FROM_852[]=  // code map for translation from 852 to Unicode
{
        0x0000, 0x263A, 0x263B, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
        0x25D8, 0x25CB, 0x25D9, 0x2642, 0x2640, 0x266A, 0x266B, 0x263C,
        0x25BA, 0x25C4, 0x2195, 0x203C, 0x00B6, 0x00A7, 0x25AC, 0x21A8,
        0x2191, 0x2193, 0x2192, 0x2190, 0x221F, 0x2194, 0x25B2, 0x25BC,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2302,
        0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x016F, 0x0107, 0x00E7,
        0x0142, 0x00EB, 0x0150, 0x0151, 0x00EE, 0x0179, 0x00C4, 0x0106,
        0x00C9, 0x0139, 0x013A, 0x00F4, 0x00F6, 0x013D, 0x013E, 0x015A,
        0x015B, 0x00D6, 0x00DC, 0x0164, 0x0165, 0x0141, 0x00D7, 0x010D,
        0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x0104, 0x0105, 0x017D, 0x017E,
        0x0118, 0x0119, 0x00AC, 0x017A, 0x010C, 0x015F, 0x00AB, 0x00BB,
        0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x00C1, 0x00C2, 0x011A,
        0x015E, 0x2563, 0x2551, 0x2557, 0x255D, 0x017B, 0x017C, 0x2510,
        0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x0102, 0x0103,
        0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x00A4,
        0x0111, 0x0110, 0x010E, 0x00CB, 0x010F, 0x0147, 0x00CD, 0x00CE,
        0x011B, 0x2518, 0x250C, 0x2588, 0x2584, 0x0162, 0x016E, 0x2580,
        0x00D3, 0x00DF, 0x00D4, 0x0143, 0x0144, 0x0148, 0x0160, 0x0161,
        0x0154, 0x00DA, 0x0155, 0x0170, 0x00FD, 0x00DD, 0x0163, 0x00B4,
        0x00AD, 0x02DD, 0x02DB, 0x02C7, 0x02D8, 0x00A7, 0x00F7, 0x00B8,
        0x00B0, 0x00A8, 0x02D9, 0x0171, 0x0158, 0x0159, 0x25A0, 0x00A0
};
//*======================================*/

BR_SMappingHeaderEntry TO_852_HDR[TO_852_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x0,   0x20,   0x7E,   0x0},
        {0x0,   0xA0,   0xA0,   0x5F},
        {0x0,   0xA4,   0xA4,   0x60},
        {0x0,   0xA7,   0xA8,   0x61},
        {0x0,   0xAB,   0xAD,   0x63},
        {0x0,   0xB0,   0xB0,   0x66},
        {0x0,   0xB4,   0xB4,   0x67},
        {0x0,   0xB6,   0xB6,   0x68},
        {0x0,   0xB8,   0xB8,   0x69},
        {0x0,   0xBB,   0xBB,   0x6A},
        {0x0,   0xC1,   0xC2,   0x6B},
        {0x0,   0xC4,   0xC4,   0x6D},
        {0x0,   0xC7,   0xC7,   0x6E},
        {0x0,   0xC9,   0xC9,   0x6F},
        {0x0,   0xCB,   0xCB,   0x70},
        {0x0,   0xCD,   0xCE,   0x71},
        {0x0,   0xD3,   0xD4,   0x73},
        {0x0,   0xD6,   0xD7,   0x75},
        {0x0,   0xDA,   0xDA,   0x77},
        {0x0,   0xDC,   0xDD,   0x78},
        {0x0,   0xDF,   0xDF,   0x7A},
        {0x0,   0xE1,   0xE2,   0x7B},
        {0x0,   0xE4,   0xE4,   0x7D},
        {0x0,   0xE7,   0xE7,   0x7E},
        {0x0,   0xE9,   0xE9,   0x7F},
        {0x0,   0xEB,   0xEB,   0x80},
        {0x0,   0xED,   0xEE,   0x81},
        {0x0,   0xF3,   0xF4,   0x83},
        {0x0,   0xF6,   0xF7,   0x85},
        {0x0,   0xFA,   0xFA,   0x87},
        {0x0,   0xFC,   0xFD,   0x88},
        {0x1,   0x2,    0x7,    0x8A},
        {0x1,   0xC,    0x11,   0x90},
        {0x1,   0x18,   0x1B,   0x96},
        {0x1,   0x39,   0x3A,   0x9A},
        {0x1,   0x3D,   0x3E,   0x9C},
        {0x1,   0x41,   0x44,   0x9E},
        {0x1,   0x47,   0x48,   0xA2},
        {0x1,   0x50,   0x51,   0xA4},
        {0x1,   0x54,   0x55,   0xA6},
        {0x1,   0x58,   0x5B,   0xA8},
        {0x1,   0x5E,   0x65,   0xAC},
        {0x1,   0x6E,   0x71,   0xB4},
        {0x1,   0x79,   0x7E,   0xB8},
        {0x2,   0xC7,   0xC7,   0xBE},
        {0x2,   0xD8,   0xD9,   0xBF},
        {0x2,   0xDB,   0xDB,   0xC1},
        {0x2,   0xDD,   0xDD,   0xC2},
        {0x20,  0x22,   0x22,   0xC3},
        {0x20,  0x3C,   0x3C,   0xC4},
        {0x21,  0x90,   0x95,   0xC5},
        {0x21,  0xA8,   0xA8,   0xCB},
        {0x22,  0x1F,   0x1F,   0xCC},
        {0x23,  0x2,    0x2,    0xCD},
        {0x25,  0x0,    0x0,    0xCE},
        {0x25,  0x2,    0x2,    0xCF},
        {0x25,  0xC,    0xC,    0xD0},
        {0x25,  0x10,   0x10,   0xD1},
        {0x25,  0x14,   0x14,   0xD2},
        {0x25,  0x18,   0x18,   0xD3},
        {0x25,  0x1C,   0x1C,   0xD4},
        {0x25,  0x24,   0x24,   0xD5},
        {0x25,  0x2C,   0x2C,   0xD6},
        {0x25,  0x34,   0x34,   0xD7},
        {0x25,  0x3C,   0x3C,   0xD8},
        {0x25,  0x50,   0x51,   0xD9},
        {0x25,  0x54,   0x54,   0xDB},
        {0x25,  0x57,   0x57,   0xDC},
        {0x25,  0x5A,   0x5A,   0xDD},
        {0x25,  0x5D,   0x5D,   0xDE},
        {0x25,  0x60,   0x60,   0xDF},
        {0x25,  0x63,   0x63,   0xE0},
        {0x25,  0x66,   0x66,   0xE1},
        {0x25,  0x69,   0x69,   0xE2},
        {0x25,  0x6C,   0x6C,   0xE3},
        {0x25,  0x80,   0x80,   0xE4},
        {0x25,  0x84,   0x84,   0xE5},
        {0x25,  0x88,   0x88,   0xE6},
        {0x25,  0x91,   0x93,   0xE7},
        {0x25,  0xA0,   0xA0,   0xEA},
        {0x25,  0xAC,   0xAC,   0xEB},
        {0x25,  0xB2,   0xB2,   0xEC},
        {0x25,  0xBA,   0xBA,   0xED},
        {0x25,  0xBC,   0xBC,   0xEE},
        {0x25,  0xC4,   0xC4,   0xEF},
        {0x25,  0xCB,   0xCB,   0xF0},
        {0x25,  0xD8,   0xD9,   0xF1},
        {0x26,  0x3A,   0x3C,   0xF3},
        {0x26,  0x40,   0x40,   0xF6},
        {0x26,  0x42,   0x42,   0xF7},
        {0x26,  0x60,   0x60,   0xF8},
        {0x26,  0x63,   0x63,   0xF9},
        {0x26,  0x65,   0x66,   0xFA},
        {0x26,  0x6A,   0x6B,   0xFC}
};
unsigned short TO_852_TBL[]=  // code map for translation from Unicode to 852, it goes with the header above
{
        0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27,   0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,   0x2F,
        0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,   0x39,   0x3A,   0x3B,   0x3C,   0x3D,   0x3E,   0x3F,
        0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   0x48,   0x49,   0x4A,   0x4B,   0x4C,   0x4D,   0x4E,   0x4F,
        0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,   0x58,   0x59,   0x5A,   0x5B,   0x5C,   0x5D,   0x5E,   0x5F,
        0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,   0x68,   0x69,   0x6A,   0x6B,   0x6C,   0x6D,   0x6E,   0x6F,
        0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,   0x78,   0x79,   0x7A,   0x7B,   0x7C,   0x7D,   0x7E,   0xFF,
        0xCF,   0x15,   0xF5,   0xF9,   0xAE,   0xAA,   0xF0,   0xF8,   0xEF,   0x14,   0xF7,   0xAF,   0xB5,   0xB6,   0x8E,   0x80,
        0x90,   0xD3,   0xD6,   0xD7,   0xE0,   0xE2,   0x99,   0x9E,   0xE9,   0x9A,   0xED,   0xE1,   0xA0,   0x83,   0x84,   0x87,
        0x82,   0x89,   0xA1,   0x8C,   0xA2,   0x93,   0x94,   0xF6,   0xA3,   0x81,   0xEC,   0xC6,   0xC7,   0xA4,   0xA5,   0x8F,
        0x86,   0xAC,   0x9F,   0xD2,   0xD4,   0xD1,   0xD0,   0xA8,   0xA9,   0xB7,   0xD8,   0x91,   0x92,   0x95,   0x96,   0x9D,
        0x88,   0xE3,   0xE4,   0xD5,   0xE5,   0x8A,   0x8B,   0xE8,   0xEA,   0xFC,   0xFD,   0x97,   0x98,   0xB8,   0xAD,   0xE6,
        0xE7,   0xDD,   0xEE,   0x9B,   0x9C,   0xDE,   0x85,   0xEB,   0xFB,   0x8D,   0xAB,   0xBD,   0xBE,   0xA6,   0xA7,   0xF3,
        0xF4,   0xFA,   0xF2,   0xF1,   0x07,   0x13,   0x1B,   0x18,   0x1A,   0x19,   0x1D,   0x12,   0x17,   0x1C,   0x7F,   0xC4,
        0xB3,   0xDA,   0xBF,   0xC0,   0xD9,   0xC3,   0xB4,   0xC2,   0xC1,   0xC5,   0xCD,   0xBA,   0xC9,   0xBB,   0xC8,   0xBC,
        0xCC,   0xB9,   0xCB,   0xCA,   0xCE,   0xDF,   0xDC,   0xDB,   0xB0,   0xB1,   0xB2,   0xFE,   0x16,   0x1E,   0x10,   0x1F,
        0x11,   0x09,   0x08,   0x0A,   0x01,   0x02,   0x0F,   0x0C,   0x0B,   0x06,   0x05,   0x03,   0x04,   0x0D,   0x0E
};

//********************************************************************************************************

#define TO_860_HDR_ENTRIES

//*======================================*

unsigned short FROM_860[]=  // code map for translation from 860 to Unicode
{
        0x0000, 0x263A, 0x263B, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
        0x25D8, 0x25CB, 0x25D9, 0x2642, 0x2640, 0x266A, 0x266B, 0x263C,
        0x25BA, 0x25C4, 0x2195, 0x203C, 0x00B6, 0x00A7, 0x25AC, 0x21A8,
        0x2191, 0x2193, 0x2192, 0x2190, 0x221F, 0x2194, 0x25B2, 0x25BC,
        0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
        0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
        0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
        0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
        0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
        0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
        0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
        0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
        0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
        0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
        0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
        0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2302,
        0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E3, 0x00E0, 0x00C1, 0x00E7,
        0x00EA, 0x00CA, 0x00E8, 0x00CD, 0x00D4, 0x00EC, 0x00C3, 0x00C2,
        0x00C9, 0x00C0, 0x00C8, 0x00F4, 0x00F5, 0x00F2, 0x00DA, 0x00F9,
        0x00CC, 0x00D5, 0x00DC, 0x00A2, 0x00A3, 0x00D9, 0x20A7, 0x00D3,
        0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA,
        0x00BF, 0x00D2, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00BB,
        0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
        0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 0x255B, 0x2510,
        0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x255E, 0x255F,
        0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x2567,
        0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256B,
        0x256A, 0x2518, 0x250C, 0x2588, 0x2584, 0x258C, 0x2590, 0x2580,
        0x03B1, 0x00DF, 0x0393, 0x03C0, 0x03A3, 0x03C3, 0x00B5, 0x03C4,
        0x03A6, 0x0398, 0x03A9, 0x03B4, 0x221E, 0x03C6, 0x03B5, 0x2229,
        0x2261, 0x00B1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00F7, 0x2248,
        0x00B0, 0x2219, 0x00B7, 0x221A, 0x207F, 0x00B2, 0x25A0, 0x00A0
};
//*======================================*/

BR_SMappingHeaderEntry TO_860_HDR[TO_860_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
       {0x00,   0x20,   0xFC,   0x00},
       {0x03,   0x93,   0xC6,   0xDD},
       {0x20,   0x22,   0xA7,   0x111},
       {0x21,   0x90,   0xA8,   0x197},
       {0x22,   0x19,   0x65,   0x1B0},
       {0x23,   0x02,   0x21,   0x1FD},
       {0x25,   0x00,   0xD9,   0x21D},
       {0x26,   0x3A,   0x6B,   0x2F7}
};

unsigned short TO_860_TBL[]=  // code map for translation from Unicode to 860, it goes with the header above
{
0x00,   0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27,   0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,
0x2F,   0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,   0x39,   0x3A,   0x3B,   0x3C,   0x3D,   0x3E,
0x3F,   0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   0x48,   0x49,   0x4A,   0x4B,   0x4C,   0x4D,   0x4E,
0x4F,   0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,   0x58,   0x59,   0x5A,   0x5B,   0x5C,   0x5D,   0x5E,
0x5F,   0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,   0x68,   0x69,   0x6A,   0x6B,   0x6C,   0x6D,   0x6E,
0x6F,   0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,   0x78,   0x79,   0x7A,   0x7B,   0x7C,   0x7D,   0x7E,
0xFF,   0xAD,   0x9B,   0x9C,   0x15,   0xA6,   0xAE,   0xAA,   0xF8,   0xF1,   0xFD,   0xE6,   0x14,   0xFA,   0xA7,   0xAF,
0xAC,   0xAB,   0xA8,   0x91,   0x86,   0x8F,   0x8E,   0x80,   0x92,   0x90,   0x89,   0x98,   0x8B,   0xA5,   0xA9,   0x9F,
0x8C,   0x99,   0x9D,   0x96,   0x9A,   0xE1,   0x85,   0xA0,   0x83,   0x84,   0x87,   0x8A,   0x82,   0x88,   0x8D,   0xA1,
0xA4,   0x95,   0xA2,   0x93,   0x94,   0xF6,   0x97,   0xA3,   0x81,   0xE2,   0xE9,   0xE4,   0xE8,   0xEA,   0xE0,   0xEB,
0xEE,   0xE3,   0xE5,   0xE7,   0xED,   0x7,    0x13,   0xFC,   0x9E,   0x1B,   0x18,   0x1A,   0x19,   0x1D,   0x12,   0x17,
0xF9,   0xFB,   0xEC,   0x1C,   0xEF,   0xF7,   0xF0,   0xF3,   0xF2,   0x7F,   0xF4,   0xF5,   0xC4,   0xB3,   0xDA,   0xBF,
0xC0,   0xD9,   0xC3,   0xB4,   0xC2,   0xC1,   0xC5,   0xCD,   0xBA,   0xD5,   0xD6,   0xC9,   0xB8,   0xB7,   0xBB,   0xD4,
0xD3,   0xC8,   0xBE,   0xBD,   0xBC,   0xC6,   0xC7,   0xCC,   0xB5,   0xB6,   0xB9,   0xD1,   0xD2,   0xCB,   0xCF,   0xD0,
0xCA,   0xD8,   0xD7,   0xCE,   0xDF,   0xDC,   0xDB,   0xDD,   0xDE,   0xB0,   0xB1,   0xB2,   0xFE,   0x16,   0x1E,   0x10,
0x1F,   0x11,   0x9,    0x8,    0x0A,   0x1,    0x2,    0x0F,   0x0C,   0x0B,   0x6,    0x5,    0x3,    0x4,    0x0D,   0x0E
};

//********************************************************************************************************
/*******        French Canadian         *********/
#define TO_863_HDR_ENTRIES      79
//*======================================*

unsigned short FROM_863[]=  // code map for translation from 863 to Unicode

        {
                0xFEFF, 0x263A, 0x263B, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
                0x25D8, 0x25CB, 0x25D9, 0x2642, 0x2640, 0x266A, 0x266B, 0x263C,
                0x25BA, 0x25C4, 0x2195, 0x203C, 0x00B6, 0x00A7, 0x25AC, 0x21A8,
                0x2191, 0x2193, 0x2192, 0x2190, 0x221F, 0x2194, 0x25B2, 0x25BC,
                0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
                0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
                0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
                0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
                0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
                0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
                0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
                0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
                0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
                0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
                0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
                0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2302,
                0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00C2, 0x00E0, 0x00B6, 0x00E7,
                0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x2017, 0x00C0, 0x00A7,
                0x00C9, 0x00C8, 0x00CA, 0x00F4, 0x00CB, 0x00CF, 0x00FB, 0x00F9,
                0x00A4, 0x00D4, 0x00DC, 0x00A2, 0x00A3, 0x00D9, 0x00DB, 0x0192,
                0x00A6, 0x00B4, 0x00F3, 0x00FA, 0x00A8, 0x00B8, 0x00B3, 0x00AF,
                0x00CE, 0x2310, 0x00AC, 0x00BD, 0x00BC, 0x00BE, 0x00AB, 0x00BB,
                0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
                0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 0x255B, 0x2510,
                0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x255E, 0x255F,
                0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x2567,
                0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256B,
                0x256A, 0x2518, 0x250C, 0x2588, 0x2584, 0x258C, 0x2590, 0x2580,
                0x03B1, 0x00DF, 0x0393, 0x03C0, 0x03A3, 0x03C3, 0x00B5, 0x03C4,
                0x03A6, 0x0398, 0x03A9, 0x03B4, 0x221E, 0x03C6, 0x03B5, 0x2229,
                0x2261, 0x00B1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00F7, 0x2248,
                0x00B0, 0x2219, 0x00B7, 0x221A, 0x207F, 0x00B2, 0x25A0, 0x00A0
        };
//*======================================*/

BR_SMappingHeaderEntry TO_863_HDR[TO_863_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart
{
        {0x0,   0x20,   0x7E,   0x0},
        {0x0,   0xA0,   0xA0,   0x5F},
        {0x0,   0xA2,   0xA4,   0x60},
        {0x0,   0xA6,   0xA8,   0x63},
        {0x0,   0xAB,   0xAC,   0x66},
        {0x0,   0xAF,   0xB8,   0x68},
        {0x0,   0xBB,   0xBE,   0x72},
        {0x0,   0xC0,   0xC0,   0x76},
        {0x0,   0xC2,   0xC2,   0x77},
        {0x0,   0xC7,   0xCB,   0x78},
        {0x0,   0xCE,   0xCF,   0x7D},
        {0x0,   0xD4,   0xD4,   0x7F},
        {0x0,   0xD9,   0xD9,   0x80},
        {0x0,   0xDB,   0xDC,   0x81},
        {0x0,   0xDF,   0xE0,   0x83},
        {0x0,   0xE2,   0xE2,   0x85},
        {0x0,   0xE7,   0xEB,   0x86},
        {0x0,   0xEE,   0xEF,   0x8B},
        {0x0,   0xF3,   0xF4,   0x8D},
        {0x0,   0xF7,   0xF7,   0x8F},
        {0x0,   0xF9,   0xFC,   0x90},
        {0x1,   0x92,   0x92,   0x94},
        {0x3,   0x93,   0x93,   0x95},
        {0x3,   0x98,   0x98,   0x96},
        {0x3,   0xA3,   0xA3,   0x97},
        {0x3,   0xA6,   0xA6,   0x98},
        {0x3,   0xA9,   0xA9,   0x99},
        {0x3,   0xB1,   0xB1,   0x9A},
        {0x3,   0xB4,   0xB5,   0x9B},
        {0x3,   0xC0,   0xC0,   0x9D},
        {0x3,   0xC3,   0xC4,   0x9E},
        {0x3,   0xC6,   0xC6,   0xA0},
        {0x20,  0x17,   0x17,   0xA1},
        {0x20,  0x22,   0x22,   0xA2},
        {0x20,  0x3C,   0x3C,   0xA3},
        {0x20,  0x7F,   0x7F,   0xA4},
        {0x21,  0x90,   0x95,   0xA5},
        {0x21,  0xA8,   0xA8,   0xAB},
        {0x22,  0x19,   0x1A,   0xAC},
        {0x22,  0x1E,   0x1F,   0xAE},
        {0x22,  0x29,   0x29,   0xB0},
        {0x22,  0x48,   0x48,   0xB1},
        {0x22,  0x61,   0x61,   0xB2},
        {0x22,  0x64,   0x65,   0xB3},
        {0x23,  0x2,    0x2,    0xB5},
        {0x23,  0x10,   0x10,   0xB6},
        {0x23,  0x20,   0x21,   0xB7},
        {0x25,  0x0,    0x0,    0xB9},
        {0x25,  0x2,    0x2,    0xBA},
        {0x25,  0xC,    0xC,    0xBB},
        {0x25,  0x10,   0x10,   0xBC},
        {0x25,  0x14,   0x14,   0xBD},
        {0x25,  0x18,   0x18,   0xBE},
        {0x25,  0x1C,   0x1C,   0xBF},
        {0x25,  0x24,   0x24,   0xC0},
        {0x25,  0x2C,   0x2C,   0xC1},
        {0x25,  0x34,   0x34,   0xC2},
        {0x25,  0x3C,   0x3C,   0xC3},
        {0x25,  0x50,   0x6C,   0xC4},
        {0x25,  0x80,   0x80,   0xE1},
        {0x25,  0x84,   0x84,   0xE2},
        {0x25,  0x88,   0x88,   0xE3},
        {0x25,  0x8C,   0x8C,   0xE4},
        {0x25,  0x90,   0x93,   0xE5},
        {0x25,  0xA0,   0xA0,   0xE9},
        {0x25,  0xAC,   0xAC,   0xEA},
        {0x25,  0xB2,   0xB2,   0xEB},
        {0x25,  0xBA,   0xBA,   0xEC},
        {0x25,  0xBC,   0xBC,   0xED},
        {0x25,  0xC4,   0xC4,   0xEE},
        {0x25,  0xCB,   0xCB,   0xEF},
        {0x25,  0xD8,   0xD9,   0xF0},
        {0x26,  0x3A,   0x3C,   0xF2},
        {0x26,  0x40,   0x40,   0xF5},
        {0x26,  0x42,   0x42,   0xF6},
        {0x26,  0x60,   0x60,   0xF7},
        {0x26,  0x63,   0x63,   0xF8},
        {0x26,  0x65,   0x66,   0xF9},
        {0x26,  0x6A,   0x6B,   0xFB}
};

//*======================================*
unsigned short TO_863_TBL[]=  // code map for translation from Unicode to 863, it goes with the header above
{
        0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27,   0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,   0x2F,
        0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,   0x39,   0x3A,   0x3B,   0x3C,   0x3D,   0x3E,   0x3F,
        0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   0x48,   0x49,   0x4A,   0x4B,   0x4C,   0x4D,   0x4E,   0x4F,
        0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,   0x58,   0x59,   0x5A,   0x5B,   0x5C,   0x5D,   0x5E,   0x5F,
        0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,   0x68,   0x69,   0x6A,   0x6B,   0x6C,   0x6D,   0x6E,   0x6F,
        0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,   0x78,   0x79,   0x7A,   0x7B,   0x7C,   0x7D,   0x7E,   0xFF,
        0x9B,   0x9C,   0x98,   0xA0,   0x15,   0x8F,   0xA4,   0xAE,   0xAA,   0xA7,   0xF8,   0xF1,   0xFD,   0xA6,   0xA1,   0xE6,
        0x14,   0x86,   0xFA,   0xA5,   0xAF,   0xAC,   0xAB,   0xAD,   0x8E,   0x84,   0x80,   0x91,   0x90,   0x92,   0x94,   0xA8,
        0x95,   0x99,   0x9D,   0x9E,   0x9A,   0xE1,   0x85,   0x83,   0x87,   0x8A,   0x82,   0x88,   0x89,   0x8C,   0x8B,   0xA2,
        0x93,   0xF6,   0x97,   0xA3,   0x96,   0x81,   0x9F,   0xE2,   0xE9,   0xE4,   0xE8,   0xEA,   0xE0,   0xEB,   0xEE,   0xE3,
        0xE5,   0xE7,   0xED,   0x8D,   0x07,   0x13,   0xFC,   0x1B,   0x18,   0x1A,   0x19,   0x1D,   0x12,   0x17,   0xF9,   0xFB,
        0xEC,   0x1C,   0xEF,   0xF7,   0xF0,   0xF3,   0xF2,   0x7F,   0xA9,   0xF4,   0xF5,   0xC4,   0xB3,   0xDA,   0xBF,   0xC0,
        0xD9,   0xC3,   0xB4,   0xC2,   0xC1,   0xC5,   0xCD,   0xBA,   0xD5,   0xD6,   0xC9,   0xB8,   0xB7,   0xBB,   0xD4,   0xD3,
        0xC8,   0xBE,   0xBD,   0xBC,   0xC6,   0xC7,   0xCC,   0xB5,   0xB6,   0xB9,   0xD1,   0xD2,   0xCB,   0xCF,   0xD0,   0xCA,
        0xD8,   0xD7,   0xCE,   0xDF,   0xDC,   0xDB,   0xDD,   0xDE,   0xB0,   0xB1,   0xB2,   0xFE,   0x16,   0x1E,   0x10,   0x1F,
        0x11,   0x09,   0x08,   0x0A,   0x01,   0x02,   0x0F,   0x0C,   0x0B,   0x06,   0x05,   0x03,   0x04,   0x0D,   0x0E
};

/********************************************************************************************************/

/*      Nordic  */

#define TO_865_HDR_ENTRIES  80
/*======================================*/

unsigned short FROM_865[]=  // code map for translation from 865 to Unicode
        {
                0x263A, 0xFEFF, 0x263B, 0x2665, 0x2666, 0x2663, 0x2660, 0x2022,
                0x25D8, 0x25CB, 0x25D9, 0x2642, 0x2640, 0x266A, 0x266B, 0x263C,
                0x25BA, 0x25C4, 0x2195, 0x203C, 0x00B6, 0x00A7, 0x25AC, 0x21A8,
                0x2191, 0x2193, 0x2192, 0x2190, 0x221F, 0x2194, 0x25B2, 0x25BC,
                0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
                0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
                0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
                0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
                0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
                0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
                0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
                0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
                0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
                0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
                0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
                0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x2302,
                0x00C7, 0x00FC, 0x00E9, 0x00E2, 0x00E4, 0x00E0, 0x00E5, 0x00E7,
                0x00EA, 0x00EB, 0x00E8, 0x00EF, 0x00EE, 0x00EC, 0x00C4, 0x00C5,
                0x00C9, 0x00E6, 0x00C6, 0x00F4, 0x00F6, 0x00F2, 0x00FB, 0x00F9,
                0x00FF, 0x00D6, 0x00DC, 0x00F8, 0x00A3, 0x00D8, 0x20A7, 0x0192,
                0x00E1, 0x00ED, 0x00F3, 0x00FA, 0x00F1, 0x00D1, 0x00AA, 0x00BA,
                0x00BF, 0x2310, 0x00AC, 0x00BD, 0x00BC, 0x00A1, 0x00AB, 0x00A4,
                0x2591, 0x2592, 0x2593, 0x2502, 0x2524, 0x2561, 0x2562, 0x2556,
                0x2555, 0x2563, 0x2551, 0x2557, 0x255D, 0x255C, 0x255B, 0x2510,
                0x2514, 0x2534, 0x252C, 0x251C, 0x2500, 0x253C, 0x255E, 0x255F,
                0x255A, 0x2554, 0x2569, 0x2566, 0x2560, 0x2550, 0x256C, 0x2567,
                0x2568, 0x2564, 0x2565, 0x2559, 0x2558, 0x2552, 0x2553, 0x256B,
                0x256A, 0x2518, 0x250C, 0x2588, 0x2584, 0x258C, 0x2590, 0x2580,
                0x03B1, 0x00DF, 0x0393, 0x03C0, 0x03A3, 0x03C3, 0x00B5, 0x03C4,
                0x03A6, 0x0398, 0x03A9, 0x03B4, 0x221E, 0x03C6, 0x03B5, 0x2229,
                0x2261, 0x00B1, 0x2265, 0x2264, 0x2320, 0x2321, 0x00F7, 0x2248,
                0x00B0, 0x2219, 0x00B7, 0x221A, 0x207F, 0x00B2, 0x25A0, 0x00A0
        };
/*======================================*/

BR_SMappingHeaderEntry TO_865_HDR[TO_865_HDR_ENTRIES] =
//      Page    UStart  Uend    Tstart

{
        {0x0,   0x0,    0x0,    0x0},
        {0x0,   0x20,   0x7E,   0x1},
        {0x0,   0xA0,   0xA1,   0x60},
        {0x0,   0xA3,   0xA4,   0x62},
        {0x0,   0xA7,   0xA7,   0x64},
        {0x0,   0xAA,   0xAC,   0x65},
        {0x0,   0xB0,   0xB2,   0x68},
        {0x0,   0xB5,   0xB7,   0x6B},
        {0x0,   0xBA,   0xBA,   0x6E},
        {0x0,   0xBC,   0xBD,   0x6F},
        {0x0,   0xBF,   0xBF,   0x71},
        {0x0,   0xC4,   0xC7,   0x72},
        {0x0,   0xC9,   0xC9,   0x76},
        {0x0,   0xD1,   0xD1,   0x77},
        {0x0,   0xD6,   0xD6,   0x78},
        {0x0,   0xD8,   0xD8,   0x79},
        {0x0,   0xDC,   0xDC,   0x7A},
        {0x0,   0xDF,   0xE2,   0x7B},
        {0x0,   0xE4,   0xEF,   0x7F},
        {0x0,   0xF1,   0xF4,   0x8B},
        {0x0,   0xF6,   0xFC,   0x8F},
        {0x0,   0xFF,   0xFF,   0x96},
        {0x1,   0x92,   0x92,   0x97},
        {0x3,   0x93,   0x93,   0x98},
        {0x3,   0x98,   0x98,   0x99},
        {0x3,   0xA3,   0xA3,   0x9A},
        {0x3,   0xA6,   0xA6,   0x9B},
        {0x3,   0xA9,   0xA9,   0x9C},
        {0x3,   0xB1,   0xB1,   0x9D},
        {0x3,   0xB4,   0xB5,   0x9E},
        {0x3,   0xC0,   0xC0,   0xA0},
        {0x3,   0xC3,   0xC4,   0xA1},
        {0x3,   0xC6,   0xC6,   0xA3},
        {0x20,  0x22,   0x22,   0xA4},
        {0x20,  0x3C,   0x3C,   0xA5},
        {0x20,  0x7F,   0x7F,   0xA6},
        {0x20,  0xA7,   0xA7,   0xA7},
        {0x21,  0x90,   0x95,   0xA8},
        {0x21,  0xA8,   0xA8,   0xAE},
        {0x22,  0x19,   0x1A,   0xAF},
        {0x22,  0x1E,   0x1F,   0xB1},
        {0x22,  0x29,   0x29,   0xB3},
        {0x22,  0x48,   0x48,   0xB4},
        {0x22,  0x61,   0x61,   0xB5},
        {0x22,  0x64,   0x65,   0xB6},
        {0x23,  0x2,    0x2,    0xB8},
        {0x23,  0x10,   0x10,   0xB9},
        {0x23,  0x20,   0x21,   0xBA},
        {0x25,  0x0,    0x0,    0xBC},
        {0x25,  0x2,    0x2,    0xBD},
        {0x25,  0xC,    0xC,    0xBE},
        {0x25,  0x10,   0x10,   0xBF},
        {0x25,  0x14,   0x14,   0xC0},
        {0x25,  0x18,   0x18,   0xC1},
        {0x25,  0x1C,   0x1C,   0xC2},
        {0x25,  0x24,   0x24,   0xC3},
        {0x25,  0x2C,   0x2C,   0xC4},
        {0x25,  0x34,   0x34,   0xC5},
        {0x25,  0x3C,   0x3C,   0xC6},
        {0x25,  0x50,   0x6C,   0xC7},
        {0x25,  0x80,   0x80,   0xE4},
        {0x25,  0x84,   0x84,   0xE5},
        {0x25,  0x88,   0x88,   0xE6},
        {0x25,  0x8C,   0x8C,   0xE7},
        {0x25,  0x90,   0x93,   0xE8},
        {0x25,  0xA0,   0xA0,   0xEC},
        {0x25,  0xAC,   0xAC,   0xED},
        {0x25,  0xB2,   0xB2,   0xEE},
        {0x25,  0xBA,   0xBA,   0xEF},
        {0x25,  0xBC,   0xBC,   0xF0},
        {0x25,  0xC4,   0xC4,   0xF1},
        {0x25,  0xCB,   0xCB,   0xF2},
        {0x25,  0xD8,   0xD9,   0xF3},
        {0x26,  0x3A,   0x3C,   0xF5},
        {0x26,  0x40,   0x40,   0xF8},
        {0x26,  0x42,   0x42,   0xF9},
        {0x26,  0x60,   0x60,   0xFA},
        {0x26,  0x63,   0x63,   0xFB},
        {0x26,  0x65,   0x66,   0xFC},
        {0x26,  0x6A,   0x6B,   0xFE}
};


unsigned short TO_865_TBL[]=  // code map for translation from Unicode to MAC, it goes with the header above
{
        0x20,   0x21,   0x22,   0x23,   0x24,   0x25,   0x26,   0x27,   0x28,   0x29,   0x2A,   0x2B,   0x2C,   0x2D,   0x2E,   0x2F,
        0x30,   0x31,   0x32,   0x33,   0x34,   0x35,   0x36,   0x37,   0x38,   0x39,   0x3A,   0x3B,   0x3C,   0x3D,   0x3E,   0x3F,
        0x40,   0x41,   0x42,   0x43,   0x44,   0x45,   0x46,   0x47,   0x48,   0x49,   0x4A,   0x4B,   0x4C,   0x4D,   0x4E,   0x4F,
        0x50,   0x51,   0x52,   0x53,   0x54,   0x55,   0x56,   0x57,   0x58,   0x59,   0x5A,   0x5B,   0x5C,   0x5D,   0x5E,   0x5F,
        0x60,   0x61,   0x62,   0x63,   0x64,   0x65,   0x66,   0x67,   0x68,   0x69,   0x6A,   0x6B,   0x6C,   0x6D,   0x6E,   0x6F,
        0x70,   0x71,   0x72,   0x73,   0x74,   0x75,   0x76,   0x77,   0x78,   0x79,   0x7A,   0x7B,   0x7C,   0x7D,   0x7E,   0xFF,
        0xAD,   0x9C,   0xAF,   0x15,   0xA6,   0xAE,   0xAA,   0xF8,   0xF1,   0xFD,   0xE6,   0x14,   0xFA,   0xA7,   0xAC,   0xAB,
        0xA8,   0x8E,   0x8F,   0x92,   0x80,   0x90,   0xA5,   0x99,   0x9D,   0x9A,   0xE1,   0x85,   0xA0,   0x83,   0x84,   0x86,
        0x91,   0x87,   0x8A,   0x82,   0x88,   0x89,   0x8D,   0xA1,   0x8C,   0x8B,   0xA4,   0x95,   0xA2,   0x93,   0x94,   0xF6,
        0x9B,   0x97,   0xA3,   0x96,   0x81,   0x98,   0x9F,   0xE2,   0xE9,   0xE4,   0xE8,   0xEA,   0xE0,   0xEB,   0xEE,   0xE3,
        0xE5,   0xE7,   0xED,   0x07,   0x13,   0xFC,   0x9E,   0x1B,   0x18,   0x1A,   0x19,   0x1D,   0x12,   0x17,   0xF9,   0xFB,
        0xEC,   0x1C,   0xEF,   0xF7,   0xF0,   0xF3,   0xF2,   0x7F,   0xA9,   0xF4,   0xF5,   0xC4,   0xB3,   0xDA,   0xBF,   0xC0,
        0xD9,   0xC3,   0xB4,   0xC2,   0xC1,   0xC5,   0xCD,   0xBA,   0xD5,   0xD6,   0xC9,   0xB8,   0xB7,   0xBB,   0xD4,   0xD3,
        0xC8,   0xBE,   0xBD,   0xBC,   0xC6,   0xC7,   0xCC,   0xB5,   0xB6,   0xB9,   0xD1,   0xD2,   0xCB,   0xCF,   0xD0,   0xCA,
        0xD8,   0xD7,   0xCE,   0xDF,   0xDC,   0xDB,   0xDD,   0xDE,   0xB0,   0xB1,   0xB2,   0xFE,   0x16,   0x1E,   0x10,   0x1F,
        0x11,   0x09,   0x08,   0x0A,   0x01,   0x02,   0x0F,   0x0C,   0x0B,   0x06,   0x05,   0x03,   0x04,   0x0D,   0x0E
};
#endif
