#ifndef BRCHRSTR_H
#define BRCHRSTR_H
//========================================================================================
//
//     File:		BRChrStr.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	4/2/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCHARAC_H
#include "BRCharac.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

#ifndef BRCHARIT_H
#include "BRCharIt.h"
#endif

//========================================================================================
//	CLASS BR_CCharString255
//========================================================================================

class BR_CCharString255 : public BR_TBoundedString<BR_Char, (unsigned short)255>
{
	friend class BR_TStringWriter<BR_Char, BR_CCharString255>;
	
public:

	~BR_CCharString255();
	BR_CCharString255();
	BR_CCharString255(const BR_TString<BR_Char> &string);
	BR_CCharString255(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CCharString255(const BR_Char *items);

	BR_TString<BR_Char>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_Char>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CCharString255::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& BR_CCharString255::operator=(const BR_TString< BR_Char>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CCharString255::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& BR_CCharString255::operator=(const BR_Char* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CCharString255Writer
//========================================================================================

class BR_CCharString255Writer : public BR_TStringWriter<BR_Char, BR_CCharString255>
{
public:
	BR_CCharString255Writer(BR_CCharString255 &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_Char, BR_CCharString255>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CCharString32
//========================================================================================

class BR_CCharString32 : public BR_TBoundedString<BR_Char, (unsigned short)32>
{
	friend class BR_TStringWriter<BR_Char, BR_CCharString32>;
	
public:

	~BR_CCharString32();
	BR_CCharString32();
	BR_CCharString32(const BR_TString<BR_Char> &string);
	BR_CCharString32(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CCharString32(const BR_Char *items);

	BR_TString<BR_Char>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_Char>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CCharString32::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& BR_CCharString32::operator=(const BR_TString< BR_Char>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CCharString32::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& BR_CCharString32::operator=(const BR_Char* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CCharString32Writer
//========================================================================================

class BR_CCharString32Writer : public BR_TStringWriter<BR_Char, BR_CCharString32>
{
public:
	BR_CCharString32Writer(BR_CCharString32 &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_Char, BR_CCharString32>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CDynamicCharString
//========================================================================================

class BR_CDynamicCharString : public BR_TDynamicString<BR_Char>
{
	friend class BR_TStringWriter<BR_Char, BR_CDynamicCharString>;
	
public:

	~BR_CDynamicCharString();
	BR_CDynamicCharString();
	BR_CDynamicCharString(const BR_TString<BR_Char> &string);
	BR_CDynamicCharString(const BR_Char *items, BR_CharacterCount numberItems);
	BR_CDynamicCharString(const BR_Char *items);

	BR_TString<BR_Char>& operator=(const BR_TString<BR_Char>& string);
	BR_TString<BR_Char>& operator=(const BR_Char* string);
};

//----------------------------------------------------------------------------------------
//	BR_CDynamicCharString::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& 
BR_CDynamicCharString::operator=(const BR_TString<BR_Char>& string)
{
	if (&string != this)
		ReplaceAll(string);
	return *this;
}

//----------------------------------------------------------------------------------------
//	BR_CDynamicCharString::operator=
//----------------------------------------------------------------------------------------

inline BR_TString<BR_Char>& 
BR_CDynamicCharString::operator=(const BR_Char* string)
{
	ReplaceAll(string, BR_StringLength(string));
	return *this;
}

//========================================================================================
//	CLASS BR_CDynamicCharStringWriter
//========================================================================================

class BR_CDynamicCharStringWriter : public BR_TStringWriter<BR_Char, BR_CDynamicCharString>
{
public:
	BR_CDynamicCharStringWriter(BR_CDynamicCharString &string, BR_TextWriterMode mode=BR_kTextAppend) :  
		BR_TStringWriter<BR_Char, BR_CDynamicCharString>(string, mode) {}
};

//========================================================================================
//	CLASS BR_CUniversalCharStringReader
//========================================================================================

class BR_CUniversalCharStringReader : public BR_TUniversalStringReader<BR_Char>
{
public:
	BR_CUniversalCharStringReader(const BR_TString<BR_Char> &string) :  
		BR_TUniversalStringReader<BR_Char>(string) {}
};

#endif
