//========================================================================================
//
//      File:		BRWriSys.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================*/

#ifndef	BRWRISYS_H
#define	BRWRISYS_H
#endif


#ifndef		BRATTRIB_H
#include	"BRATTRIB.H"
#endif

#ifndef		BRFORMAT_H
#include	"BRFORMAT.H"
#endif

#ifndef		BRITERAT_H
#include	"BRITERAT.H"
#endif

#ifndef		BRKEYBRD_H
#include	"BRKEYBRD.H"
#endif

#ifndef		BRLITCNS_H
#include	"BRLITCNS.H"
#endif

#ifndef		BRLOCALE_H
#include	"BRLOCALE.H"
#endif

#ifndef		BRSCRIPT_H
#include	"BRSCRIPT.H"
#endif

#ifndef		BRSORT_H
#include	"BRSORT.H"
#endif

#ifndef		BRTABLES_H
#include	"BRTABLES.H"
#endif

#ifndef		BRWRISYS_H
#include	"BRWRISYS.H"
#endif


//---------------------------------------------------------------------------------------
//	Forward class declarations
//---------------------------------------------------------------------------------------

class BR_CLocale;
class BR_CScriptProperties;
class	 BR_CFormat;
class BR_CCharacterAttributes;


//========================================================================================
//	CLASS BR_CWritingSytem
//========================================================================================

//========================================================================================

//										BR_CWritingSytem	Design Objectives

//	Responsibilities	:
		//	A writing system encompasses all a process needs to edit, display, store and retrieve text.
		//	It also affects the type of character instantiated from the character template, thus affecting
		//	string manipulation.

		//	A writing system is a huge collection of data, informing Bedrock about all details 
		//	required to process human language text. Thus it is desireable to have the ability to pull  
		//	a complete writing system out of a hat (WSDB) in time of need.

//	Tasks	It can conduct :
		//	A user should have the ability to obtain one of the 5 supplied writing systems from the WSDB,
		//	klone it, then change some of the elements making up the writing system to produce a new
		//	writing system. This new writing system can then be completely constructed, used,
		//	then saved to the WSDB (Writing system database).

//	Collaborators			:
		//	The locale class pointed to by the fLocale field is the decisive factor in 
		//	the characteristics of the writing system created.
		//	
		//	This class also has a knowledge of all the various formats needed for this writing system
		//	

//	Where Constructed	:
		//	At system Initialization time, should be the responsibility of the the application object.

//	Data Members		:
		//	BR_CLocale					*fLocale
		//	BR_CScriptProperties		*fScriptProperties[1]	// We should actually use a collection of arbitrary size
		//	BR_CCharacterAttributes		*fCharacterAttributes

		//	BR_CFormat					*fCurrencyFormat
		//	BR_CFormat					*fDateTimeNames
		//	BR_CFormat					*fFileSystemTimeFormat
		//	BR_CFormat					*fFloatNumberFormat
		//	BR_CFormat					*fHour12TimeFormat
		//	BR_CFormat					*fHour24TimeFormat
		//	BR_CFormat					*fIntegerNumberFormat
		//	BR_CFormat					*fLongDateFormat
		//	BR_CFormat					*fShortDateFormat

//========================================================================================

class BR_CWritingSytem
{

public:
	BR_CWritingSytem();
	BR_CWritingSytem(BR_LocaleID aLocaleID = 1);
	BR_CWritingSytem(BR_CLocale* aLocale);

	~BR_CWritingSytem();

	//	the following will be used to access the main locale(s)
	//	of a Bedrock writing system

	BR_CLocale* GetCurrentLocale();
	BR_Boolean SetCurrentLocale(BR_CLocale* localePtr);

	BR_CLocale* GetDefaultLocale();
	BR_Boolean SetDefaultLocale(BR_CLocale* localePtr);

	//	following accessors are the only publicly accessible way available 
	//	to instantiate objects of the component classes of a writing system

	BR_CLocale* GetWritingSystemLocale();

	BR_CScriptProperties* GetScriptProperties();
	BR_CScriptProperties* GetScriptProperties(BR_LocaleID = UNICODE);
	BR_CScriptProperties* GetScriptProperties(const BR_CLocale* someLocale);

	BR_CCharacterAttributes* GetCharacterAttributes();
	BR_CCharacterAttributes* GetCharacterAttributes(BR_LocaleID = UNICODE);
	BR_CCharacterAttributes* GetCharacterAttributes(const BR_CLocale* someLocale);

	BR_CFloatNumberFormat* GetFloatNumberFormat();
	BR_CFloatNumberFormat* GetFloatNumberFormat(BR_LocaleID = UNICODE);
	BR_CFloatNumberFormat* GetFloatNumberFormat(const BR_CLocale* someLocale);

	BR_CIntegerNumberFormat* GetIntegerNumberFormat();
	BR_CIntegerNumberFormat* GetIntegerNumberFormat(BR_LocaleID = UNICODE);
	BR_CIntegerNumberFormat* GetIntegerNumberFormat(const BR_CLocale* someLocale);

	BR_CFileNameFormat* GetFileNameFormat();
	BR_CFileNameFormat* GetFileNameFormat(BR_LocaleID = UNICODE);
	BR_CFileNameFormat* GetFileNameFormat(const BR_CLocale* someLocale);

	BR_CCurrencyFormat* GetCurrencyFormat();
	BR_CCurrencyFormat* GetCurrencyFormat(BR_LocaleID = UNICODE);
	BR_CCurrencyFormat* GetCurrencyFormat(const BR_CLocale* someLocale);

	BR_CDateTimeNames* GetDateTimeNames();
	BR_CDateTimeNames* GetDateTimeNames(BR_LocaleID = UNICODE);
	BR_CDateTimeNames* GetDateTimeNames(const BR_CLocale* someLocale);

	BR_CFileSystemTimeFormat* GetFileSystemTimeFormat();
	BR_CFileSystemTimeFormat* GetFileSystemTimeFormat(BR_LocaleID = UNICODE);
	BR_CFileSystemTimeFormat* GetFileSystemTimeFormat(const BR_CLocale* someLocale);

	BR_CHour12TimeFormat* GetHour12TimeFormat();
	BR_CHour12TimeFormat* GetHour12TimeFormat(BR_LocaleID = UNICODE);
	BR_CHour12TimeFormat* GetHour12TimeFormat(const BR_CLocale* someLocale);

	BR_CHour24TimeFormat* GetHour24TimeFormat();
	BR_CHour24TimeFormat* GetHour24TimeFormat(BR_LocaleID = UNICODE);
	BR_CHour24TimeFormat* GetHour24TimeFormat(const BR_CLocale* someLocale);

	BR_CLongDateFormat* GetLongDateFormat();
	BR_CLongDateFormat* GetLongDateFormat(BR_LocaleID = UNICODE);
	BR_CLongDateFormat* GetLongDateFormat(const BR_CLocale* someLocale);

	BR_CShortDateFormat* GetShortDateFormat();
	BR_CShortDateFormat* GetShortDateFormat(BR_LocaleID = UNICODE);
	BR_CShortDateFormat* GetShortDateFormat(const BR_CLocale* someLocale);



protected:

private:
	BR_CLocale* fLocale;
	BR_CScriptProperties* fScriptProperties[1];
	// We'll actually use a collection of arbitrary size

	BR_CCharacterAttributes* fCharacterAttributes;

	BR_CFormat* fFormats[ kFormatCount ];

};







//	feel free to add LOCALEID's to this list, 
//	just make sure they fit in the proper location within the scheme.
//	this list is intentionaly left incomplete

typedef enum BR_LocaleID
{
	Unicode	 				= 0 ,		//	Supplied With Bedrock, 
								//	And Is Equivalent To International English In Bedrock 1.0
	
	Usa	 					= 1 ,		// Supplied With Bedrock
	Latin					= 2 ,		// Supplied With Bedrock		
	LatinExtended			= 3 ,

	Japan					= 100 ,		// Supplied With Bedrock
	ChinaTraditional		= 101 ,
	ChinaSimplified		= 102 ,
	Korea					= 103 , 

	Arabic					= 200 ,		// Supplied With Bedrock
	ArabicNorthAfrican	= 201 ,
	ArabicExtended			= 202 ,
	Hebrew					= 250 ,

	Cyrrilic				= 300 ,		// Supplied With Bedrock

	IndicDevanagari		= 400 ,
	IndicBengali			= 401 ,
	IndicGurmkhi			= 402 ,
	IndicGujarati			= 403 ,
	IndicOriya				= 404 ,
	IndicTamil				= 405 ,
	IndicTelugu			= 406 ,
	IndicKannada			= 407 ,
	IndicMalayalam			= 408 ,
	IndicThai				= 450 ,
	IndicLao				= 460 ,


};

//	BR_CFloatNumberFormat		*fFloatNumberFormat;
//	BR_CIntegerNumberFormat		*fIntegerNumberFormat;
//	BR_CFileNameFormat			*fFileNameFormat;
//
//	BR_CCurrencyFormat			*fCurrencyFormat;
//
//	BR_CDateTimeNames			*fDateTimeNames;
//	BR_CFileSystemTimeFormat	*fFileSystemTimeFormat;
//	BR_CHour12TimeFormat		*fHour12TimeFormat;
//	BR_CHour24TimeFormat		*fHour24TimeFormat;
//	BR_CLongDateFormat			*fLongDateFormat;
//	BR_CShortDateFormat			*fShortDateFormat;



