//========================================================================================
//
//      File:		BRSort.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================

#ifndef	BRSORT_H
#define	BRSORT_H
#endif


#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif


//---------------------------------------------------------------------------------------
//	Forward class declarations
//---------------------------------------------------------------------------------------

class	BR_CLocale;
class	BR_CScriptProperties;
class	BR_CFormat;
class	BR_CCharacterAttributes;

//========================================================================================
//	CLASS BR_CLocaleSortTable	
//========================================================================================

class BR_CLocaleSortTable : BR_CTable
{
public:
	BR_CLocaleSort();
	~BR_CLocaleSort();
	BR_Boolean& operator==(BR_CUnicode firstChar,
						   BR_CUnicode secondChar) const;
	BR_Boolean& operator==(BR_CUnicode* firstString,
						   BR_CUnicode* secondString) const;

protected:
	short GetAlphabeticWeightTable() const;
	short GetAlphabeticWeightTable(BR_LocaleID = UNICODE) const;
	short GetAlphabeticWeightTable(const BR_CLocale* someLocale = gCurrentLocale) const;

	short GetCaseWeightTable() const;
	short GetCaseWeightTable(BR_LocaleID = UNICODE) const;
	short GetCaseWeightTable(const BR_CLocale* someLocale = gCurrentLocale) const;

	short GetDiacriticWeightTable() const;
	short GetDiacriticWeightTable(BR_LocaleID = UNICODE) const;
	short GetDiacriticWeightTable(const BR_CLocale* someLocale = gCurrentLocale) const;

	short GetPrecomposedWeightTable() const;
	short GetPrecomposedWeightTable(BR_LocaleID = UNICODE) const;
	short GetPrecomposedWeightTable(const BR_CLocale* someLocale = gCurrentLocale) const;

	short GetSpecialWeightTable() const;
	short GetSpecialWeightTable(BR_LocaleID = UNICODE) const;
	short GetSpecialWeightTable(const BR_CLocale* someLocale = gCurrentLocale) const;

	BR_Boolean Compare2Characters(BR_CUnicode firstChar,
								  BR_CUnicode secondChar) const;
	BR_Boolean Compare2Strings(BR_CUnicode* firstString,
							   BR_CUnicode* secondString) const;


private:
	BR_CLocale* fLocale;
	short fAlphabeticWeightTable[256];
	short fCaseWeightTable[256];
	short fDiacriticWeightTable[256];
	short fPrecomposedWeightTable[256];
	short fSpecialWeightTable[256];

};




//========================================================================================
//	CLASS BR_CMultiLocaleSort	
//========================================================================================

class BR_CMultiLocaleSort : public BR_CLocaleSortTable
{
	//	this class will not be implemented for Bedrock 1.0
public:

protected:

private:
	BR_CLocale* flocaleList[9];
};


