//========================================================================================
//
//      File:		BRLitCns.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================
#ifndef	BRLITCNS_H
#define	BRLITCNS_H
#endif

#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif


//========================================================================================
//	CLASS BR_CLiteralConstants
//========================================================================================

class BR_CLiteralConstants
{
public:
	BR_CLiteralConstants();
	~BR_CLiteralConstants();

	BR_Character GetExclamationMark() const;
	BR_Character GetQuotationMark() const;
	BR_Character GetNumberSign() const;
	BR_Character GetDollarSign() const;
	BR_Character GetPercent() const;
	BR_Character GetAmpersand() const;
	BR_Character GetCommercialAt() const;
	BR_Character GetApostrophe() const;
	BR_Character GetLeftParenthesis() const;
	BR_Character GetRightParenthesis() const;
	BR_Character GetAsterisk() const;
	BR_Character GetPlusSign() const;
	BR_Character GetMinusSign() const;
	BR_Character GetComma() const;
	BR_Character GetHypen() const;
	BR_Character GetPeriod() const;
	BR_Character GetSlash() const;
	BR_Character GetColon() const;
	BR_Character GetSemicolon() const;
	BR_Character GetLessThan() const;
	BR_Character GetEqualsSign() const;
	BR_Character GetGreaterThan() const;
	BR_Character GetQuestionMark() const;
	BR_Character GetLeftBracket() const;
	BR_Character GetBackslash() const;
	BR_Character GetRightBracket() const;
	BR_Character GetCircumflex() const;
	BR_Character GetUnderscore() const;
	BR_Character GetGraveAccent() const;
	BR_Character GetLeftBrace() const;
	BR_Character GetVerticalLine() const;
	BR_Character GetRightBrace() const;
	BR_Character GetTilde() const;

	BR_Boolean SetExclamationMark();
	BR_Boolean SetQuotationMark();
	BR_Boolean SetNumberSign();
	BR_Boolean SetDollarSign();
	BR_Boolean SetPercent();
	BR_Boolean SetAmpersand();
	BR_Boolean SetCommercialAt();
	BR_Boolean SetApostrophe();
	BR_Boolean SetLeftParenthesis();
	BR_Boolean SetRightParenthesis();
	BR_Boolean SetAsterisk();
	BR_Boolean SetPlusSign();
	BR_Boolean SetMinusSign();
	BR_Boolean SetComma();
	BR_Boolean SetHypen();
	BR_Boolean SetPeriod();
	BR_Boolean SetSlash();
	BR_Boolean SetColon();
	BR_Boolean SetSemicolon();
	BR_Boolean SetLessThan();
	BR_Boolean SetEqualsSign();
	BR_Boolean SetGreaterThan();
	BR_Boolean SetQuestionMark();
	BR_Boolean SetLeftBracket();
	BR_Boolean SetBackslash();
	BR_Boolean SetRightBracket();
	BR_Boolean SetCircumflex();
	BR_Boolean SetUnderscore();
	BR_Boolean SetGraveAccent();
	BR_Boolean SetLeftBrace();
	BR_Boolean SetVerticalLine();
	BR_Boolean SetRightBrace();
	BR_Boolean SetTilde();
protected:

private:
	BR_CLocale* fLocale;

	BR_Character fExclamationMark;
	BR_Character fQuotationMark;
	BR_Character fNumberSign;
	BR_Character fDollarSign;
	BR_Character fPercent;
	BR_Character fAmpersand;
	BR_Character fCommercialAt;
	BR_Character fApostrophe;
	BR_Character fLefTParenthesis;
	BR_Character fRightParenthesis;
	BR_Character fAsterisk;
	BR_Character fPlusSign;
	BR_Character fMinusSign;
	BR_Character fComma;
	BR_Character fHypen;
	BR_Character fPeriod;
	BR_Character fSlash;
	BR_Character fColon;
	BR_Character fSemicolon;
	BR_Character fLessThan;
	BR_Character fEqualsSign;
	BR_Character fGreaterThan;
	BR_Character fQuestionMark;
	BR_Character fLefttBracket;
	BR_Character fBackslash;
	BR_Character fRightBracket;
	BR_Character fCircumflex;
	BR_Character fUnderscore;
	BR_Character fGraveAccent;
	BR_Character fLeftBrace;
	BR_Character fVerticalLine;
	BR_Character fRightBrace;
	BR_Character fTilde;
};




//----------------------------------------------------------------------------------------
//
//	INLINE METHOD IMPLEMENTATIONS
//
//----------------------------------------------------------------------------------------


//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetExclamationMark
//
//----------------------------------------------------------------------------------------

inline BR_Character GetExclamationMark()
{
	return (fExclamationMark);
}




//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetQuotationMark
//
//----------------------------------------------------------------------------------------

inline BR_Character GetQuotationMark()
{
	return (fQuotationMark);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetNumberSign
//
//----------------------------------------------------------------------------------------

inline BR_Character GetNumberSign()
{
	return (fNumberSign);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetDollarSign
//
//----------------------------------------------------------------------------------------

inline BR_Character GetDollarSign()
{
	return (fDollarSign);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetPercent
//
//----------------------------------------------------------------------------------------

inline BR_Character GetPercent()
{
	return (fPercent);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetAmpersand
//
//----------------------------------------------------------------------------------------

inline BR_Character GetAmpersand()
{
	return (fAmpersand);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetCommercialAt
//
//----------------------------------------------------------------------------------------

inline BR_Character GetCommercialAt()
{
	return (fCommercialAt);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetApostrophe
//
//----------------------------------------------------------------------------------------

inline BR_Character GetApostrophe()
{
	return (fApostrophe);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetLeftParenthesis
//
//----------------------------------------------------------------------------------------

inline BR_Character GetLeftParenthesis()
{
	return (fLefTParenthesis);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetRightParenthesis
//
//----------------------------------------------------------------------------------------

inline BR_Character GetRightParenthesis()
{
	return (fRightParenthesis);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetAsterisk
//
//----------------------------------------------------------------------------------------

inline BR_Character GetAsterisk()
{
	return (fAsterisk);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetPlusSign
//
//----------------------------------------------------------------------------------------

inline BR_Character GetPlusSign()
{
	return (fPlusSign);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetMinusSign
//
//----------------------------------------------------------------------------------------

inline BR_Character GetMinusSign()
{
	return (fMinusSign);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetComma
//
//----------------------------------------------------------------------------------------

inline BR_Character GetComma()
{
	return (fComma);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetHypen
//
//----------------------------------------------------------------------------------------

inline BR_Character GetHypen()
{
	return (fHypen);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetPeriod
//
//----------------------------------------------------------------------------------------

inline BR_Character GetPeriod()
{
	return (fPeriod);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetSlash
//
//----------------------------------------------------------------------------------------

inline BR_Character GetSlash()
{
	return (fSlash);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetColon
//
//----------------------------------------------------------------------------------------

inline BR_Character GetColon()
{
	return (fColon);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetSemicolon
//
//----------------------------------------------------------------------------------------

inline BR_Character GetSemicolon()
{
	return (fSemicolon);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetLessThan
//
//----------------------------------------------------------------------------------------

inline BR_Character GetLessThan()
{
	return (fLessThan);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetEqualsSign
//
//----------------------------------------------------------------------------------------

inline BR_Character GetEqualsSign()
{
	return (fEqualsSign);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetGreaterThan
//
//----------------------------------------------------------------------------------------

inline BR_Character GetGreaterThan()
{
	return (fGreaterThan);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetQuestionMark
//
//----------------------------------------------------------------------------------------

inline BR_Character GetQuestionMark()
{
	return (fQuestionMark);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetLeftBracket
//
//----------------------------------------------------------------------------------------

inline BR_Character GetLeftBracket()
{
	return (fleftbracket);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetBackslash
//
//----------------------------------------------------------------------------------------

inline BR_Character GetBackslash()
{
	return (fBackslash);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetRightBracket
//
//----------------------------------------------------------------------------------------

inline BR_Character GetRightBracket()
{
	return (fRightBracket);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetCircumflex
//
//----------------------------------------------------------------------------------------

inline BR_Character GetCircumflex()
{
	return (fCircumflex);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetUnderscore
//
//----------------------------------------------------------------------------------------

inline BR_Character GetUnderscore()
{
	return (fUnderscore);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetGraveAccent
//
//----------------------------------------------------------------------------------------

inline BR_Character GetGraveAccent()
{
	return (fGraveAccent);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetLeftBrace
//
//----------------------------------------------------------------------------------------

inline BR_Character GetLeftBrace()
{
	return (fLeftBrace);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetVerticalLine
//
//----------------------------------------------------------------------------------------

inline BR_Character GetVerticalLine()
{
	return (fVerticalLine);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetRightBrace
//
//----------------------------------------------------------------------------------------

inline BR_Character GetRightBrace()
{
	return (fRightBrace);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLiteralConstants::GetTilde
//
//----------------------------------------------------------------------------------------

inline BR_Character GetTilde()
{
	return (fTilde);
}


