//========================================================================================
//
//      File:		BRFormat.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================

#ifndef	BRFORMAT_H
#define	BRFORMAT_H
#endif

#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif



//========================================================================================
//	CLASS BR_CFormat
//========================================================================================
class BR_CFormat
{
public:
	BR_CFormat();
	~BR_CFormat();
	BR_Format GetFormat() const;
	BR_Boolean SetFormat(BR_Format);
	virtual BR_Boolean IsValidFormat(BR_CFormat* someFormat) = 0;

protected:
	virtual ValidateString(BR_CString aString,
						   BR_CFormat) = 0;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetPattern() const;
	BR_CString GetNegativePattern() const;

	BR_Boolean SetFieldWidthFiller(BR_CString pattern);
	BR_Boolean SetPattern(BR_CString pattern);
	BR_Boolean SetNegativePattern(BR_CString pattern);

private:
	BR_Locale* fLocale;
	BR_CString fFieldWidthFiller;
	BR_CString fPattern;						/*%%F%%#*/
	BR_CString fNegativePattern;				/*%%F-%%#*/


};





//========================================================================================
//	CLASS BR_CCurrencyFormat
//========================================================================================
class BR_CCurrencyFormat : public BR_CNumberFormat
{
public:
	BR_CCurrencyFormat();
	~BR_CCurrencyFormat();

	BR_CString GetCurrencySymbol() const;
	BR_CString GetDecimalSeparator() const;
	BR_CString GetThousandsSeparator() const;
	short GetThousandsSeparatorPosition() const;
	short GetMinimumDecimalDigits() const;
	short GetMaximumDecimalDigits() const;
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetAccountingZeroString() const;
	BR_CString GetPositivePatternWithCurrencySymbol() const;
	BR_CString GetNegativePatternWithCurrencySymbol() const;
	BR_CString GetPositivePatternNoCurrencySymbol() const;
	BR_CString GetNegativePatternNoCurrencySymbol() const;
	BR_CurrencyFormatOptions GetOptions() const;

	BR_Boolean SetCurrencySymbol();
	BR_Boolean SetDecimalSeparator();
	BR_Boolean SetThousandsSeparator();
	BR_Boolean SetThousandsSeparatorPosition();
	BR_Boolean SetMinimumDecimalDigits();
	BR_Boolean SetMaximumDecimalDigits();
	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetAccountingZeroString();
	BR_Boolean SetPositivePatternWithCurrencySymbol();
	BR_Boolean SetNegativePatternWithCurrencySymbol();
	BR_Boolean SetPositivePatternNoCurrencySymbol();
	BR_Boolean SetNegativePatternNoCurrencySymbol();
	BR_Boolean SetOptions();

private:
	BR_CString fCurrencySymbol;					/*only here for reference*/
	BR_CString fDecimalSeparator;
	short fMinimumDecimalDigits;
	short fMaximumDecimalDigits;
	BR_CString fAccountingZeroString;			/* -0- */
	BR_CString fPositivePatternWithCurrencySymbol;/*$%%F%%#*/
	BR_CString fNegativePatternWithCurrencySymbol;/*$%%F(%%#)*/
	//	BR_CString fPositivePatternNoCurrencySymbol;		/*%%F%%# dollars*/	// use inherited
	//	BR_CString fNegativePatternNoCurrencySymbol;			/*%%F-%%# dollars*/	// use inherited
};




//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetCurrencySymbol
//
//----------------------------------------------------------------------------------------

inline BR_CString GetCurrencySymbol()
{
	return (fCurrencySymbol);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetDecimalSeparator
//
//----------------------------------------------------------------------------------------

inline BR_CString GetDecimalSeparator()
{
	return (fDecimalSeparator);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetThousandsSeparator
//
//----------------------------------------------------------------------------------------

inline BR_CString GetThousandsSeparator()
{
	return (fThousandsSeparator);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetThousandsSeparatorPosition
//
//----------------------------------------------------------------------------------------

inline short GetThousandsSeparatorPosition()
{
	return (fThousandsSeparatorPosition);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetMinimumDecimalDigits
//
//----------------------------------------------------------------------------------------

inline short GetMinimumDecimalDigits()
{
	return (fMinimumDecimalDigits);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetMaximumDecimalDigits
//
//----------------------------------------------------------------------------------------

inline short GetMaximumDecimalDigits()
{
	return (fMaximumDecimalDigits);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetAccountingZeroString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetAccountingZeroString()
{
	return (fAccountingZeroString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetPositivePatternWithCurrencySymbol
//
//----------------------------------------------------------------------------------------

inline BR_CString GetPositivePatternWithCurrencySymbol()
{
	return (fPositivePatternWithCurrencySymbol);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetNegativePatternWithCurrencySymbol
//
//----------------------------------------------------------------------------------------

inline BR_CString GetNegativePatternWithCurrencySymbol()
{
	return (fNegativePatternWithCurrencySymbol);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetPositivePatternNoCurrencySymbol
//
//----------------------------------------------------------------------------------------

inline BR_CString GetPositivePatternNoCurrencySymbol()
{
	return (fPositivePatternNoCurrencySymbol);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetNegativePatternNoCurrencySymbol
//
//----------------------------------------------------------------------------------------

inline BR_CString GetNegativePatternNoCurrencySymbol()
{
	return (fNegativePatternNoCurrencySymbol);
}



//----------------------------------------------------------------------------------------
//
//	BR_CCurrencyFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_CurrencyFormatOptions GetOptions()
{
	return (fOptions);
}




//========================================================================================
//	CLASS BR_CNumberFormat
//========================================================================================
class BR_CNumberFormat : public BR_CFormat
{
public:
	BR_Boolean IsValidNumber(const BR_CString someNumber);

protected:
	BR_CString GetThousandsSeparator() const;
	short GetThousandsSeparatorPosition() const;
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetPositivePattern() const;
	BR_CString GetNegativePattern() const;
	BR_FloatFormatOptions GetOptions() const;

	BR_Boolean SetThousandsSeparator();
	BR_Boolean SetThousandsSeparatorPosition();
	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetPositivePattern();
	BR_Boolean SetNegativePattern();
	BR_Boolean SetOptions();

private:
	BR_CString fThousandsSeparator;
	short fThousandsSeparatorPosition;
	BR_CString fOverflowString;
	BR_CString fFieldWidthFiller;
	BR_CString fPositivePattern;				/*%%F%%#*/
	BR_CString fNegativePattern;				/*%%F-%%#*/
	BR_FormatOptions fOptions;

};




//========================================================================================
//	CLASS BR_CIntegerNumberFormat
//========================================================================================

class BR_CIntegerNumberFormat : public BR_CNumberFormat
{
public:
	short GetRadix() const;
	BR_CString GetThousandsSeparator() const;
	short GetThousandsSeparatorPosition() const;
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetPositivePattern() const;
	BR_CString GetNegativePattern() const;
	BR_IntegerFormatOptions GetOptions() const;

	BR_Boolean SetRadix();
	BR_Boolean SetThousandsSeparator();
	BR_Boolean SetThousandsSeparatorPosition();
	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetPositivePattern();
	BR_Boolean SetNegativePattern();
	BR_Boolean SetOptions();

private:
	short fRadix;
};





//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetRadix
//
//----------------------------------------------------------------------------------------

inline short GetRadix()
{
	return (fRadix);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetThousandsSeparator
//
//----------------------------------------------------------------------------------------

inline BR_CString GetThousandsSeparator()
{
	return (fThousandsSeparator);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetThousandsSeparatorPosition
//
//----------------------------------------------------------------------------------------

inline short GetThousandsSeparatorPosition()
{
	return (fThousandsSeparatorPosition);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetPositivePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetPositivePattern()
{
	return (fPositivePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetNegativePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetNegativePattern()
{
	return (fNegativePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_IntegerFormatOptions GetOptions()
{
	return (fOptions);
}



//========================================================================================
//	CLASS BR_CFloatNumberFormat
//========================================================================================
class BR_CFloatNumberFormat : public BR_CNumberFormat
{
public:
	BR_CString GetDecimalSeparator() const;
	BR_CString GetThousandsSeparator() const;
	short GetThousandsSeparatorPosition() const;
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetPositivePattern() const;
	BR_CString GetNegativePattern() const;
	BR_FloatFormatOptions GetOptions() const;

	BR_Boolean SetDecimalSeparator();
	BR_Boolean SetThousandsSeparator();
	BR_Boolean SetThousandsSeparatorPosition();
	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetPositivePattern();
	BR_Boolean SetNegativePattern();
	BR_Boolean SetOptions();

private:
	BR_CString fDecimalSeparator;
};



	

//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetDecimalSeparator
//
//----------------------------------------------------------------------------------------

inline BR_CString GetDecimalSeparator()
{
	return (fDecimalSeparator);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetThousandsSeparator
//
//----------------------------------------------------------------------------------------

inline BR_CString GetThousandsSeparator()
{
	return (fThousandsSeparator);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetThousandsSeparatorPosition
//
//----------------------------------------------------------------------------------------

inline short GetThousandsSeparatorPosition()
{
	return (fThousandsSeparatorPosition);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetPositivePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetPositivePattern()
{
	return (fPositivePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetNegativePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetNegativePattern()
{
	return (fNegativePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CNumberFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_FloatFormatOptions GetOptions()
{
	return (fOptions);
}


//========================================================================================
//	CLASS BR_CTimeFormat
//========================================================================================
class BR_CDateTimeFormat : public BR_CFormat
{
public:
	BR_Boolean IsValidTime(const BR_CString someTime);
	BR_Boolean IsValidDate(const BR_CString someDate);

protected:
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetPattern() const;
	BR_TimeFormatOptions GetOptions() const;

	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetPattern();
	BR_Boolean SetOptions();

private:
	BR_CString fOverflowString;
	BR_CString fFieldWidthFiller;
	BR_CString fPattern;						/*%%H:%%M:%%S.%%1 %%2*/
	BR_FormatOptions fOptions;

};




	
//========================================================================================
//	CLASS BR_CHour12TimeFormat
//========================================================================================
class BR_CHour12TimeFormat : public BR_CDateTimeFormat
{
public:

	BR_Boolean IsValidTime(const BR_CString someTime);
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetTimePattern() const;
	BR_TimeFormatOptions GetOptions() const;

	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetTimePattern();
	BR_Boolean SetOptions();

private:
	//	BR_CString 			fTimePattern;						/*%%H:%%M:%%S.%%1 %%2*/
};





//----------------------------------------------------------------------------------------
//
//	BR_CTimeFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CTimeFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CTimeFormat::GetTimePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetTimePattern()
{
	return (fTimePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CTimeFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_TimeFormatOptions GetOptions()
{
	return (fOptions);
}


	
//========================================================================================
//	CLASS BR_CHour24TimeFormat
//========================================================================================


class BR_CHour24TimeFormat : public BR_CDateTimeFormat
{
public:

	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetTimePattern() const;
	BR_TimeFormatOptions GetOptions() const;

	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetTimePattern() const;
	BR_TimeFormatOptions GetOptions() const;

private:
	//	BR_CString fTimePattern;						/*%%H:%%M:%%S.%%1 %%2*/
};





//----------------------------------------------------------------------------------------
//
//	BR_CHour24TimeFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CHour24TimeFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CHour24TimeFormat::GetTimePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetTimePattern()
{
	return (fTimePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CHour24TimeFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_TimeFormatOptions GetOptions()
{
	return (fOptions);
}


	
//========================================================================================
//	CLASS BR_CFileSystemTimeFormat
//========================================================================================

class BR_CFileSystemTimeFormat : public BR_CDateTimeFormat
{
public:
	BR_CFileSystemTimeFormat();
	~BR_CFileSystemTimeFormat();
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetTimePattern() const;
	BR_TimeFormatOptions GetOptions() const;

	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetTimePattern();
	BR_Boolean SetOptions();

private:
	//	BR_CString fTimePattern;						/*%%H:%%M:%%S.%%1 %%2*/
};



	

//----------------------------------------------------------------------------------------
//
//	BR_CFileSystemTimeFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CFileSystemTimeFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CFileSystemTimeFormat::GetTimePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetTimePattern()
{
	return (fTimePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CFileSystemTimeFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_TimeFormatOptions GetOptions()
{
	return (fOptions);
}




//========================================================================================
//	CLASS BR_CShortDateFormat
//========================================================================================

class BR_CShortDateFormat : public BR_CDateTimeFormat
{
public:
	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetDatePattern() const;
	BR_DateFormatOptions GetOptions() const;

	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetDatePattern();
	BR_Boolean SetOptions();
	BR_Boolean IsValidDate(const BR_CString someDate);

private:

	//	BR_CString fDatePattern;						/*%%D#/%%M#/%%Y# or %%DN %%MN %%D#%%th, %%Y#*/
};





//----------------------------------------------------------------------------------------
//
//	BR_CShortDateFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CShortDateFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CShortDateFormat::GetDatePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetDatePattern()
{
	return (fDatePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CShortDateFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_DateFormatOptions GetOptions()
{
	return (fOptions);
}



	
//========================================================================================
//	CLASS BR_CLongDateFormat
//========================================================================================

class BR_CLongDateFormat : public BR_CDateTimeFormat
{
public:

	BR_CString GetOverflowString() const;
	BR_CString GetFieldWidthFiller() const;
	BR_CString GetDatePattern() const;
	BR_DateFormatOptions GetOptions() const;

	BR_Boolean SetOverflowString();
	BR_Boolean SetFieldWidthFiller();
	BR_Boolean SetDatePattern();
	BR_Boolean SetOptions();
	BR_Boolean IsValidDate(const BR_CString someDate);

private:
	//	BR_CString fDatePattern;						/*%%D#/%%M#/%%Y# or %%DN %%MN %%D#%%th, %%Y#*/
};





//----------------------------------------------------------------------------------------
//
//	BR_CLongDateFormat::GetOverflowString
//
//----------------------------------------------------------------------------------------

inline BR_CString GetOverflowString()
{
	return (fOverflowString);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLongDateFormat::GetFieldWidthFiller
//
//----------------------------------------------------------------------------------------

inline BR_CString GetFieldWidthFiller()
{
	return (fFieldWidthFiller);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLongDateFormat::GetDatePattern
//
//----------------------------------------------------------------------------------------

inline BR_CString GetDatePattern()
{
	return (fDatePattern);
}



//----------------------------------------------------------------------------------------
//
//	BR_CLongDateFormat::GetOptions
//
//----------------------------------------------------------------------------------------

inline BR_DateFormatOptions GetOptions()
{
	return (fOptions);
}



//========================================================================================
//	CLASS BR_CDateTimeNames
//========================================================================================

class BR_CDateTimeNames : public BR_CDateTimeFormat
{
public:
	BR_CDateTimeNames();
	~BR_CDateTimeNames();

	BR_CString GetDaysOfWeek() const;
	BR_CString GetAbbrDaysOfWeek() const;
	BR_CString GetMonths() const;
	BR_CString GetAbbrMonths() const;
	BR_CString GetYears() const;
	BR_CString GetMorning() const;
	BR_CString GetEvening() const;
	BR_CString GetMilitary() const;

private:
	BR_CString fDaysOfWeek[BR_DATETIME_DAYSINWEEK];
	BR_CString fAbbrDaysOfWeek[BR_DATETIME_DAYSINWEEK];
	BR_CString fMonths[14];
	BR_CString fAbbrMonths[14];
	BR_CString fYears[12];
	BR_CString fMorning;
	BR_CString fEvening;
	BR_CString fMilitary;
};



	
//========================================================================================
//	CLASS BR_CFileNameFormat
//========================================================================================
class BR_CFileNameFormat : public BR_CFormat
{
public:
	BR_CFileNameFormat();
	~BR_CFileNameFormat();
	BR_Boolean IsValidFileName(const BR_CString fileName);
private:
	BR_CString fString;

	BR_CUnicode FileNameSeparator;
	BR_CUnicode pathNameSeparator;
	int maxNuberOfCharactersInFileName;
	int maxNuberOfCharactersInPathName;
	int maxNuberOfCharactersInDriveName;
	int maxNuberOfCharactersInZoneName;
	int maxNuberOfCharactersInExtension;
	BR_CTable* setOfAcceptableFileNameCharacters;
	BR_CTable* setOfAcceptablePathNameCharacters;
	BR_CString networkZoneIdentifyier;
	BR_CString NetworkServerIdentifyier;
	BR_Boolean hasExtension;


};



	
