//========================================================================================
//
//      File:		BRAttrib.h
//      Release Version:	1.0d1
// 
//      Creation Date:		March 1993
// 
//      COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//      RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//      PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
// 
//      THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//      CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//      EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
// 
//      RESTRICTED RIGHTS LEGEND
//      Use, duplication, or disclosure by the Government is subject to restrictions as Set
//      forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//      Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//      Cupertino, CA 95014.
// 
//=======================================================================================

#ifndef	BRATTRIB_H
#define	BRATTRIB_H
#endif

#ifndef	BRWRISYS_H
#include "BRWRISYS.H"
#endif


//========================================================================================
//	CLASS BR_CCharacterAttributes
//========================================================================================

class BR_CCharacterAttributes
{
public:
	BR_CCharacterAttributes();
	BR_CCharacterAttributes(BR_Locale);
	~BR_CCharacterAttributes();


	BR_CAttributesTable* GetLetterAttributesTable() const;
	BR_CAttributesTable* GetLetterAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetLetterAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetNumberAttributesTable() const;
	BR_CAttributesTable* GetNumberAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetNumberAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetBreakingAttributesTable() const;
	BR_CAttributesTable* GetBreakingAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetBreakingAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetDirectionalAttributesTable() const;
	BR_CAttributesTable* GetDirectionalAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetDirectionalAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetShapingAttributesTable() const;
	BR_CAttributesTable* GetShapingAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetShapingAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetTypeSettingAttributesTable() const;
	BR_CAttributesTable* GetTypeSettingAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetTypeSettingAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetMiscellaneousAttributesTable() const;
	BR_CAttributesTable* GetMiscellaneousAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetMiscellaneousAttributesTable(const BR_CLocale* someLocale) const;

	BR_CAttributesTable* GetScriptAttributesTable() const;
	BR_CAttributesTable* GetScriptAttributesTable(BR_LocaleID = UNICODE) const;
	BR_CAttributesTable* GetScriptAttributesTable(const BR_CLocale* someLocale) const;

private:
	//	every one of the foolowing fields is a 16 bit: bit vector.
	//	if bit 0 has the value 0 then the character in question is not of that category
	//	all together. 
	//	Else check the specific bit for the attribute you want.
	//	A field map explaining the bits can be found at the end of the class definition.

	BR_CAttributesTable* fLetterAttributesTable;
	BR_CAttributesTable* fNumberAttributesTable;
	BR_CAttributesTable* fBreakingAttributesTable;
	BR_CAttributesTable* fDirectionalAttributesTable;
	BR_CAttributesTable* fShapingAttributesTable;
	BR_CAttributesTable* fTypeSettingAttributesTable;
	BR_CAttributesTable* fMiscellaneousAttributesTable;
	BR_CAttributesTable* fScriptAttributesTable;// 32 bit, bit vector

	BR_Locale* fLocale;
};





//========================================================================================
//	CLASS BR_CAttributesTable	
//========================================================================================

class BR_CAttributesTable : public BR_CTable
{
public:
	Boolean DoesCharacterPossessAttribute(Character c,
										  int attribute) const;

protected:
	long GetBitsForCharacter(Character c) = 0;
	Boolean IsBitSet(long,
					 int attribute);
	long fdata[kMaximumWeirdCharactersInAScript];

private:
	BR_CLocale* fLocale;
};


//----------------------------------------------------------------------------------------
//
//	BR_CAttributesTable::DoesCharacterPossessAttribute
//
//----------------------------------------------------------------------------------------

inline	Boolean DoesCharacterPossessAttribute(Character c, int attribute)
{
	return IsBitSet(GetBitsForCharacter(c), attribute);
}

//========================================================================================
//	CLASS BR_CLettersAttributes
//========================================================================================

class  BR_CLettersAttributes : public BR_CAttributesTable
{
public:
	enum	
	{
		kAlphabetic		=	0,
		kDipthong			=	1,	
		kDigraph			=	2,	
		kLigature			=	3,	
		kUpperCase		=	4,	
		kLowerCase		=	5,	
		kCaseIrrelevant	=	6,	
		kIsBase			=	7,	
		kPunctuation		=	8,	
		kSpacing			=	9,	
		kWhiteSpace		=	10,	
		kBreakingSpace	=	11,
		kReserved12				=	12,
		kReserved13				=	13,
		kReserved14				=	14,
		kReserved15				=	15
	};

	BR_CLettersAttributes();
	~BR_CLettersAttributes();
	BR_Boolean	IsAlphabetic(BR_UnicodeCharacter c) // just an example for the mechanism
	{
		return ( DoesCharacterPossessAttribute( c, kAlphabetic)) ; 
	}
	BR_Boolean	SetAlphabetic(BR_Boolean alpha) { alpha ? 1 : 0; }
	
	long 		GetBitsForCharacter(Character c);

protected :
private:
	long	fBits;

};

//========================================================================================
//	CLASS BR_CBreakingAttributes
//========================================================================================
class BR_CBreakingAttributes : public BR_CAttributesTable
{
public:
	enum						
	{						
		kBreaking						=	0,	
		kBreakWordBeforeOk			=	1,	
		kBreakWordAfterOk			=	2,	
		kBreakWordIrrelevant			=	3,	
		kBreakLineBeforeOk			=	4,	
		kBreakLineAfterOk			=	5,	
		kBreakLineIrrelevant			=	6,	
		kHyphenCandidate				=	7,	
		kReserved8							=	8,	
		kReserved9							=	9,	
		kReserved10							=	10,	
		kReserved11							=	11,	
		kReserved12							=	12,	
		kReserved13							=	13,	
		kReserved14							=	14,	
		kReserved15							=	15,	
	};						

	BR_CBreakingAttributes();
	~BR_CBreakingAttributes();
	
private:

};



//========================================================================================
//	CLASS BR_CNumbersAttributes
//========================================================================================
class  BR_CNumbersAttributes : public BR_CAttributesTable
{
public:	
	enum						
	{						
		kNumeric						=	0,		
		kNumericMissellaneous 		=	1,	
		kLatinNumeral					=	2,	
		kArabicNumeral				=	3,	
		kRomanNumeral					=	4,		
		kIndicNumeral					=	5,		
		kLatinNumeralSparator		=	6,			
		kArabicNumeralSparator		=	7,	
		kRomanNumeralSparator		=	8,		
		kIndicNumeralSparator		=	9,	
		kLatinNumeralTerminator		=	10,		
		kArabicNumeralTerminator		=	11,			
		kRomanNumeralTerminator		=	12,
		kIndicNumeralTerminator		=	13,
		kCurrency						=	14,	
		kReserved15							=	15,	
	};
	
	BR_CNumbersAttributes();
	~BR_CNumbersAttributes();
private:
};

//========================================================================================
//	CLASS BR_CDirectionalAttributes
//========================================================================================

class BR_CDirectionalAttributes : public BR_CAttributesTable
{
public:
	enum						
	{
		kDirectional			=	0,	
		kRTL					=	1,	
		kLTR					=	2,	
		kNeutralDirection		=	3,	
		kLinear				=	4,	
		kReserved5				=	5,	
		kReserved6				=	6,	
		kReserved7				=	7,	
		kReserved8				=	8,	
		kReserved9				=	9,	
		kReserved10				=	10,	
		kReserved11				=	11,	
		kReserved12				=	12,	
		kReserved13				=	13,	
		kReserved14				=	14,	
		kReserved15				=	15,	
	};						
	
	BR_CDirectionalAttributes();
	~BR_CDirectionalAttributes();

private:

};

//========================================================================================
//	CLASS BR_CShapingAttributes
//========================================================================================

class BR_CShapingAttributes: public BR_CAttributesTable
{
public:
	enum						
	{						
		kShaping					=	0,	
		kStandAlone				=	1,	
		kInitial					=	2,	
		kMedial					=	3,	
		kEnding					=	4,	
		kForceLigatureBefore		=	5,	
		kForceLigatureAfter		=	6,	
		kForceStandAlone			=	7,	
		kFullWidth				=	8,	
		kHalfWidth				=	9,	
		kGlyphBound				=	10,	
		kPrecomposed				=	11,	
		kInvisible					=	12,	
		kReserved13						=	13,	
		kReserved14						=	14,	
		kReserved15						=	15,	
	};						

	BR_CShapingAttributes();
	~BR_CShapingAttributes();
	
private:

};

//========================================================================================
//	CLASS BR_CType_SettingAttributes
//========================================================================================
class BR_CType_SettingAttributes : public BR_CAttributesTable
{
public:
	enum						
	{						
		kTypeSetting			=	0,	
		kCanSwash				=	1,	
		kCanSerif				=	2,	
		kHumanlyRenderable	=	3,	
		kReserved4					=	4,	
		kReserved5					=	5,	
		kReserved6					=	6,	
		kReserved7					=	7,	
		kReserved8					=	8,	
		kReserved9					=	9,	
		kReserved10					=	10,	
		kReserved11					=	11,	
		kReserved12					=	12,	
		kReserved13					=	13,	
		kReserved14					=	14,	
		kReserved15					=	15,	
	};						

	BR_CType_SettingAttributes();
	~BR_CType_SettingAttributes();

private:

};

//========================================================================================
//	CLASS BR_CMiscellaneousAttributes
//========================================================================================

class BR_CMiscellaneousAttributes : public BR_CAttributesTable
{
public:
	enum						
	{						
		kMiscellaneous			=	0,	
		kControl			=	1,	
		kMapsTo437			=	2,	
		kUnicodeSpecial			=	3,	
		kHasMultipleSemantics			=	4,	
		kReserved5				=	5,	
		kReserved6				=	6,	
		kReserved7				=	7,	
		kReserved8				=	8,	
		kReserved9				=	9,	
		kReserved10				=	10,	
		kReserved11				=	11,	
		kReserved12				=	12,	
		kReserved13				=	13,	
		kReserved14				=	14,	
		kReserved15				=	15,	
	};						
	
	BR_CMiscellaneousAttributes();
	~BR_CMiscellaneousAttributes();

private:

};

//========================================================================================
//	CLASS BR_CScriptsAttributes
//========================================================================================

class  BR_CScriptsAttributes : public BR_CAttributesTable
{
public:
			
	enum 
	{						
		kLatin				=	0,	
		kHan				=	1,	
		kArabic				=	2,	
		kSlavic				=	3,	
		kGreeck				=	4,	
		kHebrew				=	5,	
		kThai				=	6,	
		kMongolian			=	7,	
		kEtheiopic			=	8,	
		kHeiroglyphic		=	9,	
		kMultilingual		=	10,	
		kMultiScript		=	11,	
		kDeadScript		=	12,	
		kAffectsReading	=	13,	
		kIPA				=	14,	
		kCantillationMark	=	15,	
		kKoranicStopMark	=	16,	
	 	Diacrictic			=	17,	
		kPunctuation		=	18,	
		kPhoneticHan		=	19,	
		kPhoneticKana		=	20,	
		kHiragana			=	21,	
		kKatakana			=	22,	
		kRuby				=	23,	
		kBopomofo			=	24,	
		kHangulElement		=	25,	
		kIdeographic		=	26,	
		kPictographic		=	27,	
		kPhonetic			=	28,	
		kReserved29				=	29,	
		kReserved30				=	30,	
		kReserved31				=	31
	};
	
	BR_CScriptsAttributes();
	~BR_CScriptsAttributes();

private:

};