//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCSearcV.h
//
//  This file contains the declaration of the vector searching tools.

#ifndef BCSEARCV_H
#define BCSEARCV_H 1

#include "BCType.h"

// Vector searching abstract base class

template<class Item, class Sequence>
class BC_TSearch {
public:

  BC_TSearch();
  BC_TSearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual ~BC_TSearch();
  
  virtual void
    SetIsEqualFunction(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual BC_Extended_Index Location(const Sequence& target, const Item& key) = 0;

protected:

  BC_Boolean (*fRepIsEqual)(const Item& x, const Item& y);
  
};

// Sequential searching class
  
template<class Item, class Sequence>
class BC_TSequentialSearch : public BC_TSearch<Item, Sequence> {
public:

  BC_TSequentialSearch();
  BC_TSequentialSearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y));
  virtual ~BC_TSequentialSearch();
  
  virtual BC_Extended_Index Location(const Sequence& target, const Item& key);

};

// Ordered searching class
  
template<class Item, class Sequence>
class BC_TOrderedSearch : public BC_TSearch<Item, Sequence> {
public:

  BC_TOrderedSearch();
  BC_TOrderedSearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y),
                    BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual ~BC_TOrderedSearch();
  
  virtual void
    SetIsLessThanFunction(BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual BC_Extended_Index Location(const Sequence& target, const Item& key);

protected:

  BC_Boolean (*fRepIsLessThan)(const Item& x, const Item& y);
  
};

// Binary searching class

template<class Item, class Sequence>
class BC_TBinarySearch : public BC_TSearch<Item, Sequence> {
public:

  BC_TBinarySearch();
  BC_TBinarySearch(BC_Boolean (*BC_IsEqual)(const Item& x, const Item& y),
                   BC_Boolean(*BC_IsLessThan)(const Item& x, const Item& y));
  virtual ~BC_TBinarySearch();
  
  virtual void
    SetIsLessThanFunction(BC_Boolean (*BC_IsLessThan)(const Item& x, const Item& y));
  virtual BC_Extended_Index Location(const Sequence& target, const Item& key);

protected:

  BC_Boolean (*fRepIsLessThan)(const Item& x, const Item& y);
  
};

#endif
