//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCPool.h
//
//  This file contains the declaration of the heap storage management class.

#ifndef BCPOOL_H
#define BCPOOL_H 1

#include <stddef.h>
#include "BCType.h"

// Class denoting a fPool of memory stored on the heap

class BC_CPool {
public:

  BC_CPool(size_t chunkSize);
  ~BC_CPool();
  
  void* Allocate(size_t);
  void Deallocate(void*, size_t);
  
  void Preallocate(BC_Index number_of_chunks);
  void ReclaimUnusedChunks();
  void PurgeUnusedChunks();
  
  size_t ChunkSize() const 
    {return fRepChunkSize;}
  BC_Index TotalChunks() const
    {return (NumberOfDirtyChunks() + NumberOfUnusedChunks());}
  BC_Index NumberOfDirtyChunks() const;
  BC_Index NumberOfUnusedChunks() const;
  
protected:

  struct BC_TElement {
    BC_TElement* fRepNextElement;
    BC_TElement() : fRepNextElement(0) {}
  };
    
  struct BC_SChunk {
    BC_SChunk* fRepPreviousSizedChunk;
    BC_SChunk* fRepNextSizedChunk;
    BC_SChunk* fRepNextChunk;
    BC_Index fRepElementSize;
    BC_Index fRepNumberOfElements;
    BC_TElement* fRepNextElement;
    BC_SChunk() : fRepPreviousSizedChunk(0),
                 fRepNextSizedChunk(0),
                 fRepNextChunk(0),
                 fRepElementSize(0),
                 fRepNumberOfElements(0),
                 fRepNextElement(0) {}
  };

  BC_SChunk* fRepHead;
  BC_SChunk* fRepUnusedChunks;
  size_t fRepChunkSize;
  size_t fRepUsableChunkSize;

  BC_SChunk* GetChunk(size_t s);
  
private:

  BC_CPool(BC_CPool&) 
    {}
  void operator=(BC_CPool&) 
    {}
  void operator==(BC_CPool&) 
    {}
  void operator!=(BC_CPool&) 
    {}
  
};

#endif
