//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCTree.h
//
//  This file contains the declaration of the binary tree.

#ifndef BCTREE_H
#define BCTREE_H 1

#include "BCNodes.h"

enum BC_Child {BC_kLeft, BC_kRight};
  
// Binary tree

template<class Item, class Storage_Manager>
class BC_BinaryTree {
public:

  BC_BinaryTree();
  BC_BinaryTree(const BC_BinaryTree<Item, Storage_Manager>&);
  ~BC_BinaryTree();

  BC_BinaryTree<Item, Storage_Manager>&
    operator=(const BC_BinaryTree<Item, Storage_Manager>&);
  BC_Boolean operator==(const BC_BinaryTree<Item, Storage_Manager>&) const;
  BC_Boolean operator!=(const BC_BinaryTree<Item, Storage_Manager>&) const;

  void Clear();
  void Insert(const Item&, BC_Child child);
  void Append(const Item&, BC_Child child, BC_Child after);
  void Remove(BC_Child child);
  void Share(BC_BinaryTree<Item, Storage_Manager>&, BC_Child child);
  void SwapChild(BC_BinaryTree<Item, Storage_Manager>&, BC_Child child);
  void Child(BC_Child child);
  void LeftChild();
  void RightChild();
  void Parent();
  void SetItem(const Item&);

  BC_Boolean HasChildren() const;
  BC_Boolean IsNull() const;
  BC_Boolean IsShared() const;
  BC_Boolean IsRoot() const;
  Item& Item() const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TBinaryNode<Item, Storage_Manager>* fRep;

  void Purge(BC_TBinaryNode<Item, Storage_Manager>*&);

};

#endif
