//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved..
//
//  BCStac.h
//
//  This file contains the declaration of the stack abstract base class
//  and its iterators.

#ifndef BCSTAC_H
#define BCSTAC_H 1

#include "BCType.h"

template<class Stack_Item>
class BC_StackActiveIterator;

template<class Stack_Item>
class BC_StackPassiveIterator;

// Stack abstact base class

template<class Stack_Item>
class BC_Stack {
public:

  BC_Stack();
  BC_Stack(const BC_Stack<Stack_Item>&);
  virtual ~BC_Stack();
  
  virtual BC_Stack<Stack_Item>& operator=(const BC_Stack<Stack_Item>&);
  virtual BC_Boolean operator==(const BC_Stack<Stack_Item>&) const;
  BC_Boolean operator!=(const BC_Stack<Stack_Item>&) const;

  virtual void Clear() = 0;
  virtual void Push(const Stack_Item&) = 0;
  virtual void Pop() = 0;
  
  virtual BC_Index Depth() const = 0;
  virtual BC_Boolean IsEmpty() const = 0;
  virtual const Stack_Item& Top() const = 0;
  
protected:

  virtual void Purge() = 0;
  virtual void Add(const Stack_Item&) = 0;
  virtual BC_Index Cardinality() const = 0;
  virtual const Stack_Item& Item(BC_Index) const = 0;
  
  virtual void Lock();
  virtual void Unlock();
  
private:

  friend class BC_StackActiveIterator<Stack_Item>;
  friend class BC_StackPassiveIterator<Stack_Item>;
  
};

// Stack iterators

template <class Stack_Item>
class BC_StackActiveIterator {
public:

  BC_StackActiveIterator(const BC_Stack<Stack_Item>&); 
  ~BC_StackActiveIterator();
  
  void Reset();
  BC_Boolean Next();

  BC_Boolean IsDone() const;
  const Stack_Item* Item() const;
  
protected:

  const BC_Stack<Stack_Item>& fRepStack;
  BC_Extended_Index fRepIndex;
  
};

template <class Stack_Item>
class BC_StackPassiveIterator {
public:

  BC_StackPassiveIterator(const BC_Stack<Stack_Item>&);
  ~BC_StackPassiveIterator();
  
  BC_Boolean Apply(BC_Boolean (*)(const Stack_Item&));
  
protected:

  const BC_Stack<Stack_Item>& fRepStack;

};

#endif
