//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCSetD.h
//
//  This file contains the declaration of the dynamic set.

#ifndef BCSETD_H
#define BCSETD_H 1

#include "BCNodes.h"
#include "BCDynami.h"
#include "BCHashTa.h"
#include "BCSet.h"

// Dynamic set

template<class Set_Item, BC_Index Buckets, class Storage_Manager>
class BC_TDynamicSet : public BC_TSet<Set_Item> {
public:

  BC_TDynamicSet();
  BC_TDynamicSet(BC_Index (*)(const Set_Item&));
  BC_TDynamicSet(BC_Index chunkSize);
  BC_TDynamicSet(const BC_TDynamicSet<Set_Item, Buckets, Storage_Manager>&);
  virtual ~BC_TDynamicSet();

  virtual BC_TSet<Set_Item>& operator=(const BC_TSet<Set_Item>&);
  virtual BC_TSet<Set_Item>& operator=(const BC_TDynamicSet<Set_Item, Buckets, Storage_Manager>&);
  virtual BC_Boolean operator==(const BC_TSet<Set_Item>&) const;
  virtual BC_Boolean
    operator==(const BC_TDynamicSet<Set_Item, Buckets, Storage_Manager>&) const;
  BC_Boolean operator!=(const BC_TDynamicSet<Set_Item, Buckets, Storage_Manager>&) const;

  virtual void SetHashFunction(BC_Index (*)(const Set_Item&));
  virtual void SetChunkSize(BC_Index chunkSize);
  virtual void Preallocate(BC_Index new_length);
  virtual void Clear();
  virtual BC_Boolean Add(const Set_Item&);
  virtual BC_Boolean Remove(const Set_Item& at);

  virtual BC_Index ChunkSize() const;
  virtual BC_Index Extent() const;
  virtual BC_Boolean IsEmpty() const;
  virtual BC_Boolean IsMember(const Set_Item&) const;
  
  static void* operator new(size_t);
  static void operator delete(void*, size_t);

protected:

  BC_TTable<Set_Item, BC_Boolean, Buckets,
           BC_TDynamic<BC_TPair<Set_Item, BC_Boolean>, Storage_Manager> > fRep;

  virtual void Purge();
  virtual BC_Boolean Attach(const Set_Item&);
  virtual BC_Boolean Detach(const Set_Item&);
  virtual BC_Index Cardinality() const;
  virtual BC_Index NumberOfBuckets() const;
  virtual BC_Index Length(BC_Index bucket) const;
  virtual BC_Boolean Exists(const Set_Item&) const;
  virtual const Set_Item& Item(BC_Index bucket, BC_Index index) const;
  
};

#endif
