//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCSetB.h
//
//  This file contains the declaration of the bounded set.

#ifndef BCSETB_H
#define BCSETB_H 1

#include "BCNodes.h"
#include "BCBound.h"
#include "BCHashTa.h"
#include "BCSet.h"

// Bounded set

template<class Set_Item, BC_Index Buckets, BC_Index Size>
class BC_TBoundedSet : public BC_TSet<Set_Item> {
public:

  BC_TBoundedSet();
  BC_TBoundedSet(BC_Index (*)(const Set_Item&));
  BC_TBoundedSet(const BC_TBoundedSet<Set_Item, Buckets, Size>&);
  virtual ~BC_TBoundedSet();

  virtual BC_TSet<Set_Item>& operator=(const BC_TSet<Set_Item>&);
  virtual BC_TSet<Set_Item>& operator=(const BC_TBoundedSet<Set_Item, Buckets, Size>&);
  virtual BC_Boolean operator==(const BC_TSet<Set_Item>&) const;
  virtual BC_Boolean operator==(const BC_TBoundedSet<Set_Item, Buckets, Size>&) const;
  BC_Boolean operator!=(const BC_TBoundedSet<Set_Item, Buckets, Size>&) const;

  virtual void SetHashFunction(BC_Index (*)(const Set_Item&));
  virtual void Clear();
  virtual BC_Boolean Add(const Set_Item&);
  virtual BC_Boolean Remove(const Set_Item& at);

  virtual BC_Index Available() const;
  virtual BC_Index Extent() const;
  virtual BC_Boolean IsEmpty() const;
  virtual BC_Boolean IsMember(const Set_Item&) const;
  
protected:

  BC_TTable<Set_Item, BC_Boolean, Buckets, BC_TBounded<BC_TPair<Set_Item, BC_Boolean>, Size> > fRep;

  virtual void Purge();
  virtual BC_Boolean Attach(const Set_Item&);
  virtual BC_Boolean Detach(const Set_Item&);
  virtual BC_Index Cardinality() const;
  virtual BC_Index NumberOfBuckets() const;
  virtual BC_Index Length(BC_Index Bucket) const;
  virtual BC_Boolean Exists(const Set_Item&) const;
  virtual const Set_Item& Item(BC_Index Bucket, BC_Index index) const;
  
  static void* operator new(size_t);
  static void operator delete(void*, size_t);

};

#endif
