//  The C++ Booch Components (Version 2.0)
//  (C) Copyright 1990-1993 Grady Booch. All Rights Reserved.
//
//  BCMapB.h
//
//  This file contains the declaration of the bounded map.

#ifndef BCMAPB_H
#define BCMAPB_H 1

#include "BCNodes.h"
#include "BCBound.h"
#include "BCHashTa.h"
#include "BCMap.h"

// Bounded map

template<class Map_Item, class Map_Value, BC_Index Buckets, BC_Index Size>
class BC_TBoundedMap : public BC_TMap<Map_Item, Map_Value> {
public:

  BC_TBoundedMap();
  BC_TBoundedMap(BC_Index (*)(const Map_Item&));
  BC_TBoundedMap(const BC_TBoundedMap<Map_Item, Map_Value, Buckets, Size>&);
  virtual ~BC_TBoundedMap();

  virtual BC_TMap<Map_Item, Map_Value>& operator=(const BC_TMap<Map_Item, Map_Value>&);
  virtual BC_TMap<Map_Item, Map_Value>& 
    operator=(const BC_TBoundedMap<Map_Item, Map_Value, Buckets, Size>&);
  virtual BC_Boolean operator==(const BC_TMap<Map_Item, Map_Value>&) const;
  virtual BC_Boolean 
    operator==(const BC_TBoundedMap<Map_Item, Map_Value, Buckets, Size>&) const;
  BC_Boolean operator!=(const BC_TBoundedMap<Map_Item, Map_Value, Buckets, Size>&) const;

  virtual void SetHashFunction(BC_Index (*)(const Map_Item&));
  virtual void Clear();
  virtual BC_Boolean Bind(const Map_Item&, const Map_Value&);
  virtual BC_Boolean Rebind(const Map_Item&, const Map_Value&);
  virtual BC_Boolean Unbind(const Map_Item&);

  virtual BC_Index Available() const;
  virtual BC_Index Extent() const;
  virtual BC_Boolean IsEmpty() const;
  virtual BC_Boolean IsBound(const Map_Item&) const;
  virtual const Map_Value* Value(const Map_Item&) const;

protected:

  BC_TTable<Map_Item, Map_Value, Buckets, BC_TBounded<BC_TPair<Map_Item, Map_Value>, Size> > fRep;

  virtual void Purge();
  virtual BC_Boolean Attach(const Map_Item&, const Map_Value&);
  virtual BC_Index Cardinality() const;
  virtual BC_Index NumberOfBuckets() const;
  virtual BC_Index Length(BC_Index Bucket) const;
  virtual BC_Boolean Exists(const Map_Item&) const;
  virtual const Map_Item& Item(BC_Index bucket, BC_Index index) const;
  virtual const Map_Value& Value(BC_Index bucket, BC_Index index) const;

  static void* operator new(size_t);
  static void operator delete(void*, size_t);

};

#endif
