#ifndef BRTRYBLO_H
#define BRTRYBLO_H
//========================================================================================
//
//     File:			BRTryBlo.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	June 1, 1992
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#include <setjmp.h>

#ifndef   BRSDELST_H
#include "BRSDelSt.h"
#endif

#ifndef   BREXCTAS_H
#include "BRExcTas.h"
#endif

//========================================================================================
// CLASS _BR_CTryBlockContext
//========================================================================================

class _BR_CTryBlockContext
{
public:
	_BR_CTryBlockContext(jmp_buf buffer);
	~_BR_CTryBlockContext();

    static void 				SetCurrentContext(_BR_CTryBlockContext * BRTryBlo);
    static _BR_CTryBlockContext	*GetCurrentContext();
    static _BR_CTryBlockContext	*MakeCurrent(_BR_CTryBlockContext *BRTryBlo);

	class _BR_CTryBlockContext 	*fPriorContext;
	_BR_StackEntries 				fDeleteStackLevel;
	jmp_buf						*fJumpBuffer;
	short						fIsActive;

#ifdef BR_DEBUG
	short						fAutomaticsInMyScope;
	unsigned short 				fTraceDepth;
	static short 				gContextDepth;
	void						CheckClassInvariants();
#endif
};

#ifdef BR_STATIC_TASK_GLOBALS
inline void _BR_CTryBlockContext::SetCurrentContext(_BR_CTryBlockContext* theCurrentContext)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
					gBedExceptionGlobals.gCurrentContext = theCurrentContext;
}

inline _BR_CTryBlockContext* _BR_CTryBlockContext::GetCurrentContext()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.
					gBedExceptionGlobals.gCurrentContext;
}
#endif

#ifndef BR_STATIC_TASK_GLOBALS
inline void _BR_CTryBlockContext::SetCurrentContext(_BR_CTryBlockContext* theCurrentContext)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionGlobals.gCurrentContext = theCurrentContext;
}

inline _BR_CTryBlockContext* _BR_CTryBlockContext::GetCurrentContext()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionGlobals.gCurrentContext;
}
#endif

#endif
