#if !defined(BRSEXCEP_H)
#define BRSEXCEP_H
//========================================================================================
//
//     File:			BRSExcep.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/11/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#include <stddef.h>

//========================================================================================
//	Forward Declarations
//========================================================================================

class _BR_CMetaClass;
class _BR_CException;
class _BR_CTryBlockContext;
class __BR_CBedNewHelper;
class __BR_CBedSubHelper;

typedef void (*PFV) ();

//========================================================================================
//	STRUCT BR_SBedExceptionGlobals
//
//		Globals for exception handling system.
//		Only one instance of this struct will be instantiated per task.
//
//========================================================================================

struct BR_SBedExceptionGlobals
{
	size_t					gExceptionBufferSize;
	void*					gExceptionBuffer;
	_BR_CException*			gCaughtException;
	_BR_CException*			gThrownException;
	_BR_CTryBlockContext*		gCurrentContext;
	short					gIsThrowing;
	PFV						gCurrentTerminate;
	PFV						gCurrentUnexpected;
	_BR_CMetaClass*			gBreakExceptionKind;
	__BR_CBedNewHelper**	gNewHelperStackBottom;
	__BR_CBedNewHelper**	gNewHelperStackTop;
	__BR_CBedSubHelper*		gSubHelperStorageArray;
	__BR_CBedSubHelper*		gSubHelperFreeListHead;
};

#endif
