#ifndef CLASS_H
#define CLASS_H
//========================================================================================
//
//	This source file is a component of the Bedrock Class Library
//
//	File:				Class.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		June 1, 1992
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#include <stddef.h>

//========================================================================================
// CLASS _BR_CMetaClass
//========================================================================================

class _BR_CMetaClass
{
public:
#ifdef BR_DEBUG
	_BR_CMetaClass(_BR_CMetaClass *ancestor, size_t instanceSize, char *className);
	char *const GetClassName() const;
#else
	_BR_CMetaClass(_BR_CMetaClass *ancestor, size_t instanceSize);
#endif
	int InheritsFrom(_BR_CMetaClass *aClass) const;

	_BR_CMetaClass *fAncestor;
	size_t fInstanceSize;
private:
#ifdef BR_DEBUG
	char *fClassName;
#endif
};

//========================================================================================
// Useful Macros for class meta information (Mac versions)
//========================================================================================

#ifdef BR_BUILD_MAC
    #define _BR_CLASS_DEFINE(name) \
    	static class _BR_CMetaClass __Class

    #define _BR_CLASS_REFERENCE(name) \
        &name::__Class

    #define _BR_CLASS(name) \
        name::__Class

#ifdef BR_DEBUG
    #define _BR_CLASS_IMPLEMENT(name, ancestor) \
        _BR_CMetaClass name::__Class(&ancestor::__Class, sizeof(name), #name);

    #define _BR_CLASS_IMPLEMENT_ROOT(name) \
    _BR_CMetaClass name::__Class(NULL, sizeof(name), #name);
#else
    #define _BR_CLASS_IMPLEMENT(name, ancestor) \
        _BR_CMetaClass name::__Class(&ancestor::__Class, sizeof(name));

    #define _BR_CLASS_IMPLEMENT_ROOT(name) \
    _BR_CMetaClass name::__Class(NULL, sizeof(name));
#endif

#endif

//========================================================================================
// Useful Macros for class meta information (Windows versions)
//========================================================================================

#ifdef BR_BUILD_WIN

//***KV: In Windows, __CLASS_XXX depend on __EXCEPTION_DEFINE_MYCLASS,
//  etc., to be used (we're using MyClass() because (?) we can't export data)

	#define _BR_CLASS_DEFINE(name) \
		static class _BR_CMetaClass __Class

#ifdef BR_DEBUG
	#define _BR_CLASS_IMPLEMENT(name, ancestor) \
		_BR_CMetaClass name::__Class(ancestor::__StaticGetClass(), sizeof(name), #name);

	#define _BR_CLASS_IMPLEMENT_ROOT(name) \
	_BR_CMetaClass name::__Class((_BR_CMetaClass*) NULL, sizeof(name), #name);
#else
	#define _BR_CLASS_IMPLEMENT(name, ancestor) \
		_BR_CMetaClass name::__Class(ancestor::__StaticGetClass(), sizeof(name));

	#define _BR_CLASS_IMPLEMENT_ROOT(name) \
	_BR_CMetaClass name::__Class((_BR_CMetaClass*) NULL, sizeof(name));
#endif

	#define _BR_CLASS_REFERENCE(name) \
		(name::__StaticGetClass())

	#define _BR_CLASS(name) \
		(*(name::__StaticGetClass()))
#endif

#endif

