#ifndef BREXCTAS_H
#define BREXCTAS_H
//========================================================================================
//
//	This source file is a component of the Bedrock Class Library
//
//	File:				BRExcTas.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/11/92
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRTRACET_H
#include "BRTraceT.h"
#endif

#ifndef   BRSDELST_H
#include "BRSDelSt.h"
#endif

#ifndef   BRSEXCEP_H
#include "BRSExcep.h"
#endif

#ifndef   BRSPOSTE_H
#include "BRSPostE.h"
#endif

#ifndef   BRSEXCLO_H
#include "BRSExcLo.h"
#endif

//========================================================================================
// CLASS BR_CExceptionTaskGlobals
//
//	This class lays out globals that Bedrock DLLs "share".  Assume that Bedrock is
//	partitioned into the three traditional DLLs (BCLUTIL, BCL, BCLADV), and that we
//  add a fourth DLL by removing BEL from BCLUTIL.  Furthermore, we'd like BEL to be
//	usable by applications that may not be built upon the other DLLs.  BEL needs to have
//  task specific globals, without making assumptions about the DLLs and applications that
//	use it.  We achieve this by requiring the following:
//
//		1) We can "reserve" a space in the application's data segment just above the
//		header and below the static data area (alternatively, we can say that we are
//		reserving the first portion of the static data area).
//		2) Within this space, we can reserve space for components like BEL.
//
//	The layout of the data members below must conform to the reserved layout.
//
//	NOTE: Only one instance of a BR_CBedTaskGlobals object should be created, and only
//	by code residing in an .EXE (application).  This class, BR_CExceptionTaskGlobals, is
//	only meaningful in relation to DLLs, and is therefore defined as an abstract class
//	using a protected constructor.  Application code should define a subclass with a 
//	public constructor, and arrange to create one such instance (See AppTaskG & StatInit).
//========================================================================================

class BR_CExceptionTaskGlobals : public BR_CTraceTaskGlobals
{
public:

	static BR_CExceptionTaskGlobals*	GetTaskGlobals();

#ifdef BR_STATIC_TASK_GLOBALS
	static BR_CExceptionTaskGlobals&	gExceptionTaskGlobals;
#endif

	// The order of the data members is signficant.  See above.
	
	BR_SBedDeleteStack			gBedDeleteStack;

	BR_SBedExceptionGlobals	gBedExceptionGlobals;

#ifdef BR_DEBUG
	BR_SBedExceptionLog		gBedExceptionLog;
#endif
	
	BR_SBedPostedExceptionGlobals	gBedPostedExceptionGlobals;

	~BR_CExceptionTaskGlobals();

protected:

	BR_CExceptionTaskGlobals();
	
};

//----------------------------------------------------------------------------------------
//	GetTaskGlobals
//----------------------------------------------------------------------------------------

inline BR_CExceptionTaskGlobals* BR_CExceptionTaskGlobals::GetTaskGlobals()
{
	return (BR_CExceptionTaskGlobals*) BR_CBedTaskGlobals::GetTaskGlobals();
}

#endif
