#if !defined(BREXCLOG_H) && defined(BR_DEBUG)
#define BREXCLOG_H
// This entire file is for debugging only
//========================================================================================
//
//	This source file is a component of the Bedrock Class Library
//
//	File:				BRExcLog.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		12/10/92
//
//	Derived from Runtime.h:
//		Creation Date:		June 1, 1992
//
//	COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//	RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//	PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//	THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//	CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//	EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//	RESTRICTED RIGHTS LEGEND
//	Use, duplication, or disclosure by the Government is subject to restrictions as Set
//	forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//	Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//	Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRMETACL_H
#include "BRMetaCl.h"
#endif

#ifndef   BREXCEPT_H
#include "BRExcept.h"
#endif

#ifndef   BREXCTAS_H
#include "BRExcTas.h"
#endif

//========================================================================================
// CLASS _BR_CExceptionLog
//========================================================================================

class _BR_CExceptionLog
{

public:

	static void Initialize();
		// Sets log in valid, non-logging state.
		// Should only be called once at startup.

	static void StartLog();
		// Starts (resumes) logging.  Resets trigger count to zero.
		// We increment the logging counter each time StartLog is called.
		// Logging is only enabled when the counter is above 0.
		// Logging requires tracing, so StartLog calls StartTrace.
	
	static unsigned long StopLog();
		// Suspends logging, and calls StopTrace, which may stop tracing.
		// Returns final trigger counter (number of possible exception points).

	static unsigned short GetLogEnableCount();
	static void SetLogEnableCount(unsigned short nLogEnabled);

	static _BR_CMetaClass* GetTriggerExceptionClass();
	static void SetTriggerExceptionClass(_BR_CMetaClass* exceptionClass);

	static unsigned long GetTriggerCounter();
	static void SetTriggerCounter(unsigned long);

	static unsigned long GetTriggerPoint();
	static void SetTriggerPoint(unsigned long);
	
	static void CauseException(unsigned long triggerPoint);
	static void CauseException(_BR_CMetaClass *exceptionClass);
 
	static void LogException(_BR_CMetaClass* exceptionClass);
	static void TriggerException(_BR_CMetaClass* exceptionClass, 
								 const _BR_CException &theException);
};

//========================================================================================
// _BR_CExceptionLog inline functions (Static Task Globals Versions)
//========================================================================================

#ifdef BR_STATIC_TASK_GLOBALS

inline unsigned short _BR_CExceptionLog::GetLogEnableCount()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gLogEnabled;
}

inline void _BR_CExceptionLog::SetLogEnableCount(unsigned short logEnabled)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gLogEnabled = logEnabled;
}

inline _BR_CMetaClass* _BR_CExceptionLog::GetTriggerExceptionClass()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerClass;
}

inline void _BR_CExceptionLog::SetTriggerExceptionClass(_BR_CMetaClass* exceptionClass)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerClass = exceptionClass;
}

inline unsigned long _BR_CExceptionLog::GetTriggerPoint()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerPoint;
}

inline void _BR_CExceptionLog::SetTriggerPoint(unsigned long nTriggerPoint)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerPoint = nTriggerPoint;
}

inline unsigned long _BR_CExceptionLog::GetTriggerCounter()
{
	return BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerCounter;
}

inline void _BR_CExceptionLog::SetTriggerCounter(unsigned long nTriggerCounter)
{
	BR_CExceptionTaskGlobals::gExceptionTaskGlobals.gBedExceptionLog.gTriggerCounter = nTriggerCounter;
}

#endif

//========================================================================================
// _BR_CExceptionLog inline functions (Dynamic Task Globals versions)
//========================================================================================

#ifndef BR_STATIC_TASK_GLOBALS

inline unsigned short _BR_CExceptionLog::GetLogEnableCount()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedExceptionLog.gLogEnabled;
}

inline void _BR_CExceptionLog::SetLogEnableCount(unsigned short logEnabled)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
						gBedExceptionLog.gLogEnabled = logEnabled;
}

inline _BR_CMetaClass* _BR_CExceptionLog::GetTriggerExceptionClass()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerClass;
}

inline void _BR_CExceptionLog::SetTriggerExceptionClass(_BR_CMetaClass *exceptionClass)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerClass = exceptionClass;
}

inline unsigned long _BR_CExceptionLog::GetTriggerPoint()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerPoint;
}

inline void _BR_CExceptionLog::SetTriggerPoint(unsigned long nTriggerPoint)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerPoint = nTriggerPoint;
}

inline unsigned long _BR_CExceptionLog::GetTriggerCounter()
{
	return BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerCounter;
}

inline void _BR_CExceptionLog::SetTriggerCounter(unsigned long nTriggerCounter)
{
	BR_CExceptionTaskGlobals::GetTaskGlobals()->
					gBedExceptionLog.gTriggerCounter = nTriggerCounter;
}

#endif

#endif
