#ifndef BRAUTODE_H
#define BRAUTODE_H
//========================================================================================
//
//	This source file is a component of the Bedrock Class Library
//
//	File:				BRAutoDe.h
//	Release Version:	$ 1.0d1 $
//
//	Creation Date:		Jan 7, 1993
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#include <stddef.h>

//========================================================================================
//	Forward Declarations
//========================================================================================

#ifdef BR_USE_NEW_HELPER	
class __BR_CBedNewHelper;
#endif

//========================================================================================
// CLASS _BR_CAutoDestructObject
//
//	Every stack based object that must be destructed when the stack is unwound must have
//	a virtual destructor as the first item in its vtbl.  This root class ensures that 
//	is the case.
//========================================================================================

class _BR_CAutoDestructObject
{

public:

	virtual ~_BR_CAutoDestructObject();
		// Virtual destructor.  Does nothing other than reserve vtbl slot.

#ifdef BR_USE_NEW_HELPER	
	void* operator new(size_t size, const __BR_CBedNewHelper &helper);
#else
	void* operator new(size_t size);
#endif

	void operator delete(void *object);

public: // Internal Method

	void __Delete();
		// Calls virtual destructor.  To be used only by BEL.

private:
#ifdef BR_USE_NEW_HELPER	
	void* operator new(size_t size);
#endif
};


//========================================================================================
// CLASS _BR_CAutoDestructObject inline functions
//========================================================================================

inline void _BR_CAutoDestructObject::__Delete()
{
#ifdef _MPWCFRONT
	// CFront is bizarre.  It won't allow the unscoped destructor name, but the scoped 
	// name is dispatched virtually, even though ARM says scoped names are never virtual.
	this->_BR_CAutoDestructObject::~_BR_CAutoDestructObject();
#else
	this->~_BR_CAutoDestructObject();	// Virtual dispatch to object's destructor
#endif
}

#endif
