#if !defined(BRVIEW_H) && !defined(__BEDRC__)
#define BRVIEW_H
//========================================================================================
//
//     File:			BRView.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/27/93
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif

#ifndef BCOCOLU_H
#include "BCOColU.h"
#endif

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif

#ifndef BRVIEW_K
#include "BRView.k"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BRRESOUR_H
#include "BRResour.h"
#endif

#ifndef BRHELP_H
#include "BRHelp.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRDRAGDR_H
#include "BRDragDr.h"
#endif

#ifndef BRADORN1_H
#include "BRAdorn1.h"
#endif

#ifndef BRHVIEW_H
#include "BRHView.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__QUICKDRAW__)
#include <Quickdraw.h>
#endif

#if defined(BR_BUILD_MAC) && !defined(__EVENTS__)
#include <Events.h>
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================

class BR_CModule;
class BR_CAppDesktop;
class BR_CCanvas;
class BR_CWindow;
class BR_CColor;
class BR_CView;
class BR_CScrollEvent;
struct BR_SBedCanvasResolutions;

#ifdef BR_BUILD_MAC
struct GrafPort;
class BR_CDynamicCharString;
#endif

//========================================================================================
//	Constants
//========================================================================================

// These specify, for their own modes, the number of logical units that
// will map onto each device pixel.  I.e.:
//   LogicalSize = UNITSize/FontSize
// Where LogicalSize specifies the number of pixels that map onto each
// device pixel.  For example, for a font of height 8 and the mapping mode
// set to kFontUnits, the number of logical units that maps onto each
// device pixel would be:
//    512/8 = 64

const unsigned short kFontUnitsHeight        = 512;
const unsigned short kFontUnitsWidth         = 256;

const unsigned short kDialogUnitsHeight      = 8;
const unsigned short kDialogUnitsWidth       = 4;

// Constants for DoClick fFlags

const unsigned short kControlModifier = MK_CONTROL;	// Left mouse button
const unsigned short kLeftButtonModifier = MK_LBUTTON;	// Left mouse button
const unsigned short kMiddleButtonModifier = MK_MBUTTON;	// Middle mouse button
const unsigned short kRightButtonModifier = MK_RBUTTON;	// Right mouse button
const unsigned short kShiftModifier   = MK_SHIFT;		// Shift fKey
const unsigned short kLeftModifier    = 0x1000;		// A flag that specifies the fLeft
                                                    // mouse button
const unsigned short kMiddleModifier  = 0x2000;		// A flag that specifies the middle
                                                    // mouse button
const unsigned short kRightModifier   = 0x4000;		// A flag that specifies the fRight
                                                    // mouse button

const BR_Boolean BR_kRedraw = TRUE;
const BR_Boolean BR_kDontRedraw = FALSE;

//========================================================================================
//	Class BR_CView
//========================================================================================

class BR_CView : public BR_CBureaucrat
{
friend class BR_CDrawInitiator;

#ifdef BR_BUILD_MAC
	friend class BR_CMacWindowHelper;
#endif
#ifdef BR_BUILD_WIN
	friend class BR_CWinViewHelper;
#endif

public:
	typedef unsigned short int 	ViewId;
	typedef unsigned short int 	ViewUnits;
	typedef unsigned long int 	ViewStyle;
	typedef unsigned short int 	ViewSizing;
	
#ifdef BR_BUILD_WIN
	typedef WORD BedWinClassId;
#endif

	enum
	{
		kDefaultViewId = -1
	};
	
public:
	BR_CView(BR_CView* 		enclosure,
			BR_CBureaucrat* supervisor,
			ViewId			viewId,
			ViewUnits		viewUnits,
			BR_CHelp::HelpTopic	helpTopic,
			BR_Distance 	width,
			BR_Distance 	height,
			BR_Coordinate 	x,
			BR_Coordinate 	y,
			ViewSizing 		horizontalSizing,
			ViewSizing 		verticalSizing,
			const BR_CColor &backgroundColor);

	BR_CView(BR_CView* 			enclosure,
			BR_CBureaucrat* 	supervisor,
			const BR_CModule& 	module,
			BR_SResource& 		viewRes);
	
	virtual ~BR_CView();

	// ----- Frame
	virtual void 		SetFrame(const BR_CRectangle &aRect,
							 	 BR_Boolean redraw);
	virtual void 		GetFrame(BR_CRectangle &aRect) const;

	BR_Distance 		GetFrameWidth() const;
	BR_Distance 		GetFrameHeight() const;

	void 				Offset(BR_Distance hOffset,
								BR_Distance vOffset,
								BR_Boolean redraw);
	void 				Place(BR_Coordinate x,
					   			BR_Coordinate y,
					   			BR_Boolean redraw);
	void 				ChangeSize(const BR_CRectangle& delta,
									BR_Boolean redraw);
	
	// ----- Hit testing
	BR_Boolean 			Contains(const BR_CPoint& point) const;
	BR_Boolean			PtInFrame(const BR_CPoint& point) const;
	
	// ----- Border
	virtual void		GetBorderSize(BR_CRectangle& borderSize) const;

	// ----- Interior
	virtual void 		GetInterior(BR_CRectangle &aRect) const;
	virtual void 		SetInteriorSize(const BR_CPoint &newSize,
							 			BR_Boolean redraw = TRUE);
	void 				GetVisibleInterior(BR_CRectangle &visRect) const;

	// ----- Enclosure
	BR_CView			*GetEnclosure() const;
	virtual void 		SetEnclosure(BR_CView *enclosure, BR_CBureaucrat *supervisor = NULL);
	virtual void		BeInEnclosure(BR_CView *itsEnclosure);
	virtual void		BeInCanvas(BR_CCanvas *newCanvas);
	
	BR_Boolean 			IsEnclosing(const BR_CView &enclosedView) const;
	BR_Boolean 			IsEnclosedBy(const BR_CView &enclosingView) const;
	
	// ----- Supervisor
	virtual void		SetSupervisor(BR_CBureaucrat* itsSupervisor);

	// ----- Subviews management
	virtual void 		AddSubview(BR_CView *subview);
	virtual void 		RemoveSubview(BR_CView &subview);

	BC_Index		 	GetNumSubviews() const;
	
	BR_CView 			*GetSubview(BC_Index i) const;
	virtual BR_CView 	*GetSubviewId(ViewId viewId) const;

	virtual BR_CView 	*GetFirstSubview() const;
	virtual BR_CView 	*GetLastSubview() const;
	virtual BR_CView 	*GetNextSubview(const BR_CView &view,
									 BR_Boolean circle = TRUE) const;
	virtual BR_CView 	*GetPreviousSubview(const BR_CView &view,
										 BR_Boolean circle = TRUE) const;
	virtual BR_Boolean SetNextSubview(BR_Boolean &relinqushFocusFailed,
									  BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetFirstSubview(BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetPreviousSubview(BR_Boolean &relinqushFocusFailed,
										  BR_Boolean topLevel = FALSE);
	virtual BR_Boolean SetLastSubview(BR_Boolean topLevel = FALSE);
	
	virtual BR_CView 	*GetNextEnabledSubview(const BR_CView &view,
											BR_Boolean circle = TRUE);// ?INTERNAL?
	virtual BR_CView 	*GetPreviousEnabledSubview(const BR_CView &view,
												BR_Boolean circle = TRUE);// ?INTERNAL?
	
	// ----- ViewSizing
	void				GetViewSizing(BR_CPoint& viewSizing) const;
	virtual void		SetViewSizing(const BR_CPoint& viewSizing);
	virtual void		CalcMinSize(BR_CPoint &minSize);
	virtual void 		AdjustViewFrame(BR_Boolean redraw);
	virtual void		ComputeViewFrame(const BR_CRectangle &oldEnclosureInterior,
										const BR_CRectangle &newEnclosureInterior, 
										BR_CRectangle &newFrame);
	
	// ----- Origin/Scaling
	virtual void 		GetOrigin(BR_Coordinate &x,
						   			BR_Coordinate &y) const;
	virtual void		SetOrigin(BR_Coordinate X,
						 	  		BR_Coordinate Y);
	BR_CPoint 			GetOriginPoint() const;
	virtual void 		SetScaling(unsigned short numerator,
									unsigned short denominator);
	void 				GetScaling(unsigned short& numerator,
									unsigned short& denominator) const;

	// ----- View Identifier
	ViewId 				GetViewId() const;
	void 				SetViewId(ViewId viewId);
	
	// ----- Focus
	BR_Boolean 			IsFocus() const;
	virtual BR_Boolean SetFocus();
	static BR_CView 	*GetFocus();
	virtual void 		ReceiveFocus();
	virtual void 		LoseFocus(BR_CView *viewReceivingFocus);
	virtual BR_Boolean RelinquishFocus();		// ?INTERNAL?
	
	// ----- Enable
	virtual void		SetEnable(BR_Boolean state);

	// ----- Canvas
	BR_CCanvas* 		GetCanvas() const;
	
	// ----- Font
	virtual BR_CFont* 	SetViewFont(BR_CFont* newFont);
	BR_CFont* 			GetViewFont() const;
	BR_CFont* 			GetDialogBoxFont() const;

	// ----- Drawing
	virtual void		DoDraw(BR_CCanvas &canvas);
	virtual void		Draw(BR_CCanvas &canvas, const BR_CRectangle &area);
	
	// ----- Activate
	virtual void 		Activate();
	virtual void 		Deactivate();
	BR_CView 			*GetActiveSubview() const;
	void 				SetActiveSubview(BR_CView *view);
	virtual void 		SubviewActivate(BR_CView *subview);

	// ----- Hide/Show
	virtual void 		Show(BR_Boolean show = TRUE);
	virtual void 		Hide();
	virtual BR_Boolean	IsVisible() const;
	
	// ----- Close
	virtual BR_Boolean Close();

	// ----- Help
	virtual void 		AssignHelpChore(CommandId commandId);
	BR_Boolean 			BedSetHelpCursor();
	BR_Boolean 			HelpOnViewClick();

	// ----- Refresh
	virtual void 		Refresh();
	virtual void 		RefreshRect(const BR_CRectangle &aRect);
	virtual void 		UnRefreshRect(const BR_CRectangle &aRect);

	BR_Boolean 			RefreshAllWhenResized();
	void 				SetRefreshAllWhenResized(BR_Boolean state);

	virtual BR_Boolean	SetAutoRedraw(BR_Boolean autoRedraw);
	BR_Boolean			GetAutoRedraw() const;

	// ----- Adorners
	virtual void 		AddAdorner(BR_CAdorner *adorner,  BR_CAdorner::AdornPriority priority);
	virtual void		RemoveAdorner(BR_CAdorner &adorner);
	void				DeleteAdorners();
	unsigned long		GetNumAdorners() const;
	BR_CAdorner			*GetAdorner(BR_CAdorner::AdornerId adornerId) const;

	// ----- View validation
	virtual BR_Boolean		IsValidToChangeFocus();
	BR_CView				*DoViewValidation();
	virtual BR_Boolean		IsValidView();
	virtual void 			InvalidViewFeedback();

	// ----- View Title
	virtual void				SetText(const BR_TString<BR_Char>& title, BR_Boolean redraw = TRUE);
	virtual unsigned long 	GetText(BR_TString<BR_Char>& title) const;
	virtual unsigned long	GetTextLength() const;
	
	// ----- Units
	ViewUnits 				GetUnits() const;
	ViewUnits 				GetMapMode() const;	

	// ----- Cursor
	virtual BR_CCursor* 	GetCursor(const BR_CPoint& point) const;
	void 					SetCursor(BR_CCursor* cursor, BR_Boolean dynamicCursor);
	void 					SetCursor(BR_ResourceId systemCursorId);
	void 					GetCursorPos(BR_CPoint& pt) const;
										
	// ----- Defer Move
	virtual void 			BeginDeferMove();
	virtual void 			EndDeferMove();
						   
	// ----- Event Handling
	virtual BR_Boolean		DoCommand(CommandId commandId,
									  BR_CObject *notifier,
									  BR_Boolean callSupervisor = TRUE);
	virtual void 			DoClick(const BR_CPoint& aPoint,
									KeyModifiers keyFlags);
	virtual void			DoDoubleClick(const BR_CPoint& aPoint,
										  KeyModifiers keyFlags);
	virtual void			DoMouseUp(const BR_CPoint& aPoint,
									  KeyModifiers keyFlags);
	virtual void			MouseMove(const BR_CPoint& aPoint,
									  KeyModifiers keyFlags);
	virtual void			Update();
	virtual BR_Boolean		DoKeyDown(Key thekey,
									  unsigned short repeatCount,
									  BR_Boolean callSupervisor = TRUE);
	virtual BR_Boolean		DoScrollEvent(const BR_CScrollEvent& scrollEvent);
	
	// ----- Get 
	virtual BR_CAppDesktop 		*GetAppDesktop() const;
	virtual BR_CWindow				*GetWindow() const;
	
	// ----- Mouse Action
	BR_CMouseAction* 				GetMouseAction() const;

	// ----- Plaftorm Window
	virtual BR_PlatformWindow		GetPlatformWindow() const;
	virtual void					SetPlatformWindow(BR_PlatformWindow platformWindow);

	// ----- Coordinate Conversion
	void 				ViewToEnclosure(BR_CPoint &aPoint) const;
	void 				ViewToEnclosure(BR_CRectangle &aRect) const;
	void 				EnclosureToView(BR_CPoint &aPoint) const;
	void 				EnclosureToView(BR_CRectangle &aRect) const;

	void				ToEnclosingView(BR_CView *enclosingView, BR_CPoint &pt) const;
	void				ToEnclosingView(BR_CView *enclosingView, BR_CRectangle &r) const;
	void				FromEnclosingView(BR_CView *enclosingView, BR_CPoint &pt) const;
	void				FromEnclosingView(BR_CView *enclosingView, BR_CRectangle &r) const;
	
	void				ViewToScreen(BR_CPoint &pt) const;
	void				ViewToScreen(BR_CRectangle &r) const;
	void				ScreenToView(BR_CPoint &pt) const;
	void				ScreenToView(BR_CRectangle &r) const;

	// ----- Unit Conversion
	void 				ViewToEnclosureUnits(BR_CPoint &aPoint) const;
	void 				EnclosureToViewUnits(BR_CPoint &aPoint) const;

	void 				ScreenToEnclosureUnits(BR_CPoint &pt) const;
	void 				ScreenToEnclosureUnits(BR_CRectangle &r) const;

	void 				ScreenToViewUnits(BR_CPoint &pt) const;
	void 				ScreenToViewUnits(BR_CRectangle &r) const;
	void 				ViewToScreenUnits(BR_CPoint &pt) const;
	void 				ViewToScreenUnits(BR_CRectangle &r) const;
	
	void				ToEnclosingViewUnits(BR_CView *enclosingView, BR_CPoint &pt) const;
	void				FromEnclosingViewUnits(BR_CView *enclosingView, BR_CPoint &pt) const;

	void 				GetResolution(BR_CPoint& ptResolution) const;// log units/fInch
	short 				GetPixelWidth(short pixels) const;
	short 				GetPixelHeight(short pixels) const;
	void 				GetPixelDimensions(short& width,
											short& height) const;

	// ----- Background color
	virtual BR_CColor 	GetBackgroundColor() const;
	virtual void 		SetBackgroundColor(const BR_CColor& newColor);
	void 				SetShouldEraseBackground(BR_Boolean state);
	BR_Boolean 			ShouldEraseBackground();
	virtual void 		EraseBackground(const BR_CRectangle& rArea);

	// ----- Text Color
	virtual BR_CColor 		SetTextColor(const BR_CColor& newColor);
	virtual BR_CColor 		SetTextBackgroundColor(const BR_CColor& newColor);
	BR_CColor 				GetTextColor() const;
	BR_CColor 				GetTextBackgroundColor() const;

	// ----- Notification
	virtual void		EnclosureChangedFrame(const BR_CRectangle &oldFrame,
											  const BR_CRectangle &newFrame,
											  BR_Boolean redraw);
	virtual void 		SubviewHasBeenShown(BR_CView &subview,
									 		BR_Boolean newState);
	virtual void 		SubviewChangedFrame(BR_CView &subview,
									 		const BR_CRectangle &oldFrame,
									 		const BR_CRectangle &newFrame,
											BR_Boolean redraw);	
	
	// ----- Drag and Drop
	virtual BR_Boolean QueryDrop(BR_CPoint& ptOriginator,
								 	BR_CDragDrop& dragDrop);
	virtual void 		BeginQueryDrop(BR_CPoint& ptDrop,
										BR_CDragDrop& dragDrop);
	virtual void 		EndQueryDrop(BR_CPoint& ptDrop,
							  		BR_CDragDrop& dragDrop);
	virtual void 		Drop(BR_CPoint& ptDrop,
					  			BR_CDragDrop& dragDrop);

	// ----- Capture
	void				SetCapture();
	void				ReleaseCapture();
	
	// ----- View helper
	virtual BR_CViewHelper	*CreateViewHelper();

	//----------------------------------------------------------------------------
	// public Implementation
	//----------------------------------------------------------------------------

	// ----- PlatformBased view enclosing
	BR_CView				*BedGetEnclosingPlatformBasedView() const;
	BR_PlatformWindow		BedGetEnclosingPlatformWindow() const;

	// ----- Current drawing view
	BR_Boolean				BedIsDrawing() const;
	static void			BedSetDrawingView(BR_CView *view);
	static BR_CView 		*BedGetDrawingView();
	
	// ----- Color Translation
	void 					BedGetTrueViewColor(BR_CColor& color) const;

	// ----- Resolution
	virtual void 			BedGetResolutionFactors(ViewUnits inUnit,
										 		ViewUnits outUnit,
										 		unsigned short &xNum,
										 		unsigned short &xDen,
										 		unsigned short &yNum,
										 		unsigned short &yDen) const;
	void 					BedGetResolutions(BR_SBedCanvasResolutions& resolutions, const BR_CPoint &deviceRes) const;
	
	// ----- View Helper
	BR_CViewHelper			*BedGetViewHelper() const;
	void					BedSetViewHelper(BR_CViewHelper *viewHelper);

	// ----- Drawing preparation methods.  Don't call directly, but use BR_CDrawInitiator
	virtual void BeginDrawing(BR_CDrawStateData& drawStateData);
		// 	Start drawing on the current canvas.  DrawStateData is used to save any
	  	//	per-pane data (e.g. the old grafPort on the Mac).

	virtual void SuspendDrawing(BR_CDrawStateData& drawStateData);
		// 	Suspend drawing on the current canvas, saving current tools using
		// 	DrawStateData as the temporary storage.

	virtual void ResumeDrawing(const BR_CDrawStateData& drawStateData);
		// 	Resume drawing on the current canvas, restoring current tools from
		// 	DrawStateData.

	virtual void EndDrawing(const BR_CDrawStateData& drawStateData);
		// 	Finish drawing on the current canvas, using data saved by BeginDrawing in
		// 	DrawStateData.

	BR_CCanvas *BedGetCachedCanvas() const;
	void 		BedGetViewToCanvasOffset(BR_CPoint &viewToCanvasOffset) const;
	void 		BedGetCanvasOrigin(BR_CPoint &canvasOrigin) const;

protected:
	BR_CView();
	
	BR_Boolean InitView(BR_CView* 		enclosure,
						BR_CBureaucrat* supervisor,
						ViewId			viewId,
						ViewUnits		viewUnits,
						BR_CHelp::HelpTopic	helpTopic,
						BR_Distance 	width,
						BR_Distance 	height,
						BR_Coordinate 	x,
						BR_Coordinate 	y,
						ViewSizing 		horizontalSizing,
						ViewSizing 		verticalSizing,
						const BR_CColor &backgroundColor);

	BR_Boolean InitView(BR_CView* 			enclosure,
						BR_CBureaucrat* 	supervisor,
						const BR_CModule& 	module,
						BR_SResource& 		resource);

	void Initialize();
					
	// ----- Units
	void 			SetUnits(ViewUnits newUnits);
	
	// ----- Mouse Action
	BR_Boolean 		IsTracking() const;
	void 			SetMouseAction(BR_CMouseAction* action);

	// ----- Focus
	BR_Boolean 		SetSubviewFocus();

	// ----- Resize constraint
	virtual void 	GetSizeConstraints(BR_CPoint &ptMinSize,
									   BR_CPoint &ptMaxSize) const;

	//----------------------------------------------------------------------------
	// protected Implementation
	//----------------------------------------------------------------------------
	
	// ----- Conversion
	void 				BedTranslateUnits(BR_CPoint *pts,
						   					unsigned short count,
						   					ViewUnits inUnit,
						   					ViewUnits outUnit) const;
	void 				BedScalePoints(BR_CPoint *pts,
										unsigned short count,
										unsigned short numerator,
										unsigned short denominator) const;
	void 				BedScreenToViewUnits(BR_CPoint *pts,
							 			 	unsigned short count) const;
	void 				BedViewToScreenUnits(BR_CPoint *pts,
							  				unsigned short count) const;

	// ----- Refresh
	void				BedRefreshDifference(const BR_CRectangle &oldFrame, 
											const BR_CRectangle &newFrame);

	// ----- Show/Hide subviews
	void				BedShowHideSubviews(BR_Boolean state);
	BR_Boolean 			BedIsVisible() const;

	// ----- Layout
	void 				BedNotifySubviewsOfFrameChange(const BR_CRectangle &oldInterior,
													BR_Boolean redraw);
	
	// ----- Canvas
	virtual BR_CCanvas *BedLookForDrawingCanvas() const;
	virtual void 		BedSetDrawingCanvas(BR_CCanvas* canvas);	
	virtual BR_CView	*BedGetViewWithCanvas() const;

	// ----- Frame
	void 				BedSetFrame(BR_Coordinate l,
				  	 				BR_Coordinate t,
				  	 				BR_Coordinate r,
				  	 				BR_Coordinate b);
	void 				BedSetFrame(const BR_CRectangle &newFrame);

	// ----- Delete all subviews
	void 				BedDeleteSubviews();
	
	// ----- Add/Remove to enclosure
	void 				BedAddToEnclosureList();
	void 				BedRemoveFromEnclosureList();

	// ----- Update coordinate cache
	void 				BedUpdateCoordinateCache();

private:
	BR_Boolean BedSetNext(BR_Boolean(BR_CView::*pSetNextView)(BR_Boolean &,
														   BR_Boolean),
					   BR_CView *(BR_CView::*pGetNextView)(const BR_CView &,
														   BR_Boolean),
					   BR_Boolean(BR_CView::*pSetFirstView)(BR_Boolean),
					   BR_Boolean &relinquishFocusFailed,
					   BR_Boolean topLevel);
	BR_Boolean BedSetFirst(BR_Boolean(BR_CView::*pSetFirstSubview)(BR_Boolean),
						BR_CView *(BR_CView::*pGetFirstSubview)(),
						BR_CView *(BR_CView::*pGetNextSubview)(const BR_CView &,
															   BR_Boolean),
						BR_Boolean topLevel);

private:
#ifdef BR_DEBUG
	BR_Boolean				fAlreadyInitialized:1;					
#endif
	BC_TUnboundedCollection<BR_CView *, BC_CUnmanaged> *fSubviewList;
	BR_CView 				*fEnclosure;			// The view's enclosure
	ViewId 					fViewId;
	BR_CHelp::HelpTopic		fHelpTopic;				// Help topic associated with this view
	BR_CRectangle 			fFrame;					// The current position and size
	ViewUnits 				fViewUnits;				// The mapping mode of the view
	BR_Boolean 				fVisible:1;				// visible flag
	BR_Boolean				fAutoRedraw:1;			// Auto refresh flag
	BR_Boolean 				fShouldEraseBackground:1;		// Erase the background in DoDraw() ?
	BR_Boolean 				fRefreshAllWhenResized:1;		// the whole view must be refresh when resized
	BR_Boolean 				fDynCursor:1;			// Was cursor created dynamically
	BR_CView 				*fActiveView;			// The currently active subview
	BR_Coordinate 			fXOrigin;				// The view's x origin
	BR_Coordinate 			fYOrigin;				// The view's y origin
	unsigned short 		fScalingNumerator;		// Scaling factors
	unsigned short 		fScalingDenominator;
	BR_CPoint				fViewSizing;			// Size and Position Determiner
	BR_CCanvas				*fDrawingCanvas;		// Drawing canvas of the view
	BR_CFont				*fViewFont;				// The current font
	BC_TUnboundedOrderedCollection<BR_CBedAdornerHandle *, BC_CUnmanaged> *fAdornerList;
		// A list of Draw objects to Draw
	BR_CCursor				*fViewCursor;			// The current cursor
	BR_CMouseAction			*fMouseAction;			// The current mouse action
	BR_CColor 				fBackgroundColor;		// The background color
	BR_CColor 				fTextColor;				// Text foreground color
	BR_CColor 				fTextBackgroundColor;	// Text background color
	BR_CDynamicCharString		*fViewCaption;			// Caption for the view if not platform-based
	BR_CViewHelper			*fViewHelper;			// Helper view associated with this view
	static BR_CView 		*gFocusedView;			// view that has the focus
	static BR_CView		*gDrawingView;			// the currently prepared view

	// ----- Cache for view<->canvas conversion
	BR_CCanvas				*fCachedCanvas;
	BR_CPoint				fCanvasOrigin;
	BR_CPoint				fViewToCanvasOffset;			
	BR_CRectangle			fVisibleInterior;		// The interior of the view that could be
                                                	// "visible" through all its enclosures
                                                	// (not taking clipping into account)
	
//----------------------------------------------------------------------------------------
// Printing
//----------------------------------------------------------------------------------------
public:
	virtual void 	SetPrintClip();				// Not correct params

	// To handle variable-sized pages, you must override GetPageLocation.  You must also
	// either override GetPageCount or GetNumPageStrips.

	// To handle fixed-size pages which are smaller than the printingRectangle (e.g., fixed-
	// height lines of text which you want to break between lines) only override 
	// AdjustPrintingPageSize.  (The default versions of GetPageLocation and GetPageCount
	// call AdjustPrintingPageSize).

	// given Page number and printing Rectangle printingRectangle,
	// calculate which portion of the pane will print on that Page.
	// Also, override this routine to print vertical strips rather than horizontal strips
	// The printer will clip to the returned pageRectangle.
	virtual void GetPageLocation(unsigned long pageNum,
								 const BR_CPoint& printingPageSize,
								 BR_CRectangle& pageRectangle) const;

	// GetPageCount calls GetNumPageStrips twice and multiplies the results.
	virtual unsigned long GetPageCount(const BR_CPoint& printingPageSize) const;
	
	// not normally overridden
	virtual void PrintPage(const BR_CRectangle& pageRectangle,
						   unsigned long nPage);

	// following routine is used by BR_CPrinter to
	// do necessary coordinate conversion
	virtual void ClipRectangleToSuperPane(const BR_CView& superPane,
										  BR_CRectangle& clipRectangle) const;

protected:
	// may override GetNumPageStrips (e.g., only print one page wide, or you need variable-sized
	// pages and don't override GetPageCount).
	virtual unsigned long GetNumPageStrips(const BR_CPoint& printingPageSize,
										   BR_Boolean verticalStrips) const;

	// Called (by default) by GetPageCount and GetPageLocation to adjust the printing page size
	// (to be smaller) to print less per page.
	// Override only for fixed-size pages smaller than the printingRectangle.
	// Default version does nothing.
	// Would never by used for variable-sized pages.
	virtual void AdjustPrintingPageSize(BR_CPoint& printingPageSize) const;

	// Override GetSubsetOfInteriorToPrint to specify a portion of the pane's interior to Draw (e.g., to implement
	// Print Selection, you would return the bounds of the selection).
	// By default, calls GetInterior
	// Called by GetPageLocation and GetNumPageStrips.
	virtual void GetSubsetOfInteriorToPrint(BR_CRectangle& printingBounds) const;

	// Don't override this unless you really know what you are doing
	// (normally you don't need to)
	virtual void PrintSubviews(const BR_CRectangle& pageRectangle,
							   unsigned long nPage);

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	void 				BedMacDoWindowActivated(BR_Boolean activate);
	virtual void 		BedMacWindowActivated(BR_Boolean activate);
	
	virtual void 		DispatchClick(const BR_CPoint &where,
							   		  EventRecord &macEvent);
	virtual void 		DispatchCursor(const BR_CPoint &where,
									   RgnHandle mouseRgn);
	virtual BR_CView 	*FindEnabledSubview(const BR_CPoint &aPoint) const;

	static void 		SetLastViewClicked(BR_CView *aView);
	static BR_CView 	*GetLastViewClicked();

private:
	static BR_CView *gLastClickedView;				// last view clicked
	static unsigned short gMultiClickCount;			// multi-click counter for gLastClickedView
	static RgnHandle gMacUtilRgn;					// a utility region
#endif

//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	typedef void(BR_CView::*BedWinMouseMessageProc)(const BR_CPoint &pt,
											  KeyModifiers keyFlags);	
public:
	virtual BR_Boolean 	DoMenuChar(WORD wParam,
								  		LONG lParam,
								  		BR_CMenu &menu,
								  		LONG &returnValue);

	virtual LONG 			Dispatch(WORD wMessage,
						  			WORD wParam,
						  			LONG lParam,
						  			BR_Boolean callDefaultProc = TRUE);
						  
	virtual LONG 			DoDefaultProc(WORD wMessage,
							   			  WORD wParam,
							   			  LONG lParam);	
							   
	void 					CreateChildWindow(BR_CView *enclosure,
											  BedWinClassId classId,
											  ViewStyle fStyle);
protected:
	virtual HWND 			GetRealHandle() const;			
		// Overridden by BR_CMDIAppDesktop to return GetClient()
		
	virtual void 			BedWinMouseDownHook(WORD message);

	virtual BR_CView 		*GetLastViewWithFocus() const;
	virtual void 			SetLastViewWithFocus(BR_CView *theView);

	BR_CView 				*BedWinGetSubviewFocus() const;		
#endif

	BR_SETCLASSNAME(BR_CView);
};

//----------------------------------------------------------------------------------------
//	BR_CView::GetNumSubviews
//----------------------------------------------------------------------------------------

inline BC_Index BR_CView::GetNumSubviews() const
{
	return fSubviewList == NULL ? 0 : fSubviewList->Length();
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetEnclosure
//----------------------------------------------------------------------------------------
inline BR_CView *BR_CView::GetEnclosure() const
{
	return fEnclosure;
}

//----------------------------------------------------------------------------------------
// BR_CView::GetViewSizing
//----------------------------------------------------------------------------------------

inline void BR_CView::GetViewSizing(BR_CPoint& viewSizing) const
{
	viewSizing = fViewSizing;
}

//----------------------------------------------------------------------------------------
// BR_CView::GetViewId
//----------------------------------------------------------------------------------------

inline BR_CView::ViewId BR_CView::GetViewId() const
{
	return fViewId;
}

//----------------------------------------------------------------------------------------
//	BR_CView::SetViewId
//----------------------------------------------------------------------------------------

inline void BR_CView::SetViewId(ViewId viewId)
{
	fViewId = viewId;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedIsVisible
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CView::BedIsVisible() const
{
	return fVisible;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetUnits
//----------------------------------------------------------------------------------------
inline BR_CView::ViewUnits BR_CView::GetUnits() const
{
	return fViewUnits;
}

//----------------------------------------------------------------------------------------
//	BR_CView::SetUnits
//----------------------------------------------------------------------------------------
inline void BR_CView::SetUnits(ViewUnits newUnits)
{
	fViewUnits = newUnits;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedSetFrame
//----------------------------------------------------------------------------------------
inline void BR_CView::BedSetFrame(const BR_CRectangle &aRect)
{
	fFrame = aRect;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedSetFrame
//----------------------------------------------------------------------------------------
inline void BR_CView::BedSetFrame(BR_Coordinate l, BR_Coordinate t, BR_Coordinate r, BR_Coordinate b)
{
	fFrame.Set(l, t, r, b);
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetFocus
//----------------------------------------------------------------------------------------
inline BR_CView *BR_CView::GetFocus()
{
	return BR_CView::gFocusedView;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetActiveSubview
//----------------------------------------------------------------------------------------
inline BR_CView *BR_CView::GetActiveSubview() const
{
	return fActiveView;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetAutoRedraw
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CView::GetAutoRedraw() const
{
	return fAutoRedraw;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetScaling
//----------------------------------------------------------------------------------------

inline void BR_CView::GetScaling(unsigned short& numerator,
						 	 			unsigned short& denominator) const
{
	numerator = fScalingNumerator;
	denominator = fScalingDenominator;
}

//----------------------------------------------------------------------------------------
//	BR_CView::ShouldEraseBackground
//----------------------------------------------------------------------------------------

inline void BR_CView::SetShouldEraseBackground(BR_Boolean state)
{
	fShouldEraseBackground = state;
}

//----------------------------------------------------------------------------------------
//	BR_CView::ShouldEraseBackground
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CView::ShouldEraseBackground()
{
	return fShouldEraseBackground;
}

//----------------------------------------------------------------------------------------
//	BR_CView::RefreshAllWhenResized
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CView::RefreshAllWhenResized()
{
	return fRefreshAllWhenResized;
}

//----------------------------------------------------------------------------------------
//	BR_CView::SetRefreshAllWhenResized
//----------------------------------------------------------------------------------------
inline void BR_CView::SetRefreshAllWhenResized(BR_Boolean state)
{
	fRefreshAllWhenResized = state;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetCanvas
//	
//	return the drawing canvas of this view
//----------------------------------------------------------------------------------------

inline BR_CCanvas* BR_CView::GetCanvas() const
{
	return fDrawingCanvas;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetViewHelper
//----------------------------------------------------------------------------------------
inline BR_CViewHelper* BR_CView::BedGetViewHelper() const
{
	return fViewHelper;
}

//----------------------------------------------------------------------------------------
//	BR_CView::SetViewHelper
//----------------------------------------------------------------------------------------
inline void BR_CView::BedSetViewHelper(BR_CViewHelper *viewHelper)
{
	fViewHelper = viewHelper;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetViewFont
//----------------------------------------------------------------------------------------
inline BR_CFont* BR_CView::GetViewFont() const
{
	return fViewFont;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetNumDrawObjects
//----------------------------------------------------------------------------------------
inline unsigned long BR_CView::GetNumAdorners() const
{
	return fAdornerList == NULL ? 0 : fAdornerList->Length();
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetMouseAction
//----------------------------------------------------------------------------------------
inline BR_CMouseAction* BR_CView::GetMouseAction() const
{
	return fMouseAction;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetMouseAction
//----------------------------------------------------------------------------------------
inline void BR_CView::SetMouseAction(BR_CMouseAction* action)
{
	fMouseAction = action;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetTextColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CView::GetTextColor() const
{
	return fTextColor;
}

//----------------------------------------------------------------------------------------
//	BR_CView::GetTextBackgroundColor
//----------------------------------------------------------------------------------------
inline BR_CColor BR_CView::GetTextBackgroundColor() const
{
	return fTextBackgroundColor;
}

//----------------------------------------------------------------------------------------
//  BR_CView::IsEnclosing
//
//		Determines if a view (enclosedView) is enclosed (directly or
//		indirectly) by 'this' view
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CView::IsEnclosing(const BR_CView &enclosedView) const
{
	return enclosedView.IsEnclosedBy(*this);
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedIsDrawing
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CView::BedIsDrawing() const
{
	return (this == gDrawingView);
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedSetDrawingView
//----------------------------------------------------------------------------------------
inline void BR_CView::BedSetDrawingView(BR_CView *view)
{
	gDrawingView = view;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetDrawingView
//----------------------------------------------------------------------------------------
inline BR_CView *BR_CView::BedGetDrawingView()
{
	return gDrawingView;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetCachedCanvas
//----------------------------------------------------------------------------------------
inline BR_CCanvas *BR_CView::BedGetCachedCanvas() const
{
	return fCachedCanvas;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetViewToCanvasOffset
//----------------------------------------------------------------------------------------
inline void BR_CView::BedGetViewToCanvasOffset(BR_CPoint &viewToCanvasOffset) const
{
	viewToCanvasOffset = fViewToCanvasOffset;
}

//----------------------------------------------------------------------------------------
//	BR_CView::BedGetCanvasOrigin
//----------------------------------------------------------------------------------------
inline void BR_CView::BedGetCanvasOrigin(BR_CPoint &canvasOrigin) const
{
	canvasOrigin = fCanvasOrigin;
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CView::SetLastViewClicked
//----------------------------------------------------------------------------------------
inline static void BR_CView::SetLastViewClicked(BR_CView *aView)
{
	gLastClickedView = aView;
}
#endif
	
#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
//	BR_CView::GetLastViewClicked
//----------------------------------------------------------------------------------------
inline static BR_CView *BR_CView::GetLastViewClicked()
{
	return gLastClickedView;
}
#endif

//========================================================================================
//	BR_SViewResource
//
//	This defines the structure of the view resource
//========================================================================================

struct BR_SViewResource : BR_SResource
{
    BR_CView::ViewUnits 	fViewUnits;
    BR_CView::ViewId		fViewId;
    BR_CHelp::HelpTopic		fHelpTopic;
	BR_Distance 			fWidth;
	BR_Distance 			fHeight;
	BR_Coordinate 			fX;
	BR_Coordinate 			fY;
	BR_CView::ViewSizing 	fHorizontalSizing;
	BR_CView::ViewSizing 	fVerticalSizing;
	BR_CColor::RGBValue 	fBkColor;
	BR_ResourceId 			fCursorId;
	BR_Boolean 				fCursorIsSystem;
};

#endif