#ifndef BRTYPES_H
#define BRTYPES_H
//========================================================================================
//
//     File:			BRTypes.r
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	March 30, 1991
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   SKIPINCL_R
#include "SkipIncl.r"
#endif

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BRRCDEFI_H
#include "BRRCDefi.h"
#endif

#ifndef BRRESTYP_H
#include "BRResTyp.h"
#endif

#ifndef BRVIEWID_K
#include "BRViewId.k"
#endif

#ifndef BRCMDIDS_H
#include "BRCmdIds.h"
#endif

#ifndef BRFONIDS_H
#include "BRFonIds.h"
#endif

#ifndef BRSTRIDS_H
#include "BRStrIds.h"
#endif

#ifndef BRWINDOW_K
#include "BRWindow.k"
#endif

#ifndef BRCONTRO_K
#include "BRContro.k"
#endif

#ifndef BREDITCO_K
#include "BREditCo.k"
#endif

#ifndef BRLISTBX_K
#include "BRListBx.k"
#endif

#ifndef BRENTRYL_K
#include "BREntryL.k"
#endif

#ifndef BRBUTTON_K
#include "BRButton.k"
#endif

#ifndef BRSCROLB_K
#include "BRScrolB.k"
#endif

#ifndef BRCOLOR_K
#include "BRColor.k"
#endif

#ifndef BRSYSTEM_K
#include "BRSystem.k"
#endif

#ifndef BRVIEW_K
#include "BRView.k"
#endif

#ifndef BRPEN_K
#include "BRPen.k"
#endif

#ifndef BRGRCOMM_K
#include "BRGrComm.k"
#endif

#ifndef BRPOPMNU_K
#include "BRPopMnu.k"
#endif

#ifndef BRADORN_K
#include "BRAdorn.k"
#endif

#ifndef   BRSCROLL_H
#include "BRScroll.k"
#endif

//========================================================================================
// Basic type definitions
//========================================================================================

#define Color   longint
#define Boolean integer

//----------------------------------------------------------------------------------------
// TYPE BedRect
//----------------------------------------------------------------------------------------

type BedRect
{
	longint /* fLeft */;
	longint /* fTop */;
	longint /* fRight */;
	longint /* fBottom */;
};

//----------------------------------------------------------------------------------------
// TYPE BedRect
//----------------------------------------------------------------------------------------

type LongRect
{
	longint /* width */;
	longint /* height */;
	longint /* X */;
	longint /* Y */;
};

//----------------------------------------------------------------------------------------
// TYPE BedRect
//----------------------------------------------------------------------------------------

type Point
{
	longint;    // fX
	longint;    // fY
};

//========================================================================================
// Header info for any resource type loaded by BR_RResourcObject.
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE BR_RHeader
//----------------------------------------------------------------------------------------

type BR_RHeader
{
    static idct = 0; // ??? take this out eventually
    set idct = idct + 1;
    length: unsigned integer = 0;
        unsigned integer = idct;
    parent: unsigned integer = 0;
    ids:    cstring = "";
        align word;
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBaseRes
//----------------------------------------------------------------------------------------

type BR_RBaseRes : BR_RHeader(ids="")
{
    dummy: unsigned integer = 1111;
};

//========================================================================================
// ItemHelper resource types
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE BR_RItemHelper
//----------------------------------------------------------------------------------------

type BR_RItemHelper : BR_RBaseRes(ids="_abstract_")
{
	unsigned integer;		// fLeftMargin
	unsigned integer;		// fRightMargin
};

//----------------------------------------------------------------------------------------
// TYPE BR_RTextItemHelper
//----------------------------------------------------------------------------------------

type BR_RTextItemHelper : BR_RItemHelper(ids="BR_CTextItemHelper")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBitmapGridItemHelper
//----------------------------------------------------------------------------------------

type BR_RBitmapGridItemHelper : BR_RItemHelper(ids="BR_CBitmapGridItemHelper")
{
    unsigned integer;       // Bitmap resource Id
    unsigned integer;       // Bitmap usage fFlags
};


//========================================================================================
// View resource types
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE BR_RView
//----------------------------------------------------------------------------------------

type BR_RView : BR_RBaseRes(ids="BR_CView")
{
    integer;  				// ViewUnits
    integer;  				// ViewId
    longint;  				// help topic id (0 implies none)
	LongRect; 				// w,h,x,y
	unsigned integer;  	// Horizontal Sizing
	unsigned integer;  	// Vertical Sizing
	Color;    				// Background color
	integer;  				// Cursor Id
	Boolean;  				// CursorIsSystem
};

//----------------------------------------------------------------------------------------
// TYPE BR_RWindow
//----------------------------------------------------------------------------------------

type BR_RWindow : BR_RView(ids="BR_CWindow")
{
	cstring[64] ;
	longint;		// because we are using ViewStyle
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDialogBox
//----------------------------------------------------------------------------------------

type BR_RDialogBox : BR_RWindow(ids="BR_CDialogBox")
{
    unsigned integer;       // Font id    (use NULL for system font)
    unsigned integer;       // Font size
    unsigned integer;       // Font fStyle
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDocWindow
//----------------------------------------------------------------------------------------

type BR_RDocWindow : BR_RWindow(ids="BR_CDocWindow")
{
	unsigned integer;     // Icon Id
};

//----------------------------------------------------------------------------------------
// TYPE BR_RFloatingWindow
//----------------------------------------------------------------------------------------

type BR_RFloatingWindow : BR_RWindow(ids="BR_CFloatingWindow")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RControlGroup
//----------------------------------------------------------------------------------------

type BR_RControlGroup : BR_RView(ids="BR_CControlGroup")
{
	cstring[64];
};

//----------------------------------------------------------------------------------------
// TYPE BR_RRadioGroup
//----------------------------------------------------------------------------------------

type BR_RRadioGroup : BR_RControlGroup(ids="BR_CRadioGroup")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RStatusBar
//----------------------------------------------------------------------------------------

type BR_RStatusBar : BR_RView(ids="BR_CStatusBar")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RControl
//----------------------------------------------------------------------------------------

type BR_RControl : BR_RView(ids="BR_CControl")
{
    fStyle: unsigned longint = 0;     // dwStyle
};

//----------------------------------------------------------------------------------------
// TYPE BR_REditControl
//----------------------------------------------------------------------------------------

type BR_REditControl : BR_RControl(ids="BR_CEditControl", fStyle=BEDCS_BORDER|BEDES_AUTOHSCROLL)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RMultiLineEdit
//----------------------------------------------------------------------------------------

type BR_RMultiLineEdit : BR_REditControl(fStyle = BEDCS_BORDER|BEDES_AUTOHSCROLL|BEDES_AUTOVSCROLL|BEDES_MULTILINE)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RPasswordField
//----------------------------------------------------------------------------------------

type BR_RPasswordField : BR_REditControl(ids="BR_CPasswordField")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RNumberField
//----------------------------------------------------------------------------------------

type BR_RNumberField : BR_REditControl(ids="BR_CNumberField")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDateField
//----------------------------------------------------------------------------------------

type BR_RDateField : BR_REditControl(ids="BR_CDateField")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RTimeField
//----------------------------------------------------------------------------------------

type BR_RTimeField : BR_REditControl(ids="BR_CTimeField")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RListBoxBase
//----------------------------------------------------------------------------------------

type BR_RListBoxBase : BR_RControl(ids="_abstract_")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RListBox
//----------------------------------------------------------------------------------------

type BR_RListBox : BR_RListBoxBase(ids="BR_CListBox", fStyle=(kBedLBSNotify |
														kBedLBSVerticalScroll |
														kBedLBSNoIntegralHeight |
														BEDCS_BORDER))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSortedListBox
//----------------------------------------------------------------------------------------

type BR_RSortedListBox : BR_RListBox(ids="BR_CListBox",
							   fStyle=(kBedLBSNotify | kBedLBSVerticalScroll |
									  kBedLBSNoIntegralHeight | kBedLBSSorted |
									  BEDCS_BORDER))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBorderLessListBox
//----------------------------------------------------------------------------------------

type BR_RBorderLessListBox : BR_RListBox(ids="BR_CListBox",
								   fStyle=(kBedLBSNotify | kBedLBSVerticalScroll |
								   kBedLBSNoIntegralHeight))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_REntryListBoxBase
//----------------------------------------------------------------------------------------

type BR_REntryListBoxBase : BR_RControl(ids="BR_CEntryListBox")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_REntryListBox
//----------------------------------------------------------------------------------------

type BR_REntryListBox : BR_REntryListBoxBase(ids="BR_CEntryListBox",
									   fStyle=(kBedELSSimple | kBedELSVerticalScroll |
											  kBedELSNoIntegralHeight | kBedELSSorted))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDropDownEntryListBox
//----------------------------------------------------------------------------------------

type BR_RDropDownEntryListBox : BR_REntryListBoxBase(ids="BR_CEntryListBox",
											   fStyle=(kBedELSDropDown |
													  kBedELSVerticalScroll |
													  kBedELSNoIntegralHeight |
													  kBedELSSorted))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDropDownListEntryListBox
//----------------------------------------------------------------------------------------

type BR_RDropDownListEntryListBox : BR_REntryListBoxBase(ids="BR_CEntryListBox",
												   fStyle=(kBedELSDropDownList |
														  kBedELSVerticalScroll |
														  kBedELSNoIntegralHeight |
														  kBedELSSorted))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSFPFileListBox
//----------------------------------------------------------------------------------------

type BR_RSFPFileListBox : BR_RListBox(ids="BR_CTextListBox", fStyle=(kBedLBSNotify |
															   kBedLBSVerticalScroll |
															   BEDCS_BORDER | kBedLBSSorted))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSFPMultiSelFileListBox
//----------------------------------------------------------------------------------------

type BR_RSFPMultiSelFileListBox : BR_RListBox(ids="BR_CTextListBox", fStyle=(kBedLBSNotify |
																	   kBedLBSVerticalScroll |
																	   BEDCS_BORDER |
																	   kBedLBSSorted |
																	   kBedLBSExtendedSelection |
																	   kBedLBSMultipleSelection))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSFPDirListBox
//----------------------------------------------------------------------------------------

type BR_RSFPDirListBox : BR_RListBox(ids="BR_CTextListBox", fStyle=(kBedLBSNotify |
															  kBedLBSVerticalScroll |
															  BEDCS_BORDER | kBedLBSSorted))
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RButton
//----------------------------------------------------------------------------------------

type BR_RButton : BR_RControl(ids="BR_CButton")
{
	cstring[128]; // text 
};

//----------------------------------------------------------------------------------------
// TYPE BR_RMacCustomPopupMenuButton
//----------------------------------------------------------------------------------------

#ifdef BR_BUILD_MAC
type BR_RMacCustomPopupMenuButton : BR_RControl(ids="BR_CMacCustomPopupMenuButton")
{
	integer;		// label justification
	cstring[128];	// buttonLabel
};
#endif

//----------------------------------------------------------------------------------------
// TYPE BR_RPushButton
//----------------------------------------------------------------------------------------

type BR_RPushButton : BR_RButton(ids="BR_CPushButton",fStyle=BEDBS_PUSHBUTTON)
{
	unsigned integer;  // fBitmapResourceId
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBitmapPushButton
//----------------------------------------------------------------------------------------

type BR_RBitmapPushButton : BR_RPushButton(ids="BR_CPushButton", fStyle=BEDBS_PUSHBUTTON | BEDBS_OWNERDRAW)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDefBitmapPushButton
//----------------------------------------------------------------------------------------

type BR_RDefBitmapPushButton : BR_RBitmapPushButton(ids="BR_CPushButton", fStyle=BEDBS_OWNERDRAW|BEDBS_DEFAULT)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDefPushButton
//----------------------------------------------------------------------------------------

type BR_RDefPushButton : BR_RPushButton(fStyle=BEDBS_DEFAULT)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RPopUpMenu
//----------------------------------------------------------------------------------------

type BR_RPopUpMenu : BR_RBitmapPushButton(ids="BR_CPopUpMenu")
{
	unsigned integer; // Menu Id
};

//----------------------------------------------------------------------------------------
// TYPE BR_RCheckedButton
//----------------------------------------------------------------------------------------

type BR_RCheckedButton : BR_RButton(ids="BR_CCheckedButton")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RRadioButton
//----------------------------------------------------------------------------------------

type BR_RRadioButton : BR_RCheckedButton(ids="BR_CRadioButton", fStyle=BEDBS_RADIOBUTTON)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RCheckBox
//----------------------------------------------------------------------------------------

type BR_RCheckBox : BR_RCheckedButton(ids="BR_CCheckBox", fStyle=BEDBS_AUTOCHECKBOX)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RAutoCheckBox
//----------------------------------------------------------------------------------------

type BR_RAutoCheckBox : BR_RCheckedButton(ids="BR_CCheckBox", fStyle=BEDBS_AUTOCHECKBOX)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_R3State
//----------------------------------------------------------------------------------------

type BR_R3State : BR_RCheckedButton(ids="BR_CTriStateCheckBox", fStyle=BEDBS_3STATE)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RAuto3State
//----------------------------------------------------------------------------------------

type BR_RAuto3State : BR_RCheckedButton(ids="BR_CTriStateCheckBox", fStyle=BEDBS_AUTO3STATE)
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RScrollBar
//----------------------------------------------------------------------------------------

type BR_RScrollBar : BR_RControl(ids="BR_CScrollBarControl")
{
	 ScrollBarOrientation:	unsigned integer;
	 ScrollBarLength:		longint;
	 ScrollBarThickness:	longint;
};

//----------------------------------------------------------------------------------------
// TYPE BR_RScrollerScrollBar
//----------------------------------------------------------------------------------------

type BR_RScrollerScrollBar : BR_RScrollBar(ids="BR_CScrollerScrollBar")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RScrollerInfo
//----------------------------------------------------------------------------------------

type BR_RScrollerInfo
{
	DistancePerStep:			longint;
	OverlapSteps:				longint;
	ScrollBarStyle:				integer;
	ScrollBarViewId:			integer;
	ScrollBarHelpTopic:			longint;
	ScrollBarThickness:			longint; 	/* only for control style */
	ScrollBarOffsetFromStart:	longint;	/* only for control style */
	ScrollBarOffsetFromEnd:		longint;	/* only for control style */
};

//----------------------------------------------------------------------------------------
// TYPE BR_RScroller
//----------------------------------------------------------------------------------------

type BR_RScroller : BR_RView(ids="BR_CScroller")
{
	HorizontalInfo:	BR_RScrollerInfo;
	VerticalInfo:	BR_RScrollerInfo;
};

//----------------------------------------------------------------------------------------
// TYPE BR_RGrid
//----------------------------------------------------------------------------------------

type BR_RGrid : BR_RView(ids="BR_CGrid")
{
	unsigned integer;  // fNumberOfRows
	unsigned integer;  // fNumberOfColumns
};

//----------------------------------------------------------------------------------------
// TYPE BR_RStaticText
//----------------------------------------------------------------------------------------

type BR_RStaticText : BR_RView(ids="BR_CStaticText")
{	
	LongRect;
	cstring[128];
	unsigned longint;
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSingleLineText
//----------------------------------------------------------------------------------------

type BR_RSingleLineText : BR_RView(ids="BR_CStaticText")
{
	LongRect;
	cstring[128];
	unsigned longint;
};

//----------------------------------------------------------------------------------------
// TYPE BR_RSelectText
//----------------------------------------------------------------------------------------

type BR_RSelectText : BR_RStaticText(ids="BR_CSelectText")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_REditText
//----------------------------------------------------------------------------------------

type BR_REditText : BR_RSelectText(ids="BR_CEditText")
{
};

//========================================================================================
// Adorner resources
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE BR_RAdorner
//----------------------------------------------------------------------------------------

type BR_RAdorner : BR_RBaseRes(ids = "BR_CAdorner")
{
	integer;	// adorner identifier
    longint;  	// Adorn priority
	Boolean;	// Auto delete
	Boolean;	// Shared adorner
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBaseShapeAdorner
//----------------------------------------------------------------------------------------

type BR_RBaseShapeAdorner : BR_RAdorner(ids = "_abstract_")
{
	unsigned integer;							// pen thickness
	Color;										// pen Color
	integer;									// pen style
};

//----------------------------------------------------------------------------------------
// TYPE BR_REraseAdorner
//----------------------------------------------------------------------------------------

type BR_REraseAdorner : BR_RAdorner(ids = "BR_CEraseAdorner")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RDrawAdorner
//----------------------------------------------------------------------------------------

type BR_RDrawAdorner : BR_RAdorner(ids = "BR_CDrawAdorner")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RLineAdorner
//----------------------------------------------------------------------------------------

type BR_RLineAdorner : BR_RBaseShapeAdorner(ids = "BR_CLineAdorner")
{
	Point;										// One end
	Point;										// The other end
};

//----------------------------------------------------------------------------------------
// TYPE BR_RShapeAdorner
//----------------------------------------------------------------------------------------

type BR_RShapeAdorner : BR_RBaseShapeAdorner(ids = "_abstract_")
{
	Color;										// fill color
};

//----------------------------------------------------------------------------------------
// TYPE BR_RShadowFramedAdorner
//----------------------------------------------------------------------------------------

type BR_RShadowFramedAdorner : BR_RShapeAdorner(ids = "BR_CShadowFramedAdorner")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RRectangleAdorner
//----------------------------------------------------------------------------------------

type BR_RRectangleAdorner : BR_RShapeAdorner(ids = "BR_CRectangleAdorner")
{
	BedRect;									// Rect size
};

//----------------------------------------------------------------------------------------
// TYPE BR_RRoundRectAdorner
//----------------------------------------------------------------------------------------

type BR_RRoundRectAdorner : BR_RRectangleAdorner(ids = "BR_CRoundRectAdorner")
{
	integer;									// Corner horiz radius
	integer;									// Corner vert  radius
};

//----------------------------------------------------------------------------------------
// TYPE BR_REllipseAdorner
//----------------------------------------------------------------------------------------

type BR_REllipseAdorner : BR_RShapeAdorner(ids = "BR_CEllipseAdorner")
{
	BedRect;									// size
};

//----------------------------------------------------------------------------------------
// TYPE BR_RImageAdorner
//----------------------------------------------------------------------------------------

type BR_RImageAdorner : BR_RAdorner(ids = "BR_CImageAdorner")
{
	Point;									// location
};

//----------------------------------------------------------------------------------------
// TYPE BR_RIconAdorner
//----------------------------------------------------------------------------------------

type BR_RIconAdorner : BR_RImageAdorner(ids = "BR_CIconAdorner")
{
	unsigned integer;							// icon resource id
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBitmapAdorner
//----------------------------------------------------------------------------------------

type BR_RBitmapAdorner : BR_RImageAdorner(ids = "BR_CBitmapAdorner")
{
	unsigned integer;							// bitmap resource id
};

//----------------------------------------------------------------------------------------
// TYPE BR_RTextAdorner
//----------------------------------------------------------------------------------------

type BR_RTextAdorner : BR_RAdorner(ids = "BR_CTextAdorner")
{
	BedRect;									// Frame
	cstring[128];								// Text
	unsigned integer;							// Font id
	unsigned integer;							// Font size
	unsigned integer;							// Font fStyle
	Color;										// Text color
	unsigned integer;							// Text justification fStyle
};

//----------------------------------------------------------------------------------------
// TYPE BR_RLabel
//----------------------------------------------------------------------------------------

type BR_RLabel : BR_RTextAdorner(ids="BR_CLabel")
{
};


//========================================================================================
// Root Bedrock resource types
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE bclview
//----------------------------------------------------------------------------------------

type bclview(WVIEWRES,LVIEWRES)
{
    static idct = 0;
    auto me = idct + 1;
   start:
    BR_RHeader(parent,length = (stop - start) / 8);
   stop:
    array { bclview /* = BR_RHeader */ (parent = me); };
};

//----------------------------------------------------------------------------------------
// TYPE bclmenu
//----------------------------------------------------------------------------------------

type bclmenu(WMENURES,LMENURES)
{
    static idct = 0;
    auto me = idct + 1;
    start:
    BR_RHeader(parent, length = (stop - start) / 8);
    stop:
    array { bclmenu (parent = me); };
};

//----------------------------------------------------------------------------------------
// TYPE bclmultilong
//----------------------------------------------------------------------------------------

type bclmultilong(WMULTILONGRES,LMULTILONGRES)
{
  #ifdef BUGFIXED704
    integer=$$CountOf(TheArray);  // Entries in the array 'TheArray'
    array TheArray                // TheArray:
    {                             //
        longint;                  // fKeyValue
        longint;                  // fDataValue
    };
  #else
    integer=(stop-start)/(8*8);   // Entries in the array 'TheArray'
    start: array TheArray         // TheArray:
    {                             //
        longint;                  // fKeyValue
        longint;                  // fDataValue
    };                            //
    stop: integer=0;              // Unused ('stop' label needs identifier)
  #endif
};

//----------------------------------------------------------------------------------------
// TYPE BR_RAppleEventsDispatchTable
//----------------------------------------------------------------------------------------

type BR_RAppleEventsDispatchTable(WMESSAGE_DISPATCH_TABLE_RESOURCE,LMESSAGE_DISPATCH_TABLE_RESOURCE)
{
    integer=(stop-start)/(32*3);   // Entries in the array 'TheArray'
    start: array TheArray
    { 
		unsigned longint;			// Event class
        unsigned longint;			// Event Id
		longint;					// Message Id
    };
    stop: integer=0;              // Unused ('stop' label needs identifier)
};


//========================================================================================
// Convenience macros
//========================================================================================

#define BR_ViewHelp(helpId, viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor)  \
       BR_RView(viewUnits, id, helpId, {width,height,X,Y},  horizontalSizing, verticalSizing, bkColor, kArrowCursor, TRUE),
#define BR_View(            viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor)  \
        BR_ViewHelp(     0, viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor)

#define BR_ScrollerInfoDefault(scrollBarStyle) \
			kScrollerUseDefaultDistancePerStep,\
			kScrollerDefaultOverlap,\
			scrollBarStyle, \
			0, \
			0, \
			kScrollBarUseDefaultScrollBarThickness, \
			kScrollerDefaultScrollBarOffset, \
			kScrollerDefaultScrollBarOffset
		
#define BR_ScrollerInfoScrollBar(scrollBarId) \
			kScrollerUseDefaultDistancePerStep,\
			kScrollerDefaultOverlap,\
			kScrollerScrollBarStyleViewId, \
			scrollBarId, \
			0, \
			kScrollBarUseDefaultScrollBarThickness, \
			kScrollerDefaultScrollBarOffset, \
			kScrollerDefaultScrollBarOffset
		
#define BR_ScrollerHelp(helpId, units, id, X, Y, wd, ht, hsize, vsize, clr, hScrollerInfo, vScrollerInfo) \
		BR_RScroller(units, id, helpId, {wd, ht, X, Y}, hsize, vsize, clr, kArrowCursor, TRUE, {hScrollerInfo}, {vScrollerInfo}),
#define BR_Scroller(            units, id, X, Y, wd, ht, hsize, vsize, clr, hScrollerInfo, vScrollerInfo) \
		BR_RScroller(units, id, 0,      {wd, ht, X, Y}, hsize, vsize, clr, kArrowCursor, TRUE, {hScrollerInfo}, {vScrollerInfo}),

#define BR_ScrollerScrollBarHelp(helpId, id, orientation, X, Y, length, thickness, hSizing, vSizing) \
		BR_RScrollerScrollBar(kEnclosureUnits, id, helpId, {0, 0, X, Y}, hSizing, vSizing, kRGBEnclosure, kArrowCursor, TRUE, orientation, length, thickness),{}
#define BR_ScrollerScrollBar(            id, orientation, X, Y, length, thickness, hSizing, vSizing) \
		BR_ScrollerScrollBarHelp(     0, id, orientation, X, Y, length, thickness, hSizing, vSizing)

#define BR_ScrollBarHelp(helpId, id, orientation, X, Y, length, thickness, hSizing, vSizing) \
       BR_RScrollBar(kEnclosureUnits, id, helpId, {0, 0, X, Y}, hSizing, vSizing, kRGBEnclosure, kArrowCursor, TRUE, orientation, length, thickness),{}
#define BR_ScrollBar(            orientation, X, Y, length, thickness, hSizing, vSizing) \
        BR_ScrollBarHelp(     0, orientation, X, Y, length, thickness, hSizing, vSizing)

#ifdef BR_BUILD_MAC
#define BR_MacCustomPopupMenuButtonHelp(helpId, id, X, Y, width, height, just, title) \
       BR_RMacCustomPopupMenuButton(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE, just, title),{}
#define BR_MacCustomPopupMenuButton(            id, X, Y, width, height, just, title) \
        BR_MacCustomPopupMenuButtonHelp(     0, id, X, Y, width, height, just, title)
#endif

#define BR_DialogBoxHelp(helpId, szTitle, wStyle, X, Y, width, height) \
       BR_RDialogBox(kFontUnits, -1, helpId, {width,height,X,Y},  kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle, 0, 0, 0),
#define BR_DialogBox(            szTitle, wStyle, X, Y, width, height) \
        BR_DialogBoxHelp(     0, szTitle, wStyle, X, Y, width, height)

#define BR_DialogBoxFontHelp(helpId, szTitle, wStyle, X, Y, width, height, fFontId, fFontSize, fFontStyle) \
        BR_RDialogBox(kFontUnits, -1, helpId, {width,height,X,Y},  kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle, fFontId, fFontSize, fFontStyle),
#define BR_DialogBoxFont(            szTitle, wStyle, X, Y, width, height, fFontId, fFontSize, fFontStyle) \
        BR_DialogBoxFontHelp(     0, szTitle, wStyle, X, Y, width, height, fFontId, fFontSize, fFontStyle)

#define BR_WindowHelp(helpId, viewUnits, szTitle, wStyle, X, Y, width, height) \
       BR_RWindow(viewUnits, -1, helpId, {width,height,X,Y},  kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle),
#define BR_Window(            viewUnits, szTitle, wStyle, X, Y, width, height) \
        BR_WindowHelp(     0, viewUnits, szTitle, wStyle, X, Y, width, height)

#define BR_FloatingWindowHelp(helpId, viewUnits, szTitle, wStyle, X, Y, width, height) \
       BR_RFloatingWindow(viewUnits, -1, helpId, {width,height,X,Y}, kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle),
#define BR_FloatingWindow(            viewUnits, szTitle, wStyle, X, Y, width, height) \
        BR_FloatingWindowHelp(     0, viewUnits, szTitle, wStyle, X, Y, width, height)

#define BR_DocWindowHelp(helpId, viewUnits, szTitle, wStyle, X, Y, width, height) \
        BR_RDocWindow(viewUnits, -1, helpId, {width,height,X,Y},  kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle, 0),
#define BR_DocWindow(            viewUnits, szTitle, wStyle, X, Y, width, height) \
        BR_DocWindowHelp(     0, viewUnits, szTitle, wStyle, X, Y, width, height)

#define BR_DocumentWindowHelp(helpId, viewUnits, szTitle, wStyle, X, Y, width, height, wIconId) \
        BR_RDocWindow(viewUnits, -1, helpId, {width,height,X,Y},  kNoSizing, kNoSizing, kRGBWindow, kArrowCursor, TRUE, szTitle, wStyle, wIconId),
#define BR_DocumentWindow(            viewUnits, szTitle, wStyle, X, Y, width, height, wIconId) \
        BR_DocumentWindowHelp(     0, viewUnits, szTitle, wStyle, X, Y, width, height, wIconId)

#define BR_DialogPaneHelp(helpId, unused) \
       BR_RView(kEnclosureUnits, -1, helpId, {0,0,0,0}, kFitEnclosure, kFitEnclosure, kRGBWindow, kArrowCursor, TRUE),
#define BR_DialogPane(            unused) \
        BR_DialogPaneHelp(     0, unused)

#define BR_ListBoxHelp(helpId, id, X, Y, width, height) \
       BR_RListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),
#define BR_ListBox(            id, X, Y, width, height) \
        BR_ListBoxHelp(     0, id, X, Y, width, height)

#define BR_TextListBoxHelp(helpId, id, X, Y, width, height) \
       BR_RListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE), { BR_RTextItemHelper(0, 0), {}}
#define BR_TextListBox(            id, X, Y, width, height) \
        BR_TextListBoxHelp(     0, id, X, Y, width, height)

#define BR_EntryListBoxHelp(helpId, id, X, Y, width, height) \
       BR_REntryListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),
#define BR_EntryListBox(            id, X, Y, width, height) \
        BR_EntryListBoxHelp(     0, id, X, Y, width, height)

#define BR_DropDownEntryListBoxHelp(helpId, id, X, Y, width, height) \
       BR_RDropDownEntryListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),
#define BR_DropDownEntryListBox(            id, X, Y, width, height) \
        BR_DropDownEntryListBoxHelp(     0, id, X, Y, width, height)

#define BR_DropDownListEntryListBoxHelp(helpId, id, X, Y, width, height) \
       BR_RDropDownListEntryListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),
#define BR_DropDownListEntryListBox(            id, X, Y, width, height) \
        BR_DropDownListEntryListBoxHelp(     0, id, X, Y, width, height)

#define BR_PushButtonHelp(helpId, id, X, Y, width, height, text) \
       BR_RPushButton(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBTransparent, kArrowCursor, TRUE, text, 0),{}
#define BR_PushButton(            id, X, Y, width, height, text) \
        BR_PushButtonHelp(     0, id, X, Y, width, height, text)

#define BR_DefPushButtonHelp(helpId, id, X, Y, width, height, text) \
       BR_RDefPushButton(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBTransparent, kArrowCursor, TRUE, text, 0),{}
#define BR_DefPushButton(            id, X, Y, width, height, text) \
        BR_DefPushButtonHelp(     0, id, X, Y, width, height, text)

#define BR_BitmapPushButtonHelp(helpId, id, X, Y, width, height, fBitmapResourceId) \
       BR_RBitmapPushButton(kPixelUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBTransparent, kArrowCursor, TRUE, "", fBitmapResourceId),{}
#define BR_BitmapPushButton(            id, X, Y, width, height, fBitmapResourceId) \
        BR_BitmapPushButtonHelp(     0, id, X, Y, width, height, fBitmapResourceId)

#define BR_DefBitmapPushButtonHelp(helpId, id, X, Y, width, height, fBitmapResourceId) \
       BR_RDefBitmapPushButton(kPixelUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBTransparent, kArrowCursor, TRUE, "", fBitmapResourceId),{}
#define BR_DefBitmapPushButton(            id, X, Y, width, height, fBitmapResourceId) \
        BR_DefBitmapPushButtonHelp(     0, id, X, Y, width, height, fBitmapResourceId)

#define BR_RadioButtonHelp(helpId, id, X, Y, width, height, text) \
       BR_RRadioButton(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBEnclosure, kArrowCursor, TRUE, text),{}
#define BR_RadioButton(            id, X, Y, width, height, text) \
        BR_RadioButtonHelp(     0, id, X, Y, width, height, text)

#define BR_CheckBoxHelp(helpId, id, X, Y, width, height, text)  \
       BR_RCheckBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBEnclosure, kArrowCursor, TRUE, text),{}
#define BR_CheckBox(            id, X, Y, width, height, text)  \
        BR_CheckBoxHelp(     0, id, X, Y, width, height, text)

#define BR_TriStateBoxHelp(helpId, id, X, Y, width, height, text)  \
        BR_RAuto3State(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBEnclosure, kArrowCursor, TRUE, text),{}
#define BR_TriStateBox(            id, X, Y, width, height, text)  \
        BR_TriStateBoxHelp(     0, id, X, Y, width, height, text)

#define BR_EditFieldHelp(helpId, id, X, Y, width, height) \
       BR_REditControl(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}
#define BR_EditField(            id, X, Y, width, height) \
        BR_EditFieldHelp(     0, id, X, Y, width, height)

#define BR_PasswordFieldHelp(helpId, id, X, Y, width, height) \
       BR_RPasswordField(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}
#define BR_PasswordField(            id, X, Y, width, height) \
        BR_PasswordFieldHelp(     0, id, X, Y, width, height)

#define BR_NumberFieldHelp(helpId, id, X, Y, width, height) \
       BR_RNumberField(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}
#define BR_NumberField(            id, X, Y, width, height) \
        BR_NumberFieldHelp(     0, id, X, Y, width, height)

#define BR_DateFieldHelp(helpId, id, X, Y, width, height) \
       BR_RDateField(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}
#define BR_DateField(            id, X, Y, width, height) \
        BR_DateFieldHelp(     0, id, X, Y, width, height)

#define BR_TimeFieldHelp(helpId, id, X, Y, width, height) \
       BR_RTimeField(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE),{}
#define BR_TimeField(            id, X, Y, width, height) \
        BR_TimeFieldHelp(     0, id, X, Y, width, height)

#define BR_ControlGroupHelp(helpId, id, szTitle, x, y, width, height) \
       BR_RControlGroup(kEnclosureUnits, id, helpId, {width, height, x, y}, kNoSizing, kNoSizing, kRGBEnclosure, kArrowCursor, TRUE, szTitle),
#define BR_ControlGroup(            id, szTitle, x, y, width, height) \
        BR_ControlGroupHelp(     0, id, szTitle, x, y, width, height)

#define BR_RadioGroupHelp(helpId, id, szTitle, x, y, width, height) \
       BR_RRadioGroup(kEnclosureUnits, id, helpId, {width, height, x, y}, kNoSizing, kNoSizing, kRGBEnclosure, kArrowCursor, TRUE, szTitle),
#define BR_RadioGroup(            id, szTitle, x, y, width, height) \
        BR_RadioGroupHelp(     0, id, szTitle, x, y, width, height)

#define BR_DropDownListBoxHelp(helpId, id, X, Y, width, height) \
       BR_RDropDownListBox(kEnclosureUnits, id, helpId, {width, height, X, Y}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),{}
#define BR_DropDownListBox(            id, X, Y, width, height) \
        BR_DropDownListBoxHelp(     0, id, X, Y, width, height)

#define BR_DesktopPaneHelp(helpId, viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor) \
       BR_RDesktopPane(viewUnits, id, helpId, {width,height,X,Y},  horizontalSizing, verticalSizing, bkColor, kArrowCursor, TRUE),
#define BR_DesktopPane(            viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor) \
        BR_DesktopPaneHelp(     0, viewUnits, id, X, Y, width, height, horizontalSizing, verticalSizing, bkColor)

#define BR_StatusBarHelp(helpId, viewUnits, id, height, bkColor) \
       BR_RStatusBar(viewUnits, id, helpId, {0,height,0,0},  kFitEnclosure, kFixedBottom, bkColor, kArrowCursor, TRUE),
#define BR_StatusBar(            viewUnits, id, height, bkColor) \
        BR_StatusBarHelp(     0, viewUnits, id, height, bkColor)

#define BR_LeftDesktopPaletteHelp(helpId, viewUnits, id, width, bkColor) \
        BR_DesktopPane(helpId, viewUnits, id, 0, 0, width, 10, kFixedLeft, kFitEnclosure, bkColor)
#define BR_LeftDesktopPalette(            viewUnits, id, width, bkColor) \
        BR_LeftDesktopPaletteHelp(     0, viewUnits, id, width, bkColor)

#define BR_FontUnitsDialogBoxHelp(helpId, szTitle, wfStyle, xPos, yPos, xSize, ySize)  \
        BR_RDialogBox(kFontUnits, -1, helpId, szTitle, wfStyle, {xSize, ySize, xPos, yPos}, 0, 0, 0),
#define BR_FontUnitsDialogBox(            szTitle, wfStyle, xPos, yPos, xSize, ySize)  \
        BR_FontUnitsDialogBoxHelp(     0, szTitle, wfStyle, xPos, yPos, xSize, ySize)

#define BR_FontUnitsDialogPane \
        BR_RView(kFontUnits, -1,      0, {0,0,0,0}, kFitEnclosure, kFitEnclosure, kRGBWindow, kArrowCursor, TRUE),
#define BR_FontUnitsDialogPaneHelp(helpId) \
        BR_RView(kFontUnits, -1, helpId, {0,0,0,0}, kFitEnclosure, kFitEnclosure, kRGBWindow, kArrowCursor, TRUE),

#define BR_StaticTextHelp(helpId, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
       BR_RStaticText(viewUnits, wId, helpId, {xSize, ySize, xPos, yPos}, szHorz, szVert, rgbColor, kArrowCursor, TRUE, {0, 0, xIntSize, yIntSize}, "",  -1), {}
#define BR_StaticText(            viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
        BR_StaticTextHelp(     0, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize)

#define BR_SelectTextHelp(helpId, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
       BR_RSelectText(viewUnits, wId, helpId, {xSize, ySize, xPos, yPos}, szHorz, szVert, rgbColor, kArrowCursor, TRUE, {0, 0, xIntSize, yIntSize}, "", -1), {}
#define BR_SelectText(            viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
        BR_SelectTextHelp(     0, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize)

#define BR_EditTextHelp(helpId, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
       BR_REditText(viewUnits, wId, helpId, {xSize, ySize, xPos, yPos}, szHorz, szVert, rgbColor, kIBeamCursor, TRUE, {0, 0, xIntSize, yIntSize}, "", -1), {}
#define BR_EditText(            viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize) \
        BR_EditTextHelp(     0, viewUnits, wId, xPos, yPos, xSize, ySize, szHorz, szVert, rgbColor, xIntSize, yIntSize)

#define BR_SortedListBoxHelp(helpId, wId, xPos, yPos, xSize, ySize) \
       BR_RSortedListBox(kEnclosureUnits, wId, helpId, {xSize, ySize, xPos, yPos}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE),
#define BR_SortedListBox(            wId, xPos, yPos, xSize, ySize) \
        BR_SortedListBoxHelp(     0, wId, xPos, yPos, xSize, ySize)

#define BR_MultiLineEditHelp(helpId, wId, xPos, yPos, xSize, ySize) \
       BR_RMultiLineEdit(kEnclosureUnits, wId, helpId, {xSize, ySize, xPos, yPos}, NULL, NULL, kRGBWindow, kIBeamCursor, TRUE), {}
#define BR_MultiLineEdit(            wId, xPos, yPos, xSize, ySize) \
        BR_MultiLineEditHelp(     0, wId, xPos, yPos, xSize, ySize)

#define BR_PopUpMenuHelp(helpId, xPos, yPos, fBitmapResourceId, fMenuResourceId) \
       BR_RPopUpMenu(kPixelUnits, -1, helpId, {0, 0, xPos, yPos}, NULL, NULL, kRGBWindow, kArrowCursor, TRUE, "", fBitmapResourceId, fMenuResourceId), {}
#define BR_PopUpMenu(            xPos, yPos, fBitmapResourceId, fMenuResourceId) \
        BR_PopUpMenuHelp(     0, xPos, yPos, fBitmapResourceId, fMenuResourceId)

//========================================================================================
// Adorners
//========================================================================================

#define BR_LineEx(id, priority, sharedAdorner, x1, y1, x2, y2, penWidth, penColor, penStyle) \
    BR_RLineAdorner(id, priority, kAutoDelete, sharedAdorner, penWidth, penColor, penStyle, {x1, y1}, {x2, y2}), {}
#define BR_Line(id, priority, x1, y1, x2, y2) \
	BR_LineEx(id, priority, kNotSharedAdorner, x1, y1, x2, y2, 1, kRGBBlack, kSolidPen)

#define BR_TextEx(id, priority, xPos, yPos, text, fontId, fontSize, fontStyle, rgbColor) \
        BR_RTextAdorner(id, priority, kAutoDelete, kNotSharedAdorner, {xPos, yPos, 0, 0}, text, fontId, fontSize, fontStyle, rgbColor, 0),{}
#define BR_Text(id, priority, xPos, yPos, text) \
		BR_TextEx(id, priority, xPos, yPos, text, kEnclosureFont, 0, 0, kRGBBlack)
#define BR_TextRect(id, priority, xPos, yPos, xSize, ySize, text) \
        BR_RTextAdorner(id, priority, kAutoDelete, kNotSharedAdorner, {xPos, yPos, xSize, ySize}, text, kEnclosureFont, 0, 0, kRGBBlack, BEDDT_CENTER | BEDDT_VCENTER),{}
#define BR_TextRectEx(id, priority, xPos, yPos, xSize, ySize, text, rgbColor, drawTextFlags) \
        BR_RTextAdorner(id, priority, kAutoDelete, kNotSharedAdorner, {xPos, yPos, xSize, ySize}, text, kEnclosureFont, 0, 0, rgbColor, drawTextFlags),{}

#define BR_Label(id, xPos, yPos, text) \
        BR_RLabel(id, kAdornBefore, kAutoDelete, kNotSharedAdorner, {xPos, yPos, 0, 0}, text, kEnclosureFont, 0, 0, kRGBBlack, 0),{}
#define BR_LabelRect(id, xPos, yPos, xSize, ySize, justification, text) \
        BR_RLabel(id, kAdornBefore, kAutoDelete, kNotSharedAdorner, {xPos, yPos, xSize, ySize}, text, kEnclosureFont, 0, 0, kRGBBlack, justification),{}
		
#define BR_RoundRectEx(id, priority, x1, y1, x2, y2, radius, penWidth, penColor, penStyle , fillColor) \
       BR_RRoundRectAdorner (id, priority, kAutoDelete, kNotSharedAdorner, penWidth, penColor, penStyle, fillColor, {x1, y1, x2, y2}, radius, radius), {}
#define BR_RoundRect(id, priority, x1, y1, x2, y2, radius)	\
        BR_RoundRectEx(id, priority, x1, y1, x2, y2, radius, 1, kRGBBlack, kSolidPen, kRGBTransparent)

#define BR_RectangleEx(id, priority, x1, y1, x2, y2, penWidth, penColor, penStyle, fillColor) \
       BR_RRectangleAdorner (id, priority, kAutoDelete, kNotSharedAdorner, penWidth, penColor, penStyle , fillColor, {x1, y1, x2, y2}), {}
#define BR_Rectangle(id, priority, x1, y1, x2, y2)		\
        BR_RectangleEx(id, priority, x1, y1, x2, y2, 1, kRGBBlack, kSolidPen, kRGBTransparent)

#define BR_EllipseEx(id, priority, x1, y1, x2, y2, penWidth, penColor, penStyle, fillColor)  \
       BR_REllipseAdorner (id, priority, kAutoDelete, kNotSharedAdorner, penWidth, penColor, penStyle, fillColor, {x1, y1, x2, y2}), {}
#define BR_Ellipse(id, x1, priority, y1, x2, y2)	\
        BR_EllipseEx(id, priority, x1, y1, x2, y2, 1, kRGBBlack, kSolidPen, kRGBTransparent)

#define BR_Bitmap(id, priority, xPos, yPos, bitmapResId)  \
	BR_RBitmapAdorner(id, priority, kAutoDelete, kNotSharedAdorner, {xPos, yPos}, bitmapResId),{}

#define BR_Icon(id, priority, xPos, yPos, iconResId)  	\
       BR_RIconAdorner (id, priority, kAutoDelete, kNotSharedAdorner, {xPos, yPos}, iconResId), {}

#define BR_ShadowFramed(priority)		\
      	BR_RShadowFramedAdorner(kShadowFramedAdornerId, priority, kAutoDelete, kSharedAdorner), {}

#define BR_EraseAdorner()		\
      	BR_REraseAdorner(kEraseAdornerId, kAdornFirst, kAutoDelete, kSharedAdorner), {}

#define BR_DrawAdorner()		\
      	BR_RDrawAdorner(kDrawAdornerId, kAdornDraw, kAutoDelete, kSharedAdorner), {}

//========================================================================================
// Bedrock menu resource definitions
//========================================================================================

//----------------------------------------------------------------------------------------
// TYPE BR_RMenuBar
//----------------------------------------------------------------------------------------

type BR_RMenuBar : BR_RBaseRes(ids = "BR_CMenuBar")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RPullDownMenu
//----------------------------------------------------------------------------------------

type BR_RPullDownMenu : BR_RBaseRes(ids = "BR_CPullDownMenu")
{
    cstring[64];            // Menu name
    unsigned integer;       // fCommandId
    unsigned integer;       // fHelpCmd
};

//----------------------------------------------------------------------------------------
// TYPE BR_RWindowMenu
//----------------------------------------------------------------------------------------

type BR_RWindowMenu : BR_RPullDownMenu(ids = "BR_CWindowMenu")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RHelpMenu
//----------------------------------------------------------------------------------------

type BR_RHelpMenu : BR_RPullDownMenu(ids = "BR_CHelpMenu")
{
};

//----------------------------------------------------------------------------------------
// TYPE BR_RNewOwnerDrawMenu
//----------------------------------------------------------------------------------------

type BR_RNewOwnerDrawMenu : BR_RPullDownMenu(ids = "_abstract_")
{
    unsigned integer;       		// Number of rows
    unsigned integer;       		// Number of columns
};

//----------------------------------------------------------------------------------------
// TYPE BR_ROwnerDrawMenu
//----------------------------------------------------------------------------------------

type BR_ROwnerDrawMenu : BR_RPullDownMenu(ids = "_abstract_")
{
    unsigned integer;       // Number of rows
    unsigned integer;       // Number of columns
    unsigned integer;       // Starting menu fCommandId
};

//----------------------------------------------------------------------------------------
// TYPE BR_RBitmapMenu
//----------------------------------------------------------------------------------------

type BR_RBitmapMenu : BR_ROwnerDrawMenu(ids = "BR_CBitmapMenu")
{
    unsigned integer;       // Bitmap resource Id
    unsigned integer;       // Bitmap usage fFlags
};

//----------------------------------------------------------------------------------------
// TYPE BR_RMixedMenu
//----------------------------------------------------------------------------------------

type BR_RMixedMenu : BR_RBitmapMenu (ids = "BR_CMixedMenu")
{
    unsigned integer;       // ResId of a MultiString with menu items strings
    unsigned integer;       // Text justification fFlags
};

//----------------------------------------------------------------------------------------
// TYPE BR_RMenuItem
//----------------------------------------------------------------------------------------

type BR_RMenuItem : BR_RBaseRes(ids = "BR_CMenuItem")
{
    unsigned integer;       // fCommandId
    cstring[64];            // Menu item name
    Boolean;                // fSeparator
};


//========================================================================================
// Convenience macros
//========================================================================================

#define BR_MenuBar                         BR_RMenuBar(),
#define BR_MenuItem(fCommandId, text)         BR_RMenuItem(fCommandId, text, FALSE), {}
#define BR_MenuItemSeparator               BR_RMenuItem(0, "", TRUE), {}

#define BR_TextMenuAtCmd(szName, cmdAt)    BR_RPullDownMenu(szName, cmdAt, FALSE),
#define BR_TextMenuHelp(szName, cmdHelp)   BR_RPullDownMenu(szName, cmdHelp, TRUE),
#define BR_TextMenu(szName)                BR_RPullDownMenu(szName, 0, TRUE),

#define BR_BitmapMenuAtCmd(szName, cmdAt, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId \
            , wFlags)   \
        BR_RBitmapMenu(szName, cmdAt, FALSE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId     \
            , wFlags),
#define BR_BitmapMenuHelp(szName, cmdHelp, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId \
            , wFlags)   \
        BR_RBitmapMenu(szName, cmdHelp, TRUE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId     \
            , wFlags),
#define BR_BitmapMenu(szName, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId \
            , wFlags)   \
        BR_RBitmapMenu(szName, 0, TRUE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId     \
            , wFlags),

#define BR_MixedMenuAtCmd(szName, cmdAt, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId  \
            , wfBmpFlags, strResId, textFlags)   \
        BR_RMixedMenu(szName, cmdAt, FALSE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId      \
            , wfBmpFlags, strResId, textFlags),
#define BR_MixedMenuHelp(szName, cmdHelp, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId  \
            , wfBmpFlags, strResId, textFlags)   \
        BR_RMixedMenu(szName, cmdHelp, TRUE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId      \
            , wfBmpFlags, strResId, textFlags),
#define BR_MixedMenu(szName, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId  \
            , wfBmpFlags, strResId, textFlags)   \
        BR_RMixedMenu(szName, 0, TRUE, fNumberOfRows, fNumberOfColumns, cmdStart, bmpResId      \
            , wfBmpFlags, strResId, textFlags),

#ifdef BR_BUILD_MAC
#define BR_AppleMenu() \
     BR_RPullDownMenu("\024",0,TRUE),

#define BR_WindowMenu() \
     BR_RWindowMenu("Window",0,TRUE),

#define BR_HelpMenu() \
     BR_RHelpMenu("Help",0,TRUE),
#endif
#ifdef BR_BUILD_WIN
#define BR_WindowMenu() \
     BR_RWindowMenu("~Window",0,TRUE),

#define BR_HelpMenu() \
     BR_RHelpMenu("~Help",0,TRUE),

#endif

#endif
