#if !defined(BRTXSTRE_H) && !defined(__BEDRC__)
#define BRTXSTRE_H
//========================================================================================
//
//     File:		BRTxStre.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/22/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRBLSTRM_H
#include "BRBlStrm.h"
#endif

#ifndef   BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif


//========================================================================================
//	BR_CTextStream
//
// A text stream is an object which Contains a large block of text but also keeps track of
// it on a line-by-line basis. This class is used mainly with text editing classes such as
// the BR_CEditText class.
//========================================================================================

class BR_CTextStream : public BR_CBlockedStream
{
public:
	typedef long int StreamOffset;
	typedef BC_Extended_Index TextStreamLineNumber;
	typedef long int TextStreamColumnNumber;
	typedef long int LineLength;

	enum TextStreamDefaultBlockSizeConstant
	{
		kTextStreamDefaultBlockSize = 512
	};
	
	BR_CTextStream(BR_CBlock::BlockSize blockSize = kTextStreamDefaultBlockSize);
	BR_CTextStream(StreamSize maxBytes);
	virtual~ BR_CTextStream();

	// Insertion routines
	virtual BR_Boolean InsertCharacter(TextStreamLineNumber atLine,
								   TextStreamColumnNumber atColumn,
								   BR_Char characterToInsert);
	virtual BR_Boolean InsertString(TextStreamLineNumber atLine,
									TextStreamColumnNumber atColumn,
									const BR_TString<BR_Char>& stringToInsert);
	virtual BR_Boolean InsertLine(TextStreamLineNumber atLine,
								  const BR_TString<BR_Char>& lineToInsert);
	virtual BR_Boolean InsertTextStream(BR_CTextStream& streamToInsert,
										TextStreamLineNumber atLine,
										TextStreamColumnNumber atColumn);

	BR_Boolean AppendString(TextStreamLineNumber afterLine,
							const BR_TString<BR_Char>& stringToAppend);
	BR_Boolean AppendString(const BR_TString<BR_Char>& stringToAppend);
	BR_Boolean AppendLine(const BR_TString<BR_Char>& lineToAppend);


	// Deletion routines.
	BR_Boolean DeleteCharacter(TextStreamLineNumber atLine,
						   TextStreamColumnNumber atColumn,
						   LineLength numberOfCharacters);
	virtual BR_Boolean DeleteCharacter(TextStreamLineNumber atLine,
								   TextStreamColumnNumber atColumn,
								   LineLength numberOfCharacters,
								   BR_Boolean& deletedAnEOL);
	virtual BR_Boolean DeleteLine(TextStreamLineNumber lineToDelete);
	virtual BR_Boolean DeleteLine(TextStreamLineNumber startingLine,
								  TextStreamLineNumber endingLine);
	virtual BR_Boolean DeleteEOL(TextStreamLineNumber lineToDelete);


	// Retrieval routines.
	virtual BR_Boolean GetLine(BR_TString<BR_Char>& textBuffer);
	virtual BR_Boolean GetLine(BR_TString<BR_Char>& textBuffer,
							   TextStreamLineNumber lineNumber);
	virtual const BR_TString<BR_Char>* GetLine(TextStreamLineNumber lineNumber);
	virtual BR_Boolean GetNextLine(BR_TString<BR_Char>& textBuffer);


	virtual BR_Boolean SetCurrPosition(TextStreamLineNumber lineNumber,
									   TextStreamColumnNumber columnNumber);
	virtual LineLength GetLineLength(TextStreamLineNumber lineNumber) const;
	virtual BR_Boolean DoReturn(TextStreamLineNumber atLine,
								TextStreamColumnNumber atColumn);
	virtual BR_Boolean AppendLineIndex(const TextStreamLineNumber afterLine);
	virtual BR_Boolean InsertLineIndex(const LineLength numberOfBytes,
									   const TextStreamLineNumber atLine);

	TextStreamLineNumber GetNumLines() const;
	TextStreamLineNumber GetCurrLineNo() const;
	void SetCurrLineNo(TextStreamLineNumber newCurrentLine);

	virtual BR_Boolean Load(BR_CStream& inputStream);
	virtual BR_Boolean Save(BR_CStream& outputStream);
	virtual void Clear();

	virtual void SetDirty(BR_Boolean IsDirty);
	BR_Boolean IsDirty() const;

protected:
	virtual StreamOffset GetLineOffset(TextStreamLineNumber lineNumber) const;
	virtual void SetLineLength(TextStreamLineNumber lineNumber,
							   LineLength numberOfCharacters);

private:
	BC_TUnboundedCollection<LineLength, BC_CUnmanaged> fLineLengthList;
	TextStreamLineNumber fCurrLineNumber;
	BR_CDynamicCharString fCurrentLine;
	BR_Boolean fIsDirty;

	void InitTextStream();

	BR_SETCLASSNAME(BR_CTextStream);
};




//----------------------------------------------------------------------------------------
//	BR_CTextStream::GetNumLines
//----------------------------------------------------------------------------------------
inline BR_CTextStream::TextStreamLineNumber BR_CTextStream::GetNumLines() const
{
	return fLineLengthList.Length();
}


//----------------------------------------------------------------------------------------
//	BR_CTextStream::GetCurrLineNo
//----------------------------------------------------------------------------------------
inline BR_CTextStream::TextStreamLineNumber BR_CTextStream::GetCurrLineNo() const
{
	return (fCurrLineNumber);
}


//----------------------------------------------------------------------------------------
//	BR_CTextStream::SetCurrLineNo
//----------------------------------------------------------------------------------------
inline void BR_CTextStream::SetCurrLineNo(TextStreamLineNumber newCurrentLine)
{
	fCurrLineNumber = newCurrentLine;
}

//----------------------------------------------------------------------------------------
//	BR_CTextStream::IsDirty
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CTextStream::IsDirty() const
{
	return (fIsDirty);
}

#endif
