#if !defined(BRTIMQUE_H) && !defined(__BEDRC__)
#define BRTIMQUE_H

#ifdef BR_BUILD_MAC
//========================================================================================
//
//     File:		BRTimQue.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	4/10/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRCHORE_H
#include "BRChore.h"
#endif

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCOCOLU_H
#include "BCOColU.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CTimerElement;


//========================================================================================
// Type definitions
//========================================================================================
typedef long MacTicks;

// Use the values from OrderedCollection
typedef unsigned short 		QueueSize;
typedef unsigned short		QueueEntryIndex;


//========================================================================================
// Constants
//========================================================================================
enum TimerQueueConstants
{
	kMacTicksPerSecond = 60,
	kMillisecondsPerMacTick = 1000
};


//========================================================================================
// Global procedure declarations
//========================================================================================

//----------------------------------------------------------------------------------------
//
//	MacTicksToMilliseconds
//
//	Time conversion utility.  Convert from 1/60ths of a fSecond to milliseconds.
//	<Preconditions>
//	<Postconditions>
//
//----------------------------------------------------------------------------------------
inline BR_Milliseconds MacTicksToMilliseconds(MacTicks ticks)
{
	// Round DOWN to nearest millisecond
	return (ticks * kMillisecondsPerMacTick) / kMacTicksPerSecond;
}


//----------------------------------------------------------------------------------------
//
//	MillisecondsToTicks
//
//	Time conversion utility.  Convert from milliseconds to 1/60ths of a fSecond.
//	<Preconditions>
//	<Postconditions>
//
//----------------------------------------------------------------------------------------
inline MacTicks MillisecondsToTicks(BR_Milliseconds milliseconds)
{
	// Round UP to nearest tick
	return ((milliseconds * kMacTicksPerSecond + kMillisecondsPerMacTick - 1) 
														/ kMillisecondsPerMacTick);
}



//========================================================================================
//	BR_CTimerQueue
//
//	Stores a list of timer events.
//	<Invariants>
//========================================================================================
class BR_CTimerQueue
{
public:
	BR_CTimerQueue();
	// Add destructor

	BR_Boolean Add(BR_CChore::ChoreId choreID,
				   BR_Milliseconds interval);

	void RemoveMin();
	void Remove(BR_CChore::ChoreId choreID);
	QueueEntryIndex Next();

public:											// Implementation
	MacTicks TimeLeft();

private:
	BC_TUnboundedOrderedCollection<BR_CTimerElement *, BC_CUnmanaged> fQueueHeap;

};

#endif

#endif
