#if !defined(BRTASKGL_H) && !defined(__BEDRC__)
#define BRTASKGL_H
//========================================================================================
//
//     File:			BRTaskGl.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	8/1/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEF_H
#include "BRStdDef.h"
#endif

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef   BREXCEPT_H
#include "BRExcept.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

struct BR_SBCLTaskGlobals;


//========================================================================================
//	Global procedure definitions
//========================================================================================

BR_SBCLTaskGlobals* BCLGetTaskGlobals(BR_Boolean fGenErrorMessage = TRUE);
void BCLSetTaskGlobals(BR_SBCLTaskGlobals* pTaskGlobals);


//========================================================================================
// STRUCT BR_SBCLTaskGlobals
// 
// A structure that contains bcl per-task BRResGlo. Allocated by the BELPreStaticInitalize
// function and can be accessed with BCLGetTaskGlobals()
//
// Stupid Windows tricks:
//
// We need to associate a separate set of exception variables and a delete stack with each
// bcl task. We have an array with task handles and data pointers, and cache data of the
// current task in a global pointer. Every time there is a possibility of a task switch
// (after GetMessage), we re- initialize the cache pointer.
//========================================================================================

struct BR_SBCLTaskGlobals
{
	static void NotifyTaskSwitch();				// Should be called whenever a new Windows
                                                // task could be entered by calling
                                                // GetMessage() or some other means. Looks
                                                // up the current task's BRResGlo in the
                                                // list and caches it until called fNext
                                                // time.
												
	static void RemoveTask();					// Removes the current task from the table
                                                // and throws away its BRResGlo structure.
                                                // Should be called after static dtors
                                                // have finished their dirty business.
												
	class BR_CApplication  *m_pApplication;		// The application that's running the task
	LPSTR m_pzCommandLine;						// The command line

	// BRResGlo for exception handling system
	struct
	{
		size_t c_nCurrentByteSize;
		void* c_pDeleteArray;
		void* c_pNextOpening;
		void* c_pOnePastLastPosition;
	} fDeleteStack;

	struct
	{
		size_t c_nExceptionBufferSize;
		void* c_pExceptionBuffer;
		void* c_pCaughtException;
		void* c_pThrownException;
		void* c_pLastContext;
		BR_Boolean c_fAddObjectToDeleteStack;
		BR_Boolean c_fThrowing;
		void* c_pfCurrentTerminate;
		void* c_pfCurrentUnexpected;
#ifdef BR_DEBUG
		char* c_pzTriggerName;					// Name of Exception to trigger.
		int c_nTriggerPoint;					// Number of trigger point.
		int c_nTriggerCounter;					// Trigger point counter.
		char* c_pzLogFileName;					// fRunTime log filename
		int c_nLogEnabled;						// Logging enabling counter
		void* c_pLogFile;						// Log file or NULL
		void* c_pTraceBuffer;					// Used to trace function calls
#endif
	} fRunTime;

	BR_PlatformHandle fCurrentInstanceHandle;							// Task instance handles
	BR_PlatformHandle fPreviousInstanceHandle;

	enum
	{
		kMaxTasks = 32							// Max number of concurrently running bcl tasks
	};

#ifdef BR_DEBUG
	void* fDebugHeadOfMemoryBlockList;							// Memory debugging valid fMemory block list head
	BR_Boolean fDebugIsMemoryDebugEnabled;				// Used to disable debugging for exception
                                                // system startup and termination
	BR_Boolean fDebugAutoVerify;						// Call BR_CMemDebug::VerifyHeap in LinkIn
                                                // and UnLink
	DWORD fDebugBlockCount;							// The number of fMemory blocks this task owns
#endif

	// This is followed by the exception stack itself
};

#endif
