#if !defined(BRSYMFIL_H) && !defined(__BEDRC__)
#define BRSYMFIL_H
//========================================================================================
//
//     File:		BRSymFil.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	8/1/92
//
//     COPYRIGHT 1992-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSTDDEFS_H
#include "BRStdDef.h"
#endif

#ifdef BR_DEBUG
#ifdef BR_BUILD_WIN

#if !defined(__INC_WINDOWS)
#include <windows.h>
#endif

//========================================================================================
// BR_CSymFile:
//
// Interface to Windows format .SYM files.  They are generated from link .MAP
// files by Microsoft MAPSYM tool and contain a list of publics in a module sorted
// by segment and Offset.  We use .SYM files to produce better BR_DEBUG printouts.
//========================================================================================

class BR_CSymFile
{
public:
	BR_CSymFile(const char* pzFileName);
	/* Tries to load a .SYM file defined by pzFileName.  If the load fails, no
	  fError is generated as SYM files are optional. */

	~BR_CSymFile(void);
	/* Frees fMemory allocated for the symbol data storage. */

	BR_Boolean FindSymbol(unsigned short wSeg,
						  unsigned short fOffset,
						  unsigned short cbMaxLen,
						  char* pzName);
	/* Attempts to locate a symbol in the file.  wSeg is the ordinal segment
	  number in a Windows executable file and wOfs is the Offset within that
	  segment.  If succesfull, copies the name to pzName, cbMaxLen is the buffer
	  size. */

private:
	void* fSymData;
};




//========================================================================================
// BR_CDebugModuleList:
//
// A class for obtaining symbolic info on Windows modules.  Useful for stack
// walk and BR_DEBUG messages.
//========================================================================================

class BR_CDebugModuleList
{
public:
	BR_CDebugModuleList(void);
	~BR_CDebugModuleList(void);

	static BR_Boolean FindSymbol(HANDLE fModule,
						   unsigned short wSeg,
						   unsigned short fOffset,
						   unsigned short cbMaxLen,
						   char* pzName);
	/* Attempts to locate a symbol in a Windows module.  See comment for
	  BR_BR_CSymFile::FindSymbol above.  fModule is the module handle as returned
	  by TOOLHELP.DLL: do not pass instance handles! */
	  
	static BR_Boolean GetModuleName(HANDLE fModule,
						 char* pzName);
	/* Returns a short 8-char name of module identified by handle fModule. */

	enum
	{
		kMaxModules = 64,
		kModuleNotFound = 128
	};

private:
	struct sOneModule
	{
		HANDLE fModule;
		BR_CSymFile* fSymFile;
		char fModuleName[10];
	};
	
	static sOneModule kModules[];
	static unsigned short kNumberOfModules;
	static unsigned short kRefCount;
	
	static unsigned short FindModule(HANDLE fModule);
	/* Searches the list for the module identified by fModule.  If the module is not
	  present yet, creates a new fEntryArray creates a BR_CSymFile for it. Returns module index
	  on success, kModuleNotFound on failure */
	
	static unsigned short AddModule(HANDLE fModule);
	/* Called by FindModule When the module fModule is not present in the list. */
};


#endif // BR_BUILD_WIN
#endif // BR_DEBUG

#endif // BRSYMFIL_H