#if !defined(BRSLRECT_H) && !defined(__BEDRC__)
#define BRSLRECT_H
//========================================================================================
//
//     File:		BRSlRect.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/9/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRMOUSEA_H
#include "BRMouseA.h"  
#endif

#ifndef BRPEN_H
#include "BRPen.h"    
#endif


//========================================================================================
// Forward class declarations
//========================================================================================
class BR_CPoint;
class BR_CRectangle;
class BR_CView;

//========================================================================================
//	BR_CSelectionRect
//
//		This class is used to Draw and track a selection rectangle starting at the initial
//	  	DoClick point and going until the EndTracking routine is called.
//========================================================================================
class BR_CSelectionRect : public BR_CMouseAction
{
public:
	BR_CSelectionRect(BR_CView* paneToTrackIn,
					  BR_Boolean notifyDocument = TRUE,
					  BR_Boolean deleteOnCompletion = TRUE);
	virtual ~BR_CSelectionRect();

	// Inherited methods
	virtual void KeepTracking(const BR_CPoint& currentPoint);
	virtual void EndTracking(const BR_CPoint& currentPoint);
	virtual BR_Boolean Undo();
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& updateArea);

	// New methods
	virtual void GetSelectionRect(BR_CRectangle& selectionRect) const;
	virtual BR_Boolean IsEmpty();

private:
	BR_CPen fSelectionPen;							// The pen used to Draw the pane

	BR_SETCLASSNAME(BR_CSelectionRect);
};



#endif
