#if !defined(BRSCROLB_H) && !defined(__BEDRC__)
#define BRSCROLB_H
//========================================================================================
//
//     File:			BRScrolB.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	10/1/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRSCROLB_K
#include "BRScrolB.k"
#endif

#ifndef   BRCONTRO_H
#include "BRContro.h"
#endif


//========================================================================================
// CLASS BR_CScrollBar
//========================================================================================

class BR_CScrollBar : public BR_CControl
{
public:
	typedef long int StepPosition;
	typedef long int StepDistance;
	typedef short int Orientation;

	typedef unsigned short int ScrollDirection;
	enum ScrollDirectionConstants
	{
		kScrollingTowardsBeginning, kScrollingTowardsEnd
	};

	typedef unsigned short int ScrollBarCommand;
	enum ScrollBarCommandConstants
	{
		kScrollBarCommandTop = SB_TOP, 
		kScrollBarCommandBottom = SB_BOTTOM, 
		kScrollBarCommandLineUp = SB_LINEUP, 
		kScrollBarCommandLineDown = SB_LINEDOWN, 
		kScrollBarCommandPageUp = SB_PAGEUP, 
		kScrollBarCommandPageDown = SB_PAGEDOWN, 
		kScrollBarCommandThumbPosition = SB_THUMBPOSITION, 
		kScrollBarCommandThumbTrackScrollBarCommand = SB_THUMBTRACK, 
		kScrollBarCommandEndScroll = SB_ENDSCROLL
	};

	BR_CScrollBar(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  ViewId viewId,
				  ViewUnits viewUnits,
				  BR_CHelp::HelpTopic helpTopic,
				  Orientation orientation,
				  BR_Distance length,
				  BR_Distance thickness,
				  BR_Coordinate x,
				  BR_Coordinate y,
				  ViewSizing horizontalSizing,
				  ViewSizing verticalSizing,
				  BR_Boolean create = TRUE);
	BR_CScrollBar(BR_CView* enclosure,
				  BR_CBureaucrat* supervisor,
				  const BR_CModule& module,
				  BR_SResource& viewResource);
	virtual~ BR_CScrollBar();
	Orientation GetOrientation() const;
	virtual StepPosition GetThumbPos() const;
	virtual void SetThumbPos(StepPosition newThumbPosition);
	virtual void GetRange(StepPosition& minimum,
						  StepPosition& maximum) const;
	virtual void SetRange(StepPosition minimum,
						  StepPosition maximum);
	virtual void DoThumbChange(ScrollBarCommand scrollBarCommand,
							   StepPosition newStepPosition);
	virtual void DoThumbDragged(StepDistance stepsDragged);
	void ScrollLineUp();
	void ScrollLineDown();
	void ScrollPageUp();
	void ScrollPageDown();
	void ScrollToTop();
	void ScrollToBottom();
	virtual StepDistance GetPage(ScrollDirection scrollDirection) const = 0;
	virtual StepDistance GetOverlap(ScrollDirection scrollDirection) const = 0;

private:
	Orientation fOrientation;

	StepDistance DoLineUp(StepPosition newStepPosition,
						  StepPosition minimumStepPosition);
	StepDistance DoLineDown(StepPosition newPosition,
							StepPosition maximumStepPosition);
	StepDistance DoPageUp(StepPosition newStepPosition,
						  StepPosition minimumStepPosition);
	StepDistance DoPageDown(StepPosition newStepPosition,
							StepPosition maximumStepPosition);
	void InitScrollBar(Orientation orientation,
					   BR_Distance length,
					   BR_Distance thickness,
					   BR_Boolean create);


#ifdef BR_BUILD_MAC
public:
	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void BedMacWindowActivated(BR_Boolean activate);
	StepPosition GetOldThumbPos() const;

protected:
	virtual void DoCtlIndicatorDragged(long delta);
	virtual void DoCtlAction(short partCode);

private:
	StepPosition fMacOldThumbPos;
#endif


#ifdef BR_BUILD_WIN
public:
	virtual void Show(BR_Boolean show = TRUE);
	virtual void Hide();
	long DoDefaultProc(WORD wMessage,
					   WORD wParam,
					   long lParam);

private:
	BR_Boolean fWinControlCreated;
	WORD BedWinGetScrollMsg() const;
	short BedWinGetType() const;
#endif

	BR_SETCLASSNAME(BR_CScrollBar);
};


//========================================================================================
// CLASS BR_CScrollBarControl
//========================================================================================

class BR_CScrollBarControl : public BR_CScrollBar
{
public:
	BR_CScrollBarControl(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 ViewId viewId,
						 ViewUnits viewUnits,
						 BR_CHelp::HelpTopic helpTopic,
						 Orientation orientation,
						 BR_Distance length,
						 BR_Distance thickness,
						 BR_Coordinate x,
						 BR_Coordinate y,
						 ViewSizing horizontalSizing,
						 ViewSizing verticalSizing);
	BR_CScrollBarControl(BR_CView* enclosure,
						 BR_CBureaucrat* supervisor,
						 const BR_CModule& module,
						 BR_SResource& viewResource);
	virtual ~BR_CScrollBarControl();
	virtual StepDistance GetOverlap(ScrollDirection scrollDirection) const;
	virtual StepDistance GetPage(ScrollDirection scrollDirection) const;
	void SetOverlap(StepDistance overlap);
	void SetPage(StepDistance page);

private:
	StepDistance fPageSteps;	// The amt to scroll when PgDn or PgUp is pressed
	StepDistance fOverlapSteps;	// The current overlap amount (the portion of the window
                                // that will still be visible after a page up or page down
                                // operation)

	BR_SETCLASSNAME(BR_CScrollBarControl);
};


//========================================================================================
//	STRUCT BR_SScrollBarRes
//========================================================================================

struct BR_SScrollBarRes : BR_SControlResource
{
    BR_CScrollBar::Orientation fOrientation;
	BR_Distance fLength;
	BR_Distance fThickness;
};


//----------------------------------------------------------------------------------------
// BR_CScrollBar::GetOrientation
//----------------------------------------------------------------------------------------

inline BR_CScrollBar::Orientation BR_CScrollBar::GetOrientation() const
{
	return fOrientation;
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollLineUp
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollLineUp()
{
	DoThumbChange(kScrollBarCommandLineUp, 0);
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollLineDown
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollLineDown()
{
	DoThumbChange(kScrollBarCommandLineDown, 0);
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollPageUp
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollPageUp()
{
	DoThumbChange(kScrollBarCommandPageUp, 0);
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollPageDown
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollPageDown()
{
	DoThumbChange(kScrollBarCommandPageDown, 0);
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollToTop
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollToTop()
{
	DoThumbChange(kScrollBarCommandTop, 0);
}

//----------------------------------------------------------------------------------------
// BR_CScrollBar::ScrollToBottom
//----------------------------------------------------------------------------------------

inline void BR_CScrollBar::ScrollToBottom()
{
	DoThumbChange(kScrollBarCommandBottom, 0);
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CScrollBar::GetOldThumbPos
//----------------------------------------------------------------------------------------

inline BR_CScrollBar::StepPosition BR_CScrollBar::GetOldThumbPos() const
{
	return fMacOldThumbPos;
}
#endif

//----------------------------------------------------------------------------------------
// BR_CScrollBarControl::SetOverlap
//----------------------------------------------------------------------------------------

inline void BR_CScrollBarControl::SetOverlap(StepDistance overlap)
{
	fOverlapSteps = overlap;
}

//----------------------------------------------------------------------------------------
// BR_CScrollBarControl::SetPage
//----------------------------------------------------------------------------------------

inline void BR_CScrollBarControl::SetPage(StepDistance page)
{
	fPageSteps = page;
}

#endif
