#if !defined(BRSCRCNV_H) && !defined(__BEDRC__)
#define BRSCRCNV_H
//========================================================================================
//
//     File:			BRScrCnv.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	12/18/91
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

//========================================================================================
//	BR_CScreenCanvas
//
//	A canvas that can be used to draw on the whole screen
//========================================================================================

class BR_CScreenCanvas : public BR_CCanvas
{
public:
	BR_CScreenCanvas();
	virtual~ BR_CScreenCanvas();
	virtual void GetDrawArea(BR_CRectangle& area) const;

//----------------------------------------------------------------------------------------
// Macintosh
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	virtual GrafPtr BedMacGetGrafPort() const;
	virtual void BedMacViewToCanvasOwner(BR_CPoint& aPoint) const;
#endif

//----------------------------------------------------------------------------------------
// Windows
//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
protected:
	virtual BR_Boolean BeginDrawing(BR_CView& pane,
									const BR_Boolean doPreDraw = TRUE);
	// Inherited methods
	virtual HDC BedWinCreateDC(BR_CView& pane);
	virtual void BedWinDeleteDC(BR_CView& pane,
						  HDC hDC);
#endif

};



#endif


