#if !defined(BRPULLDM_H) && !defined(__BEDRC__)
#define BRPULLDM_H
//========================================================================================
//
//     File:			BRPullDM.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	September 14, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BCSTOREU_H
#include "BCStoreU.h"
#endif

#ifndef BCCOLLU_H
#include "BCCollU.h"
#endif

#ifndef BRMENU_H
#include "BRMenu.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BRMNUBAR_H
#include "BRMnuBar.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CApplication;
class BR_CWindow;


//========================================================================================
// Resource structure
//========================================================================================

//struct BR_SPullDownMenuResource : BR_SMenuResource (ZTC bug)
struct BR_SPullDownMenuResource : BR_SResource
{
    char    fText[64];
	
    BR_CBureaucrat::CommandId commandId;
		// Pulldown menu is added to parent menu at this fCommandId. This is used mostly for
        // making cacading menus with OD-menus at the non-terminal levels
		
    BR_Boolean fHelpCmd;
		// If TRUE, fCommandId specifies help Id of this whole menu and not used to Add it to
        // its parent menu at a specific fCommandId
};


//========================================================================================
//	CLASS BR_CPullDownMenu
//========================================================================================

class BR_CPullDownMenu : public BR_CMenu
{
public:
	BR_CPullDownMenu(BR_CApplication& application,
					 BR_CMenu& parentMenu,
					 const BR_CModule& module,
					 BR_SResource& resource);
	BR_CPullDownMenu(const BR_TString<BR_Char>& title);
	BR_CPullDownMenu(const BR_CModule& module,
					 BR_ResourceId titleResourceId);
	virtual~ BR_CPullDownMenu();

	virtual void EnableAll(BR_Boolean includeSubmenus = FALSE);
	virtual void DimAll(BR_Boolean includeSubmeuns = FALSE);
	virtual unsigned short GetName(BR_TString<BR_Char>& buffer) const;
	void SetName(BR_TString<BR_Char>& newName);
	virtual BR_Boolean GetItemByCharacter(BR_StringCharacter character,
									  BR_CBureaucrat::CommandId& commandId) const;

	virtual void AddToMenuBar(BR_CMenuBar* menuBar,
							  ItemPosition beforePosition = (ItemPosition) -1);
	virtual void RemoveFromMenuBar(BR_CMenuBar* menuBar);

	void EnableSubMenus(unsigned short level = 0);

	void EnableAll(BR_PlatformMenuHandle menuHandle,
				   BR_Boolean includeSubmenus);

#ifdef BR_BUILD_MAC
public:
	MenuId GetMenuId() const;

	virtual BR_CPullDownMenu* BedMacFindMenuItem(BR_CBureaucrat::CommandId commandId,
												 ItemPosition& position);
	virtual void InsertCmd(BR_CBureaucrat::CommandId commandId,
						   ItemPosition position);
	virtual void AppendCmd(BR_CBureaucrat::CommandId commandId);
	virtual void RemoveCmd(ItemPosition position);

	virtual BR_CBureaucrat::CommandId GetItemCmd(ItemPosition position) const;
	virtual void InsertSeparator(ItemPosition position);
	virtual void InsertMenuCmd(BR_CBureaucrat::CommandId commandId,
							   const BR_TString<BR_Char>& string,
							   BR_CBureaucrat::CommandId cmdInsertBefore);
	virtual void AddMenu(BR_CPullDownMenu* menu);
	virtual void AddMenu(BR_CPullDownMenu* menu,
						 ItemPosition beforePosition);
	virtual void RemoveMenuItem(ItemPosition position);
	virtual BR_CPullDownMenu* GetSubMenu(ItemPosition position) const;
	virtual unsigned short GetMenuPos(const BR_CPullDownMenu& menu) const;

	BC_Index HowManyCommands() const;

private:
	BC_TUnboundedCollection<BR_CBureaucrat::CommandId, BC_CUnmanaged> fCommandList;
	static short gNextId;
	short fPopItem;
#endif

#ifdef BR_BUILD_WIN
public:
	BR_CPullDownMenu(BR_PlatformMenuHandle fMenuHandle);
	void SetCmdId(BR_CBureaucrat::CommandId cmdIdP);
	BR_CBureaucrat::CommandId GetCmdId() const;

private:
	BR_CDynamicCharString fName;
	BR_CBureaucrat::CommandId fCommandId;
#endif

	BR_SETCLASSNAME(BR_CPullDownMenu);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CPullDownMenu::GetMenuId
//----------------------------------------------------------------------------------------

inline BR_CMenu::MenuId BR_CPullDownMenu::GetMenuId() const
{
	return (MenuId)(*GetHandle())->menuID;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CPullDownMenu::SetCmdId
//----------------------------------------------------------------------------------------

inline void BR_CPullDownMenu::SetCmdId(BR_CBureaucrat::CommandId cmdIdP)
{
	fCommandId = cmdIdP;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CPullDownMenu::GetCmdId
//----------------------------------------------------------------------------------------

inline BR_CBureaucrat::CommandId BR_CPullDownMenu::GetCmdId() const
{
	return fCommandId;
}
#endif


//========================================================================================
// CLASS BR_CWindowMenu
//========================================================================================

class BR_CWindowMenu : public BR_CPullDownMenu
{
public:
	BR_CWindowMenu(BR_CApplication& application,
				   BR_CMenu& parentMenu,
				   const BR_CModule& module,
				   BR_SResource& resource);
	virtual~ BR_CWindowMenu();

#ifdef BR_BUILD_MAC
public:
	virtual BR_CBureaucrat::CommandId GetItemCmd(ItemPosition position) const;

	virtual void AddWindow(BR_CWindow* theWindow);
	virtual void DeleteWindow(BR_CWindow* theWindow);
	virtual void WindowRenamed(BR_CWindow* theWindow);

	virtual void CheckFrontWindow();

	BC_Index GetNumberOfMenuItems();
	BR_Boolean IsInWindowMenu(BR_CWindow* window);
	BR_CWindow* GetWindowAt(ItemPosition position) const;

private:
	unsigned short fFirstWindItem;
		// poisition of the first window item
	BC_TUnboundedCollection<BR_CWindow *, BC_CUnmanaged> fWindowList;
	BR_CWindow* fCheckedWindow;
		// current checked item
#endif

	BR_SETCLASSNAME(BR_CWindowMenu);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CWindowMenu::GetNumberOfMenuItems
//----------------------------------------------------------------------------------------

inline BC_Index BR_CWindowMenu::GetNumberOfMenuItems()
{
	return fWindowList.Length();
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CWindowMenu::IsInWindowMenu
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CWindowMenu::IsInWindowMenu(BR_CWindow* aWindow)
{
	return fWindowList.Location(aWindow) != -1;
}
#endif


//========================================================================================
// CLASS BR_CHelpMenu
//========================================================================================

class BR_CHelpMenu : public BR_CPullDownMenu
{
public:
	enum HelpLocation { kInMenuBar, kInBalloonMenu, kInAppleMenu };

	BR_CHelpMenu(BR_CApplication& application,
				 BR_CMenu& parentMenu,
				 const BR_CModule& module,
				 BR_SResource& menuResource);
	virtual~ BR_CHelpMenu();

	BR_Boolean InMenuBar() const;
	void AddToMenuBar(BR_CMenuBar* menuBar,
					  ItemPosition beforePosition = (ItemPosition) -1);
	void RemoveFromMenuBar(BR_CMenuBar* menuBar);

	ItemPosition GetFirstHelpItem() const;

private:
	HelpLocation fHelpLocation;					// Where is the Help menu
	short fFirstHelpItem;						// Position of the first User Help item in Balloon or Apple menu

#ifdef BR_BUILD_MAC		
public:
	virtual BR_CBureaucrat::CommandId GetItemCmd(ItemPosition position) const;

	BR_Boolean InAppleMenu() const;
	BR_Boolean InBalloonMenu() const;

	void SetHelpLocation();
	void AppendHelpMenu(BR_CMenuBar* menuBar);
#endif

	BR_SETCLASSNAME(BR_CHelpMenu);
};

//----------------------------------------------------------------------------------------
// BR_CHelpMenu::InMenuBar
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CHelpMenu::InMenuBar() const
{
	// Always TRUE under Windows
	
	return fHelpLocation == kInMenuBar;
}

//----------------------------------------------------------------------------------------
// BR_CHelpMenu::GetFirstHelpItem
//----------------------------------------------------------------------------------------

inline BR_CMenu::ItemPosition BR_CHelpMenu::GetFirstHelpItem() const
{
	return fFirstHelpItem;
}

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CHelpMenu::InAppleMenu
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CHelpMenu::InAppleMenu() const
{
	return fHelpLocation == kInAppleMenu;
}
#endif


#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CHelpMenu::InBalloonMenu
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CHelpMenu::InBalloonMenu() const
{
	return fHelpLocation == kInBalloonMenu;
}
#endif

#endif

