#if !defined(BRPOPMNU_H) && !defined(__BEDRC__)
#define BRPOPMNU_H
//========================================================================================
//
//     File:			BRPopMnu.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 1992
//
//     COPYRIGHT 1993-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRPOPMNU_K
#include "BRPopMnu.k"
#endif

#ifndef BRCONTRO_H
#include "BRContro.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CPullDownMenu;


#ifdef BR_BUILD_MAC
//========================================================================================
// STRUCT BR_SMacCustomPopupMenuButtonResource
//========================================================================================

struct BR_SMacCustomPopupMenuButtonResource : public BR_SControlResource
{
	short fLabelJustification;
	char fLabel[128];
};
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CMacCustomPopupMenuButton
//
//		This class provides a popup menu button that conforms to Macintosh User Interface
//		guidelines for system 7.0. (More or less, not all styles are supported yet)
//========================================================================================
							   
class BR_CMacCustomPopupMenuButton : public BR_CControl
{
public:
	typedef short int PopupLabelJustification;

	enum { kDefaultGapSize = 4 };

	BR_CMacCustomPopupMenuButton(BR_CView* enclosure,
								 BR_CBureaucrat* supervisor,
								 const BR_CModule& module,
								 BR_SResource& paneResource);
	BR_CMacCustomPopupMenuButton(BR_CView* enclusure,
								 BR_CBureaucrat* supervisor,
								 BR_Distance width,
								 BR_Distance height,
								 BR_Coordinate x,
								 BR_Coordinate y,
								 ViewSizing horizontalSizing,
								 ViewSizing verticalSizing,
								 ViewId viewId,
								 PopupLabelJustification labelJustification,
								 const BR_TString<BR_Char>& buttonLabel);

	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& area);
	virtual void DoClick(const BR_CPoint& point,
						 KeyModifiers keys);
	virtual BR_Boolean DoCommand(CommandId commandId,
								 BR_CObject* notifier,
								 BR_Boolean callSupervisor = TRUE);
	virtual void DoMouseUp(const BR_CPoint& point,
						   KeyModifiers keys);
	virtual BR_CPullDownMenu* GetMenu() const;
	virtual void GetLabel(BR_TString<BR_Char>& label) const;
	virtual void SetMenu(BR_CPullDownMenu* menu);
	virtual void SetLabel(const BR_TString<BR_Char>& label);

	~BR_CMacCustomPopupMenuButton();

protected:
	virtual void DrawArrowIcon(const BR_CRectangle& area);
	virtual void DrawSelection(const BR_CRectangle& area,
							   BR_Boolean selected);

private:
	void CalculateDrawAreas();
	void CalculateDrawAreasLabelLeft();
	void CalculateDrawAreasLabelCenter();
	void CalculateDrawAreasLabelRight();

	void DrawTextFromPopupSelection(const BR_CRectangle& area,
									const BR_TString<BR_Char>& text);

	PopupLabelJustification fLabelJustification;
	BR_CDynamicCharString fLabel;

	// Draw areas for all pieces of the popup. The following values could be calculated
	// each time the popup is drawn. For speed we calculate them once and save them
	// in the following fields.
	
	BR_CRectangle fBoxArea;
	BR_CRectangle fArrowArea;
	BR_CRectangle fLabelArea;
	BR_CRectangle fTextArea;

	// Set to TRUE When the Draw areas need to be recalculated. Currently they are only
	// calculated the first time the button is drawn. In the future the button should
	// resize itself When items are added and removed from the associated menu.
	
	BR_Boolean fCalculateDrawAreas;

	BR_CMenu::ItemPosition fLastIndex;
	BR_CPullDownMenu* fMenu;
};

#endif

#endif