#if !defined(BRPASSWF_H) && !defined(__BEDRC__)
#define BRPASSWF_H
//========================================================================================
//
//     File:			BRPasswF.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	August 16, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BREDITCO_H
#include "BREditCo.h"
#endif

#if defined(BR_BUILD_MAC) && !defined(__TEXTEDIT__)
#include <TextEdit.h>
#endif


//========================================================================================
// STRUCT BR_SPasswordFieldResource
//========================================================================================

struct BR_SPasswordFieldResource : BR_SEditControlResource
{
};


//========================================================================================
//	CLASS BR_CPasswordField
//========================================================================================

class BR_CPasswordField : public BR_CEditControl
{
public:
	BR_CPasswordField(BR_CView* 		enclosure,
					  BR_CBureaucrat* 	supervisor,
					  BR_Distance 		width, 
					  BR_Distance 		height,
					  BR_Coordinate 	x,
					  BR_Coordinate 	y,
					  ViewSizing 		horizontalSizing,
					  ViewSizing 		verticalSizing,
					  ViewId 			viewId,
					  ViewStyle 		style);

	BR_CPasswordField(BR_CView* 			enclosure,
					  BR_CBureaucrat* 		supervisor,
					  const BR_CModule& 	module,
					  BR_SResource& 		viewResource);

	virtual					~BR_CPasswordField();

	virtual void 				SetPasswordChar(unsigned short newChar);

#ifdef BR_BUILD_MAC
public:
	virtual void 				DoClick(const BR_CPoint& point,
						 				KeyModifiers keyFlags);
	virtual BR_Boolean 		DoKey(Key key,
							 			unsigned short repeatCount,
							 			BR_Boolean callSupervisor = TRUE);
	virtual void 				SetText(const BR_TString<BR_Char>& text, BR_Boolean redraw=TRUE);
	virtual unsigned long 	GetText(BR_TString<BR_Char>& text) const;
	virtual void 				SetSelectionRange(CharacterPosition startPosition,
								   				CharacterPosition endPosition);
	BR_Boolean 					ReplaceSelection(const BR_TString<BR_Char>& strBuffer);
	
private:
	BR_Boolean					InitPassWordField(ViewStyle style);
	void						FillWithPasswordChar(BR_CCharString255& string, short fillCharacter) const;

	unsigned short 	fChar;
	TEHandle 			fRealTE;
#endif

	BR_SETCLASSNAME(BR_CPasswordField);
};

#endif
