#if !defined(BROWNDMN_H) && !defined(__BEDRC__)
#define BROWNDMN_H
//========================================================================================
//
//     File:			BROwnDMn.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRPULLDM_H
#include "BRPullDM.h"
#endif

#ifndef BRMENUPN_H
#include "BRMenuPn.h"
#endif

#ifndef BRITEMHE_H
#include "BRItemHe.h"
#endif

#ifndef BRDEBUG_H
#include "BRDebug.h"
#endif


//========================================================================================
// Constant definitions
//========================================================================================

const unsigned short kDefaultNumberOfRows = kInvalidPosition - 1;
const unsigned short kDefaultNumberOfColumns = 1;

//========================================================================================
// STRUCT BR_SNewOwnerDrawMenuResource
//========================================================================================

struct BR_SNewOwnerDrawMenuResource
{
	unsigned short fNumberOfRows;
	unsigned short fNumberOfColumns;
};


//========================================================================================
// CLASS BR_SItemDimension
//========================================================================================

struct BR_SItemDimension
{
	union
	{
		BR_Coordinate fX;
		BR_Coordinate fY;
	};


	union
	{
		BR_Distance fWidth;
		BR_Distance fHeight;
	};


};

//========================================================================================
// CLASS BR_CNewOwnerDrawMenu
//========================================================================================

class BR_CNewOwnerDrawMenu : public BR_CPullDownMenu
{
public:
	//	BR_CNewOwnerDrawMenu();	Declared private
	BR_CNewOwnerDrawMenu(const BR_CNewOwnerDrawMenu& menu);
	BR_CNewOwnerDrawMenu(BR_CModule& module,
						 BR_CItemHelper* itemHelper,
						 BR_ResourceId nameResId,
						 unsigned short numberOfRows = kDefaultNumberOfRows,
						 unsigned short numberOfColumns = kDefaultNumberOfColumns);
	BR_CNewOwnerDrawMenu(BR_CApplication& application,
						 BR_CMenu& parentMenu,
						 BR_CModule& module,
						 BR_SResource& resource);
	BR_CNewOwnerDrawMenu& operator=(const BR_CNewOwnerDrawMenu& menu);
	virtual~ BR_CNewOwnerDrawMenu();

	virtual void AddMenu(BR_CPullDownMenu* menu,
						 ItemPosition beforePos);
	virtual void AppendItem(BR_CObject* item,
							BR_CBureaucrat::CommandId commandId);
	virtual void CheckMenuItem(ItemPosition position,
							   BR_Boolean check = TRUE);
	virtual void EnableMenuItem(ItemPosition position,
								BR_Boolean enable = TRUE);
	virtual BR_CBureaucrat::CommandId GetCommandId(ItemPosition position) const;
	virtual BR_Boolean GetItemByCharacter(BR_StringCharacter gCharacter,
									  BR_CBureaucrat::CommandId& commandId) const;
	virtual BR_CBureaucrat::CommandId GetItemCmd(ItemPosition position) const;// OBSOLETE
	virtual void GetCmdText(BR_CBureaucrat::CommandId id,
							BR_TString<BR_Char>& String,
							BR_Boolean byPosition) const;// OBSOLETE
	virtual ItemPosition GetPosition(BR_CBureaucrat::CommandId commandId) const;
	void GetItemRowColumn(ItemPosition position,
						  unsigned short& nRow,
						  unsigned short& nColumn) const;
	virtual void InsertItem(BR_CObject* item,
							BR_CBureaucrat::CommandId commandId,
							ItemPosition position);
	virtual BR_Boolean IsItemChecked(ItemPosition position);
	virtual BR_Boolean IsItemEnabled(ItemPosition position);

protected:
	virtual void AdoptItemHelper(BR_CItemHelper* itemHelper);
	virtual void DrawDim(BR_CBedMenuPane& pane,
						 ItemPosition position,
						 BR_Boolean dimmed);
	virtual void DrawItem(BR_CBedMenuPane& pane,
						  ItemPosition position);
	virtual void DrawMark(BR_CBedMenuPane& pane,
						  ItemPosition position,
						  BR_Boolean marked);
	virtual void DrawSelection(BR_CBedMenuPane& pane,
							   ItemPosition position,
							   BR_Boolean selected);
	void GetDimensions(const BR_CBedMenuPane& menuPane,
					   BR_CPoint& dimensions) const;
	void GetColumnDimension(const BR_CBedMenuPane& menuPane,
							unsigned short column,
							BR_Coordinate& x,
							BR_Distance& width) const;
	unsigned short GetColumns() const;
	BR_CItemHelper* GetItemHelper() const;
	void GetRowDimension(const BR_CBedMenuPane& menuPane,
						 unsigned short row,
						 BR_Coordinate& y,
						 BR_Distance& height) const;
	unsigned short GetRows() const;
	virtual void GetItemFrame(const BR_CBedMenuPane& MenuPane,
							  BR_CRectangle& Area,
							  ItemPosition position) const;
	virtual void GetItemSize(const BR_CBedMenuPane& MenuPane,
							 BR_CRectangle& Area,
							 ItemPosition position) const;
	void InitOwnerDraw();
	void Invalidate();

private:
	//	BR_CNewOwnerDrawMenu() { }

	virtual void AddMenu(BR_CPullDownMenu *menu);
	void CalculateDimensions(const BR_CBedMenuPane& menuPane);

	BR_CItemHelper* fItemHelper;

	unsigned short fNumberOfRows;
	unsigned short fNumberOfColumns;

	// The following fields cache the dimensions of the menu, the row height
	// and the column width, for each row and column respectively.

	BR_Boolean fCalculateDimensions;
	BR_CPoint fDimensions;
	BR_SItemDimension* fColumnDimension;
	BR_SItemDimension* fRowDimension;

	unsigned short fOwnerDrawMenuState;						// Owner-Draw item state: Windows::ODS_xxx

#ifdef BR_BUILD_MAC
public:
	virtual void AppendCmd(BR_CBureaucrat::CommandId cmdID);
	virtual BR_CPullDownMenu* BedMacFindMenuItem(BR_CBureaucrat::CommandId commandId,
												 BR_CMenu::ItemPosition& position);
	// Internal platform method, should be named BedMacFindMenuItem
	virtual void InsertCmd(BR_CBureaucrat::CommandId cmdID,
						   ItemPosition position);
	virtual void RemoveCmd(BR_CBureaucrat::CommandId cmdID);

private:
	void DrawWholeMenu(BR_CBedMenuPane& Pane,
					   BR_CRectangle& aRect);
	unsigned short GetItemFromLoc(BR_CBedMenuPane& MenuPane,
								  BR_CRectangle& Area,
								  BR_CPoint& mousePt) const;
	unsigned short GetItemState(ItemPosition position) const;
	static pascal void NewOwnerDrawMenuDefFn(short msg,
											 MenuHandle ownerDrawMenu,
											 Rect* menuRect,
											 Point mousePt,
											 ItemPosition* itemId,
											 BR_CNewOwnerDrawMenu* thisMenu);
	short Pick(BR_CBedMenuPane& Pane,
			   BR_CRectangle& Area,
			   BR_CPoint& mousePt,
			   ItemPosition item);

	Handle fMenuDefProc;						// The unique MDEF procedure.
	Handle fOldMenuDefProc;						// Save the original menu def proc
	long fCheckFlags[4];						// We can have up to 128 items (I think it's enough)	
#endif

#ifdef BR_BUILD_WIN
private:
	BR_Boolean UnwrapColumns(ItemPosition position);
	BR_Boolean WrapColumns(ItemPosition position);
#endif

	friend BR_CBedMenuPane;
	friend BR_CItemHelper;

	BR_SETCLASSNAME(BR_CNewOwnerDrawMenu);
};

//----------------------------------------------------------------------------------------
// BR_CNewOwnerDrawMenu::GetColumns
//----------------------------------------------------------------------------------------

inline unsigned short BR_CNewOwnerDrawMenu::GetColumns() const
{
	return fNumberOfColumns;
}

//----------------------------------------------------------------------------------------
// BR_CNewOwnerDrawMenu::GetItemHelper
//----------------------------------------------------------------------------------------

inline BR_CItemHelper* BR_CNewOwnerDrawMenu::GetItemHelper() const
{
	BR_ASSERT(fItemHelper != NULL);
	return fItemHelper;
}

//----------------------------------------------------------------------------------------
// BR_CNewOwnerDrawMenu::GetRows
//----------------------------------------------------------------------------------------

inline unsigned short BR_CNewOwnerDrawMenu::GetRows() const
{
	return fNumberOfRows;
}

#endif


