#if !defined(BROWCNV_H) && !defined(__BEDRC__)
#define BROWCNV_H
//========================================================================================
//
//     File:			BROwCnv.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	September 13, 1990
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRCANVAS_H
#include "BRCanvas.h"  // always include our base class
#endif

#ifndef BRRECT_H
#include "BRRect.h"    // and classes that are stack based
#endif

//========================================================================================
//	BR_COwnerCanvas
//========================================================================================
class BR_COwnerCanvas : public BR_CCanvas
{
public:
	// New methods
	BR_COwnerCanvas(long lParam);
	virtual~ BR_COwnerCanvas();

	// This method is inherited
	virtual void GetDrawArea(BR_CRectangle& area) const;

private:
	// Unused
	BR_CRectangle fDrawArea;


#ifdef BR_BUILD_WIN
public:
	// Get this instance's ID
	WORD GetItem() const;

	// Get the visual state of this instance's item after the current
	// drawing action takes place (see the MS Windows Programmer's Reference
	// (V3) p. 7-37 for a list of return values)
	WORD GetState() const;

protected:										// Implementation
	// Inherited methods
	HDC BedWinCreateDC(BR_CView& pane);
	void BedWinDeleteDC(BR_CView& pane,
				  HDC hDC);

private:
	// A pointer to the DRAWITEMSTRUCT that defines the owner-Draw control
	// that this instance of BR_COwnerCanvas manipulates
	LPDRAWITEMSTRUCT fDrawItemStruct;
#endif

#ifdef BR_BUILD_MAC
public:
	virtual GrafPtr BedMacGetGrafPort() const;
	virtual void BedMacViewToCanvasOwner(BR_CPoint& /* aPoint */ ) const;
private:
	GrafPtr fMacGrafPtr;
#endif

	BR_SETCLASSNAME(BR_COwnerCanvas);
};

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_COwnerCanvas::GetItem
//----------------------------------------------------------------------------------------
// Get this instance's ID
inline WORD BR_COwnerCanvas::GetItem() const
{
	return fDrawItemStruct->itemID;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
//	BR_COwnerCanvas::GetItem
//----------------------------------------------------------------------------------------
inline WORD BR_COwnerCanvas::GetState() const
{
	return fDrawItemStruct->itemState;
}
#endif

#endif


