#if !defined(BRMSTRLI_H) && !defined(__BEDRC__)
#define BRMSTRLI_H
//========================================================================================
//
//     File:			BRMStrLi.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	1/11/90
//
//     COPYRIGHT 1990 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRSTRLIS_H
#include "BRStrLis.h"
#endif

#ifndef   BRRESOUR_H
#include "BRResour.h"
#endif

//========================================================================================
// Forward struct declarations
//========================================================================================

struct BR_SResourceHeader;

//========================================================================================
// STRUCT BR_SMultiStringResEntry
//========================================================================================

struct BR_SMultiStringResEntry
{
	short fStringId;
	unsigned short fStringOffset;
};

//========================================================================================
// STRUCT BR_SMultiStringHeader
//========================================================================================

struct BR_SMultiStringHeader
{
	unsigned short fStringCount;				// number of entrys
	BR_SMultiStringResEntry fEntryArray[1];		// table of entries
};


//========================================================================================
// CLASS BR_CMultiStringList
//========================================================================================

class BR_CMultiStringList : private BR_CStringList
{
public:
	typedef unsigned long int StringId;

	BR_CMultiStringList(const BR_CModule &module,
						BR_ResourceId resourceId);
	virtual~ BR_CMultiStringList();

	// Inherited methods
	virtual BR_Boolean GetString(BC_Index index,
								 BR_TString<BR_Char>& buffer) const;
	virtual BC_Index Length() const;
	virtual BC_Extended_Index FindString(const BR_TString<BR_Char>& strFind) const;

	virtual BR_Boolean GetStringByPos(BC_Index position,
									  BR_TString<BR_Char>& buffer) const;
	virtual BR_Boolean GetStringById(StringId id,
									 BR_TString<BR_Char>& buffer) const;
	virtual unsigned short GetStringId(BC_Index pos) const;

private:
	BR_CResource fResource;						// the resource we are to fetch
												// strings from.

	unsigned short GetStringOffset(BR_SMultiStringHeader& theResource,
								   short theKey) const;

	BR_SETCLASSNAME(BR_CMultiStringList);
};




#endif
