#if !defined(BRMOUSEA_H) && !defined(__BEDRC__)
#define BRMOUSEA_H
//========================================================================================
//
//     File:		BRMouseA.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/9/90
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================


#ifndef BRCHORE_H
#include "BRChore.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"   
#endif

#ifndef BRRESOUR_H
#include "BRResour.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CCursor;        
class BR_CModule;
class BR_CView;
class BR_CCanvas;

//========================================================================================
//	BR_CMouseAction
//========================================================================================

class BR_CMouseAction : public BR_CAction
{
public:
	BR_CMouseAction(BR_CView* paneToTrackIn,
					BR_CModule* resourceModule,
					BR_ResourceId resourceID,
					BR_Boolean notifyDocument = TRUE,
					BR_Boolean deleteWhenDone = TRUE,
					BR_Boolean autoScroll = TRUE);
	BR_CMouseAction(BR_CView* paneToTrackIn,
					BR_Boolean notifyDocument = TRUE,
					BR_Boolean deleteWhenDone = TRUE,
					BR_Boolean autoScroll = TRUE);
	virtual ~BR_CMouseAction();

	virtual void BeginTracking(const BR_CPoint& startPoint);
	virtual void KeepTracking(const BR_CPoint& currentPoint);
	virtual void EndTracking(const BR_CPoint& currentPoint);
	BR_Boolean IsTracking() const;
	void SetTracking(BR_Boolean trackMouse);

	void GetStartPoint(BR_CPoint& startPoint) const;
	void GetPreviousPoint(BR_CPoint& previousPoint) const;
	BR_Boolean DoNotify() const;
	virtual BR_CCursor* GetCursor(const BR_CPoint& cursorPosition) const;
	BR_Boolean IsShortTerm() const;

	BR_CView* GetPane() const;
	virtual void SetPane(BR_CView* paneToTrackIn);

	virtual void Draw(BR_CCanvas &canvas, const BR_CRectangle& updateArea);

protected:
	void SetStartPoint(const BR_CPoint& startPoint);
	void SetPreviousPoint(const BR_CPoint& previousPoint);
	
	BR_Boolean fAutoScroll;		// TRUE if autoscrolling to be done.

private:
	BR_CPoint fMouseStartPoint;							// Starting point
	BR_CPoint fMouseCurrentPoint;						// Last point recorded
	BR_CView* fTrackingPane;							// The pane we're tracking

	//If TRUE, this instance is currently tracking the mouse
	BR_Boolean fIsTracking;

	//If TRUE, this instance is your document's 'undo' function
	BR_Boolean fNotifyDocument;

	//If TRUE, this instance will be deleted as soon as it is sent the
	//EndTracking() message.  If FALSE, it isn't deleted, and the pane that
	//owns it is responsible for insuring it is eventually deleted.  Note
	//that this variable is relevant only When fNotifyDocument is FALSE
	BR_Boolean fDeleteActionOnMouseUp;

	BR_SETCLASSNAME(BR_CMouseAction);
};




//----------------------------------------------------------------------------------------
//	BR_CMouseAction::GetStartPoint
//
//		Puts the start point of the tracking action in startPoint.
//----------------------------------------------------------------------------------------
inline void BR_CMouseAction::GetStartPoint(BR_CPoint& startPoint) const
{
	startPoint = fMouseStartPoint;
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::GetPreviousPoint
//
//		Puts the last known coordinate of the mouse in previousPoint.  
//----------------------------------------------------------------------------------------
inline void BR_CMouseAction::GetPreviousPoint(BR_CPoint& previousPoint) const
{
	
	previousPoint = fMouseCurrentPoint;
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::DoNotify
//
//		Returns TRUE if the document should be notified by this action.
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CMouseAction::DoNotify() const
{
	return (fNotifyDocument);
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::IsTracking
//
//		Returns TRUE if the mouse is currently being tracked.
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CMouseAction::IsTracking() const
{
	return (fIsTracking);
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::SetTracking
//
//		If trackMouse is Set to TRUE then the action will begin tracking mouse movements.
//----------------------------------------------------------------------------------------
inline void BR_CMouseAction::SetTracking(BR_Boolean trackMouse)
{
	fIsTracking = trackMouse;
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::IsShortTerm
//
//		If an action is short term, then it will be deleted on the fNext mouseUp message.
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CMouseAction::IsShortTerm() const
{
	return (fDeleteActionOnMouseUp);
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::SetStartPoint
//
//		Sets the Value of the start point for the action.
//----------------------------------------------------------------------------------------
inline void BR_CMouseAction::SetStartPoint(const BR_CPoint& startPoint)
{
	fMouseStartPoint = startPoint;
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::SetPreviousPoint
//
//		Sets the Value of the last known coordinate of the mouse.
//----------------------------------------------------------------------------------------
inline void BR_CMouseAction::SetPreviousPoint(const BR_CPoint& previousPoint)
{
	fMouseCurrentPoint = previousPoint;
}


//----------------------------------------------------------------------------------------
//	BR_CMouseAction::GetPane
//
//		Returns the BR_CView object that the mouse is/will be tracking in.
//----------------------------------------------------------------------------------------
inline BR_CView* BR_CMouseAction::GetPane() const
{
	return fTrackingPane;
}


#endif
