#if !defined(BRMNUITE_H) && !defined(__BEDRC__)
#define BRMNUITE_H
//========================================================================================
//
//     File:			BRMnuIte.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/13/91
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRRESOUR_H
#include "BRResour.h"
#endif

#ifndef BRBUREAU_H
#include "BRBureau.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CModule;
class BR_CMenu;
class BR_CApplication;


//========================================================================================
// STRUCT BR_SMenuItemResource
//========================================================================================

struct BR_SMenuItemResource : BR_SResource
{
    BR_CBureaucrat::CommandId fCommandId;
    char fText[64];
    BR_Boolean fSeparator;
};


//========================================================================================
// CLASS BR_CMenuItem
//
// Objects of this class are used for text menu loading. An instance of the class is
// created for each text menu item. Ctor adds the menu item to the parent menu and deletes
// the object.
//========================================================================================

class BR_CMenuItem : public BR_CObject
{
public:
	BR_CMenuItem(BR_CApplication& application,
				 BR_CMenu& parentMenu,
				 const BR_CModule& module,
				 BR_SResource& resource);

	virtual~ BR_CMenuItem();

	BR_SETCLASSNAME(BR_CMenuItem);
};

#endif
