#if !defined(BRMNUBAR_H) && !defined(__BEDRC__)
#define BRMNUBAR_H
//========================================================================================
//
//     File:			BRMnuBar.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	September 14, 1990
//
//     COPYRIGHT 1990-93 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRMENU_H
#include "BRMenu.h"
#endif

#ifndef   BRRESOUR_H
#include "BRResour.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CBureaucrat;
class BR_CApplication;
class BR_CModule;


//========================================================================================
// STRUCT BR_SMenuBarResource
//========================================================================================

//struct  BR_SMenuBarResource : BR_SMenuResource (ZTC bug)
struct  BR_SMenuBarResource : BR_SResource
{
};

//========================================================================================
// CLASS BR_CMenuBar
//========================================================================================

class BR_CMenuBar : public BR_CMenu
{
public:
	BR_CMenuBar(BR_CApplication& application,
				BR_CMenu& parentMenu,
				const BR_CModule& module,
				BR_SResource& resource);
	BR_CMenuBar();
	
	virtual~ BR_CMenuBar();

#ifdef BR_BUILD_MAC
public:
	static BR_CMenuBar* gMenuBar;

	virtual void AddMenu(BR_CPullDownMenu* menu);
	virtual void AddMenu(BR_CPullDownMenu* menu,
						 ItemPosition beforePosition);

	void SetMenuBar();
	void UnsetMenuBar();
	BR_CPullDownMenu* GetSubMenu(ItemPosition position) const;
	BR_CPullDownMenu* GetAppleMenu() const;

	virtual BR_CBureaucrat::CommandId FindCmdId(MenuId menuId,
												ItemPosition itemPosition);

	void PerformUpdateMenus(BR_CBureaucrat* focus);

	static void InvalidateMenus();
	static void ValidateMenus();
	static BR_Boolean AreMenusInvalid();
	static void InvalidateMenuBar();
	static void ValidateMenuBar();
	static BR_Boolean MenuBarHasPendingUpdate();

private:
	static BR_Boolean gMenusAreInvalid;			// TRUE->menus need an UpdateMenus
	static BR_Boolean gMenuBarIsInvalid;		// TRUE->menubar needs to be redraw
#endif

#ifdef BR_BUILD_WIN
public:
	BR_Boolean IsMDISystemMenu(HMENU menuHandle) const;
	virtual ItemPosition BedWinGetBaseId() const;
#endif

	BR_SETCLASSNAME(BR_CMenuBar);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::GetAppleMenu
//----------------------------------------------------------------------------------------

inline BR_CPullDownMenu *BR_CMenuBar::GetAppleMenu() const
{
	return GetSubMenu(0);
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::InvalidateMenus
//----------------------------------------------------------------------------------------

inline void BR_CMenuBar::InvalidateMenus()
{
	gMenusAreInvalid = TRUE;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::ValidateMenus
//----------------------------------------------------------------------------------------

inline void BR_CMenuBar::ValidateMenus()
{
	gMenusAreInvalid = FALSE;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::AreMenusInvalid
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CMenuBar::AreMenusInvalid()
{
	return gMenusAreInvalid;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::ValidateMenuBar
//----------------------------------------------------------------------------------------

inline void BR_CMenuBar::ValidateMenuBar()
{
	gMenuBarIsInvalid = FALSE;
}
#endif

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CMenuBar::MenuBarHasPendingUpdate
//----------------------------------------------------------------------------------------

inline BR_Boolean BR_CMenuBar::MenuBarHasPendingUpdate()
{
	return gMenuBarIsInvalid;
}
#endif

#endif
