#if !defined(BRMIXMNU_H) && !defined(__BEDRC__)
#define BRMIXMNU_H
//========================================================================================
//
//     File:			BRMixMnu.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/14/91
//
//     COPYRIGHT 1991-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRMIXMNU_K
#include "BRMixMnu.k"
#endif

#ifndef   BROWDRMN_H
#include "BROwDrMn.h"
#endif

#ifndef   BRMSTRLI_H
#include "BRMStrLi.h"
#endif

#ifndef   BROWDRMN_H
#include "BROwDrMn.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================
class BR_CBitmap;
class BR_CFramedBitmap;

//========================================================================================
// BR_CMixedMenu
//
//	an OD-menu class that draws a piece of a bitmap and some
//  text in each item.  Text can appear on either side of the bitmap -- this
//  is controlled by MIXMENU_TEXTxxx fFlags (above).  Selected menu item is
//  hilited by drawing it in appropriate colors (Windows system colors Set
//  in CPanel are used.)
//========================================================================================

class BR_CMixedMenu : public BR_CBitmapMenu
{
public:
	typedef unsigned short int MixedMenuTextFlags;
	
public:
	BR_CMixedMenu(BR_CApplication& app,
				  BR_CMenu& parentMenu,
				  const BR_CModule& module,
				  BR_SResource& resouce);

	BR_CMixedMenu(BR_CApplication& app,
				  const BR_CModule& module,
				  BR_ResourceId nameResId,
				  BR_CBureaucrat::CommandId startCommand,
				  unsigned short numberOfRows,
				  unsigned short numberOfColumns,
				  BR_ResourceId bmpResId,
				  BR_CBitmapMenu::BitmapMenuBitmapFlags bitmapFlags,
				  BR_ResourceId textResId,
				  MixedMenuTextFlags mixedMenuTextFlags);

	virtual~ BR_CMixedMenu();

	// Inherited methods
	virtual void GetItemSize(BR_CMenuPane& menuPane,
							 BR_CRectangle& area,
							 BR_CBureaucrat::CommandId commandId) const;
	virtual void DrawItem(BR_CMenuPane& menuPane,
						  BR_CRectangle& area,
						  BR_CBureaucrat::CommandId commandId);
	virtual void GetCmdText(unsigned short commandId,
							BR_TString<BR_Char>& string,
							BR_Boolean byPosition = FALSE) const;
	virtual BR_Boolean GetItemByCharacter(BR_StringCharacter character,
									  BR_CBureaucrat::CommandId& commandId) const;

	BR_SETCLASSNAME(BR_CMixedMenu);

protected:
	virtual void GetPartRects(BR_CMenuPane& menuPane,
							  const BR_CRectangle& itemRect,
							  BR_CBureaucrat::CommandId commandId,
							  BR_CRectangle& bitmapRect,
							  BR_CRectangle& textRect,
							  BR_CRectangle& checkMarkRect);

private:
	BR_CMultiStringList fItemsTextList;				// This stores items text
	MixedMenuTextFlags fTextFlags;					// Text fFlags: MIXMENU_xxx

	BR_Boolean IsTextLeft() const;
	BR_Boolean IsTextRight() const;


};

//----------------------------------------------------------------------------------------
//	BR_CMixedMenu::IsTextLeft
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CMixedMenu::IsTextLeft() const
{
	return fTextFlags & kTextLeft;
}

//----------------------------------------------------------------------------------------
//	BR_CMixedMenu::IsTextLeft
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CMixedMenu::IsTextRight() const
{
	return fTextFlags & kTextRight;
}

//========================================================================================
//	BR_SMixedMenuResource
//========================================================================================
struct BR_SMixedMenuResource : BR_SBitmapMenuResource
{
	BR_ResourceId fItemsResourceId;
	BR_CMixedMenu::MixedMenuTextFlags fTextFlags;
};

#endif


