#if !defined(BRMESSAG_H) && !defined(__BEDRC__)
#define BRMESSAG_H
//========================================================================================
//
//     File:			BRMessag.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	2/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif


//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CMessage;
class BR_CBureaucrat;


//========================================================================================
// CLASS BR_CMessanger
//
// An abstract class that defines protocol for an object that is responsible for accepting
// messages from the system and shepparding them through Bedrock.
//========================================================================================

class BR_CMessanger : public _BR_CAutoDestructObject
{
public:
	typedef unsigned long int MessageId;
	
	static const MessageId kInvalidMessageId;
	
	BR_CMessanger();
	BR_CMessanger(const BR_CMessanger &messanger);
	BR_CMessanger &operator=(const BR_CMessanger &messanger);
	virtual ~BR_CMessanger();
	
	BR_CMessanger(BR_CMessage *message,
				  BR_CMessage *reply,
				  MessageId messageId);
	
	virtual BR_CMessage *GetMessage() const;
	virtual void SetMessage(BR_CMessage *message);
	
	virtual MessageId GetMessageId() const;
	virtual void SetMessageId(MessageId messageId);
	
	virtual BR_CMessage *GetReply() const;
	virtual void SetReply(BR_CMessage *reply);
	
	virtual BR_CBureaucrat *GetTarget();
	
	virtual BR_Boolean Dispatch();
	
protected:

private:
	MessageId fMessageId;
	BR_CMessage *fMessage;
	BR_CMessage *fReply;
};


//========================================================================================
// CLASS BR_CMessage
//========================================================================================

class BR_CMessage : public _BR_CAutoDestructObject
{
public:
	class CMessageAddress { };
	
	BR_CMessage();
	BR_CMessage(const BR_CMessage &message);
	BR_CMessage &operator=(const BR_CMessage &message);
	virtual ~BR_CMessage();
};

#endif
