#if !defined(BRMENUPN_H) && !defined(__BEDRC__)
#define BRMENUPN_H
//========================================================================================
//
//     File:			BRMenuPn.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	December 92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRCANVAS_H
#include "BRCanvas.h"
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class BR_CNewOwnerDrawMenu;
class BR_CWindow;

//========================================================================================
// CLASS BR_CBedMenuPane
//========================================================================================

class BR_CBedMenuPane : public BR_CView
{
public:
	virtual~ BR_CBedMenuPane();
	virtual void DoDraw();
	BR_CNewOwnerDrawMenu *GetMenu() const;

	// Inherited methods
	virtual void PreDraw();						// ?INTERNAL?
	virtual void PostDraw();					// ?INTERNAL?

	//----------------------------------------------------------------------------------------
	// Macintosh
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
public:
	BR_CBedMenuPane(BR_CView *enclosure,
					BR_CNewOwnerDrawMenu* menu,
					const BR_CRectangle& area);						// ?INTERNAL?
	virtual BR_CWindow* GetWindow() const;							// ?INTERNAL?
private:
	BR_CNewOwnerDrawMenu* fOwnerDrawMenu;
	BR_CRectangle fOwnerDrawRect;
#endif

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	BR_CBureaucrat::CommandId GetItem() const;
	void MeasureItem();

	BR_CBedMenuPane(BR_CView *enclosure,
								 LPDRAWITEMSTRUCT drawItemStruct);	// ?INTERNAL?

	BR_CBedMenuPane(BR_CView *enclosure,
								 LPMEASUREITEMSTRUCT drawItemStruct);// ?INTERNAL?
private:
	LPDRAWITEMSTRUCT fWinDrawDataStruct;				// Data passed with WM_DRAWITEM
	LPMEASUREITEMSTRUCT fWinMeasureDataStruct;			// Data passed with WM_MEASUREITEM
	BR_Boolean fCascading;

	BR_Boolean IsCascadingMenu() const;
#endif

	BR_SETCLASSNAME(BR_CBedMenuPane);
};

#ifdef BR_BUILD_MAC
//----------------------------------------------------------------------------------------
// BR_CBedMenuPane::GetMenu
//----------------------------------------------------------------------------------------
inline BR_CNewOwnerDrawMenu *BR_CBedMenuPane::GetMenu() const
{
	return fOwnerDrawMenu;
}
#endif

#ifdef BR_BUILD_WIN
//----------------------------------------------------------------------------------------
// BR_CBedMenuPane::IsCascadingMenu
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CBedMenuPane::IsCascadingMenu() const
{
	return (fCascading);
}
#endif

#ifdef BR_BUILD_MAC
//========================================================================================
// CLASS BR_CBedMacMenuCanvas
//
//	This class serves two purposes:
//	1. it allows us to Draw with PixPats in color menus without worrying
//	   about a bug in ColorQuickDraw that creates PixPats in the wrong fQueueHeap
//	   When drawing to the WMgrCPort.
//	2. It allows us to fiddle with things that we shouldn't fiddle with in the
//	   window manager's ports, like clip regions and origins  - things that
//	   bcl panes and canvases like to be free to fiddle with.
//
//	The basic approach is that we Create a grafport that we use instead of
//	whichever port is current when our mdef is called.  our canvas-pane
//	coord conversions are called by BR_CCanvas::baseopenpane which uses them
//  in a ::SetOrigin call.  the clipping is Set to the area of the menu,
//	but the 0,0 point is actually set to the fTop fLeft of the menu.
//  this way, we don't need to offset items before drawing them on the mac.
//
//	12/4/92 Brad Pettit
//========================================================================================
class BR_CBedMacMenuCanvas : public BR_CCanvas
{

public:
	BR_CBedMacMenuCanvas(const BR_CRectangle& area);

	virtual~ BR_CBedMacMenuCanvas();

	virtual void GetDrawArea(BR_CRectangle& area) const;

	virtual void BedMacViewToCanvasOwner(BR_CPoint& aPoint) const;

	virtual GrafPtr BedMacGetGrafPort() const;

private:
	GrafPtr fMacGrafPort;						// the port that we Create to use instead of the window manager port
	GrafPtr fMacOldGrafPort;					// the port that is Set When our mdef is hit
	BR_CRectangle fArea;						// the menu rectangle relative to the window manager port
	BR_CPoint fPortOffset;						// the origin of the window manager

};
#endif

#endif


