#if !defined(BRITEMHE_H) && !defined(__BEDRC__)
#define BRITEMHE_H
//========================================================================================
//
//     File:			BRItemHe.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	November 1992
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRVIEW_H
#include "BRView.h"
#endif

#ifndef BRLISTBX_H
#include "BRListBx.h"
#endif


//========================================================================================
// Type definitions
//========================================================================================

const unsigned short kTextItemHelperResourceId = 4320;
const unsigned short kBitmapGridItemHelperResourceId = 4321;


//========================================================================================
// Type definitions
//========================================================================================

enum LBCompareResult
{
	kLHSLessThanRHS = -1, kLHSEqualToRHS = 0, kLHSGreaterThanRHS = 1
};


//========================================================================================
// STRUCT BR_SItemHelperResource
//========================================================================================

struct BR_SItemHelperResource
{
	unsigned short fLeftMargin;
	unsigned short fRightMargin;
};

//========================================================================================
// CLASS BR_CItemHelper
//========================================================================================

class BR_CItemHelper : public BR_CObject
{
public:
	virtual ~BR_CItemHelper();

	virtual LBCompareResult CompareItem(const BR_CView& pane,
										const BR_CObject& lhs,
										const BR_CObject& rhs) const;
	virtual void DrawDim(BR_CView& pane,
						 const BR_CObject& item,
						 const BR_CRectangle& itemArea,
						 BR_Boolean dim);
	virtual void DrawItem(BR_CView& pane,
						  const BR_CObject& item,
						  const BR_CRectangle& itemArea) = 0;
	virtual void DrawMark(BR_CView& pane,
						  const BR_CObject& item,
						  const BR_CRectangle& itemArea,
						  BR_Boolean marked);
	virtual void DrawSelection(BR_CView& pane,
							   const BR_CObject& item,
							   const BR_CRectangle& itemArea,
							   BR_Boolean select);
	virtual void GetItemSize(const BR_CView& pane,
							 BR_Distance& width,
							 BR_Distance& height) const = 0;
	virtual BR_CListBoxBase::ItemIndex GetItemByCharacter(const BR_CView& pane,
									   BR_StringCharacter character) const;
	virtual void GetTextFromItem(const BR_CObject& item,
								 BR_TString<BR_Char>& text) const;
	virtual BR_Boolean GetItemsHaveMarks() const;
	virtual void SetItemsHaveMarks(BR_Boolean haveMarks);

protected:
	BR_CItemHelper();
	BR_CItemHelper(BR_CObject& parent,
				   const BR_CModule& module,
				   BR_SResource& resource);
private:
	BR_Boolean fItemsHaveMarks;
	unsigned short fLeftMargin;
	unsigned short fRightMargin;

#ifdef BR_BUILD_WIN
public:
	virtual void DrawFocus(BR_CView& pane,
						   const BR_CObject& item,
						   const BR_CRectangle& itemArea,
						   BR_Boolean focus);
#endif

};


//========================================================================================
// STRUCT BR_STextItemHelperResource
//========================================================================================

struct BR_STextItemHelperResource
{
};

//========================================================================================
// CLASS BR_CTextItemHelper
//========================================================================================

class BR_CTextItemHelper : public BR_CItemHelper
{
public:
	BR_CTextItemHelper();
	BR_CTextItemHelper(BR_CObject& parent,
					   const BR_CModule& module,
					   BR_SResource& resource);
	virtual ~BR_CTextItemHelper();

	virtual LBCompareResult CompareItem(const BR_CView& pane,
										const BR_CObject& lhs,
										const BR_CObject& rhs) const;
	virtual void DrawItem(BR_CView& pane,
						  const BR_CObject& item,
						  const BR_CRectangle& itemArea);
	virtual void DrawMark(BR_CView& pane,
						  const BR_CObject& item,
						  const BR_CRectangle& itemArea,
						  BR_Boolean marked);
	virtual void GetItemSize(const BR_CView& pane,
							 BR_Distance& width,
							 BR_Distance& height) const;
	virtual BR_Distance GetMarkWidth(BR_CView& pane) const;
	virtual void GetTextFromItem(const BR_CObject& item,
								 BR_TString<BR_Char>& text) const;

#ifdef BR_BUILD_WIN
public:
	virtual void DrawSelection(BR_CView& pane,
							   const BR_CObject& item,
							   const BR_CRectangle& itemArea,
							   BR_Boolean select);
#endif

};


//========================================================================================
// STRUCT BR_SBitmapGridHelperResource
//========================================================================================

struct BR_SBitmapGridHelperResource
{
};

//========================================================================================
// CLASS BR_CBitmapGridItemHelper
//========================================================================================

class BR_CBitmapGridItemHelper : public BR_CItemHelper
{
public:
	BR_CBitmapGridItemHelper();
	BR_CBitmapGridItemHelper(BR_CObject& parent,
							 const BR_CModule& module,
							 BR_SResource& resource);
	virtual ~BR_CBitmapGridItemHelper();

	virtual void DrawItem(BR_CView& pane,
						  const BR_CObject& item,
						  const BR_CRectangle& itemArea);
	virtual void GetItemSize(const BR_CView& pane,
							 BR_Distance& width,
							 BR_Distance& height) const;
};

#endif

