#if !defined(BRHVIEW_H) && !defined(__BEDRC__)
#define BRHVIEW_H
//========================================================================================
//
//     File:			BRHView.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	3/15/93
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRRECT_H
#include "BRRect.h"
#endif

#ifndef BRTSTRS_H
#include "BRTStrs.h"
#endif

//========================================================================================
// Forward
//========================================================================================

class BR_CView;

//========================================================================================
// Types
//========================================================================================

#ifdef BR_BUILD_WIN
	typedef HWND BR_PlatformWindow;
#endif
#ifdef BR_BUILD_MAC
	typedef WindowPtr BR_PlatformWindow;
#endif

//========================================================================================
// class BR_CViewHelper
//========================================================================================

class BR_CViewHelper : public BR_CObject
{
#ifdef BR_BUILD_MAC
	friend class BR_CMacWindowHelper;
#endif
#ifdef BR_BUILD_WIN
	friend class BR_CWinViewHelper;
#endif
	
public:
	BR_CViewHelper(BR_CView *theView);
	virtual ~BR_CViewHelper();

	virtual void		SetFrame(const BR_CRectangle& rRect, BR_Boolean redraw) = 0;
	virtual void		SetViewFrame(BR_Boolean redraw) = 0;
	virtual void		GetBorderSize(BR_CRectangle& borderSize) const = 0;
	
	virtual void		SetEnclosure(BR_CView *enclosure) = 0;
	
	virtual void		Update() = 0;
	virtual void		RefreshRect(const BR_CRectangle &refreshRect) = 0;
	virtual void		UnRefreshRect(const BR_CRectangle &refreshRect) = 0;
	
	virtual void				SetTitle(const BR_TString<BR_Char>& text) = 0;
	virtual unsigned long 	GetTitle(BR_TString<BR_Char>& text) const = 0;
	virtual unsigned long 	GetTitleLength() const = 0;

	virtual void 		Show(BR_Boolean show = TRUE) = 0;
	virtual void		BedShowHideSubviews(BR_Boolean state) = 0;
	
	virtual void 		BeginDeferMove() = 0;
	virtual void 		EndDeferMove() = 0;

	virtual void 		LocalToGlobal(BR_CPoint &pt) const = 0;
	virtual void 		GlobalToLocal(BR_CPoint &pt) const = 0;

	virtual void		SetFocus() = 0;
	virtual void		SetEnable(BR_Boolean state) = 0;
	
	virtual void		SetCapture() = 0;
	virtual void		ReleaseCapture() = 0;
	
	virtual void		SetAutoRedraw(BR_Boolean autoRedraw) = 0;
	
	void				SetPlatformWindow(BR_PlatformWindow platformWindow);
	BR_PlatformWindow	GetPlatformWindow() const;
	
	BR_CView			*GetView() const;	
	BR_CViewHelper		*GetEnclosingViewHelper() const;
	
	BR_SETCLASSNAME(BR_CViewHelper);

private:
	BR_CView			*fView;
	BR_PlatformWindow	fPlatformWindow;
};

//----------------------------------------------------------------------------------------
//	BR_CViewHelper::GetView
//----------------------------------------------------------------------------------------

inline BR_CView* BR_CViewHelper::GetView() const
{
	return fView;
}

//----------------------------------------------------------------------------------------
//	BR_CViewHelper::SetPlatformWindow
//----------------------------------------------------------------------------------------

inline void BR_CViewHelper::SetPlatformWindow(BR_PlatformWindow platformWindow)
{
	fPlatformWindow = platformWindow;
}

//----------------------------------------------------------------------------------------
//	BR_CViewHelper::GetPlatformWindow
//----------------------------------------------------------------------------------------

inline BR_PlatformWindow BR_CViewHelper::GetPlatformWindow() const
{
	return fPlatformWindow;
}

#endif