#if !defined(BRGRHELP_H) && !defined(__BEDRC__)
#define BRGRHELP_H
//========================================================================================
//
//     File:			BRGrHelp.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	6/13/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRDELSTA_H
#include "BRDelSta.h"
#endif

#ifndef BREXCLIB_H
#include "BRExcLib.h"
#endif

#ifndef BRSUPDEF_H
#include "BRSupDef.h"
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

#ifndef BRCOLOR_H
#include "BRColor.h"
#endif

//========================================================================================
// Forward class declaration
//========================================================================================
class BR_CView;
class BR_CGraphicsTool;
class BR_CWallPaper;
class BR_CRegion;
class BR_CPen;
class BR_CFont;
class BR_CCanvas;
class BR_CRectangle;

//========================================================================================
// BR_CDrawEnvironment
//
//  Used to save and restore the current draw environment without knowledge
//	of machine/system features
//========================================================================================

class BR_CDrawEnvironment : public _BR_CAutoDestructObject
{
public:
	virtual void RememberCurrent();
	virtual void SetCurrent();
	virtual~ BR_CDrawEnvironment();				// Required by the exception system

#ifdef BR_BUILD_MAC
public:
	BR_CDrawEnvironment(GrafPtr fMacPort = NULL,
						GDHandle macDevice = NULL);
	GrafPtr GetPortPtr() const;
	GDHandle GetDeviceHandle() const;
	void GetBoundsRect(Rect &r) const;

protected:
	void SetPortPtr(GrafPtr p);
	void SetDeviceHandle(GDHandle h);

private:
	GrafPtr fPort;
	GDHandle fDevice;
#endif

};

//----------------------------------------------------------------------------------------
//	BR_CDrawEnvironment::GetPortPtr
//----------------------------------------------------------------------------------------	
#ifdef BR_BUILD_MAC
inline GrafPtr BR_CDrawEnvironment::GetPortPtr() const
{
	return fPort;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CDrawEnvironment::GetDeviceHandle
//----------------------------------------------------------------------------------------	
#ifdef BR_BUILD_MAC
inline GDHandle BR_CDrawEnvironment::GetDeviceHandle() const
{
	return fDevice;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CDrawEnvironment::GetBoundsRect
//----------------------------------------------------------------------------------------	
#ifdef BR_BUILD_MAC
inline void BR_CDrawEnvironment::GetBoundsRect(Rect &r) const
{
	r = fPort->portRect;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CDrawEnvironment::SetPortPtr
//----------------------------------------------------------------------------------------	
#ifdef BR_BUILD_MAC
inline void BR_CDrawEnvironment::SetPortPtr(GrafPtr p)
{
	fPort = p;
}
#endif

//----------------------------------------------------------------------------------------
//	BR_CDrawEnvironment::SetDeviceHandle
//----------------------------------------------------------------------------------------	
#ifdef BR_BUILD_MAC
inline void BR_CDrawEnvironment::SetDeviceHandle(GDHandle h)
{
	fDevice = h;
}
#endif


//========================================================================================
// BR_CDrawEnvironmentSaveRestore
//
//  Used to save and restore the current draw environment without knowledge
//	of machine/system features
//========================================================================================

class BR_CDrawEnvironmentSaveRestore : public BR_CDrawEnvironment
{
public:
	BR_CDrawEnvironmentSaveRestore();
	virtual~ BR_CDrawEnvironmentSaveRestore();
};


//========================================================================================
// BR_CGraphicsToolSelector
//
//
//   Used to select graphics obejcts into a pane while drawing.  This allows
//   for rendering to multiple (nested) canvases (like off-screeen bitmaps) and
//   is also exception-handling conformant.
//========================================================================================

class BR_CGraphicsToolSelector : public _BR_CAutoDestructObject
{
public:
	BR_CGraphicsToolSelector(BR_CView *pane,
							BR_CGraphicsTool *graphicsTool);
	// Selects GraphicsTool into the Pane's current canvas.  The previous
	// pane's graphics tool  of the same class as GraphicsTool is saved.

	BR_CGraphicsToolSelector();
	// Fail-safe constructor.  Use this one to embed instances of BR_CGraphicsToolSelector
	// into your draw objects (see how it's used in BR_CImageAdorner, etc.

	void Init(BR_CView *Pane,
			  BR_CGraphicsTool *GraphicsTool);
	// Selects GraphicsTool into the Pane's current canvas.  The previous
	// pane's graphics tool  of the same class as GraphicsTool is saved.

	void Term();
	// Selects the previous tool saved into the Pane which was passed in the ctor or to init.


	virtual~ BR_CGraphicsToolSelector();
	// Selects the previous tool saved into the Pane which was passed in the ctor.

private:
	BR_CView* fPane;							// The pane whose canvas the tool is selected into
	BR_CGraphicsTool* fSelectTool;				// The selected tool
	BR_CGraphicsTool* fPreviousTool;			// The previously selected tool of the same kind
#ifdef BR_DEBUG
	BR_CCanvas* fCanvas;						// Make sure the application doesn't change the canvas
#endif

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
private:
	BR_SGraphicsToolSuspendResumeState fToolSuspendResumeState;
#endif

};

//========================================================================================
//  BR_CBedDrawContextCreator:
//
//  Used to create and delete drawing environment which can be reused if we draw
//  multiple panes on the same canvas.  It's a DC in Windows, or an instance of 
//  BR_CDrawingEnvironment on the Mac.
//
//  This is an implementation class and you should not use it directly.
//========================================================================================

class BR_CBedDrawContextCreator : public _BR_CAutoDestructObject
{
public:
	BR_CBedDrawContextCreator();
	// Doesn't do anything so that it's guaranteed to not throw.

	BR_CBedDrawContextCreator(BR_CView* pane,
							  BR_CCanvas* canvas);
	// Calls Init(BR_CView*, BR_CCanvas*) to create a drawing context in the canvas.

	virtual~ BR_CBedDrawContextCreator();
	// Deletes the Canvas' drawing context if the ctor has created it.

	void Init(BR_CView* pane,
			  BR_CCanvas* canvas);
	// Checks if the passed Canvas has a drawing context already and if not,
	//  creates one. 

	void Term();
	// Deletes the Canvas' drawing context if the ctor has created it.

private:
	BR_CCanvas* fCanvas;						// The canvas that the DC is created for
	BR_CView* fPane;							// The pane that will be drawn on the canvas
#ifdef BR_BUILD_WIN	
	HDC fDC;									// The DC we've created or NULL
#endif

#ifdef BR_BUILD_MAC
	BR_CDrawEnvironmentSaveRestore fDrawEnvironment;
#endif

};

//========================================================================================
//  BR_CDrawStateData
//
//  Used for temporary data storage when we suspend/resume drawing to draw one pane
//  on several canvases (e.g., off-screen bitmap) 
//========================================================================================

class BR_CDrawStateData
{
public:
	BR_CDrawStateData();

	BR_CFont* fOldFont;
	BR_CWallPaper* fOldWallPaper;
	BR_CRegion* fOldRegion;
	BR_CPen* fOldPen;
};

//========================================================================================
//  BR_CDrawInitiator
//
//  Create an instance of this class to draw on a pane.  It handles nesting
//  canvases and is exception-handling safe
//========================================================================================

class BR_CDrawInitiator : public _BR_CAutoDestructObject
{
public:
	void* operator new(size_t /*cbSize*/, void* fMemoryPtr);
	// Use this to instantiate dynamic instances of BR_CDrawInitiator without risking
	//  fMemory leaks.

	void* operator new(size_t cbSize);

	inline void operator delete(void* fMemoryPtr);

	BR_CDrawInitiator(BR_CView *pane,
									 BR_CCanvas *canvas);
	// Start drawning on Pane using Canvas.  If Pane was drawing on some other
	//  canvas or some other pane was drawing on Canvas, that pane's state is saved and
	//  restored by the dtor.

	BR_CDrawInitiator(BR_CView *pane);
	// Start drawing on Pane using its current canvas.  Will be changed in the
	//  future to use the pane's default canvas as there will be no such thing as pane's
	//  currnt canvas.

	void Init(BR_CView *pane,
							 BR_CCanvas *canvas);
	// Called from two constructors above or you can call if you allocate a BR_CDrawInitiator on
	//  the fQueueHeap with the constuctor below and you don't want fMemory leaks.

	BR_CDrawInitiator();
	// This is the fail-safe constructor.

	virtual~ BR_CDrawInitiator();
	// Finish drawing on the pane and go back to the previous pane if there was any.

	void Term();
	// Called by the destructor, by you might want to call it to avoid fMemory leaks.

private:
	BR_CView* fPane;							// The pane we've initiated drawing on
	BR_CCanvas* fCanvas;						// This is the canvas we're drawing the pane on
	BR_CView* fOldCanvasPane;					// The canvas' pane at the time ctor is called
	BR_CCanvas* fOldPaneCanvas;				// The pane's canvas at the time ctor is called
	BR_CBedDrawContextCreator fContextCreator;	// The first phase: Create a drawing context
	BR_CView* fOldDrawingPane;				// The previous pane that was in the drawing state

	BR_CDrawStateData fDrawStateData;			// For saving old tools, etc.

	BR_Boolean IsPaneOrCanvasChanged() const;
	// Returns FALSE if the passed pane is currently drawing on the passed canvas.
	//  In that case, we don't do much.

	BR_CView* fOldPreparedPane;
};

//----------------------------------------------------------------------------------------
//	BR_CDrawInitiator::new
//----------------------------------------------------------------------------------------	
inline void* BR_CDrawInitiator::operator new(size_t/*cbSize*/ ,
											 void* fMemoryPtr)
{
	return fMemoryPtr;
}

//----------------------------------------------------------------------------------------
//	BR_CDrawInitiator::new
//----------------------------------------------------------------------------------------	
inline void* BR_CDrawInitiator::operator new(size_t cbSize )
{
	return ::operator new(cbSize);
}

//----------------------------------------------------------------------------------------
//	BR_CDrawInitiator::delete
//----------------------------------------------------------------------------------------	
inline void BR_CDrawInitiator::operator delete(void* fMemoryPtr)
{
	::operator delete(fMemoryPtr);
}

//----------------------------------------------------------------------------------------
//	BR_CDrawInitiator::new
//----------------------------------------------------------------------------------------	
inline BR_Boolean BR_CDrawInitiator::IsPaneOrCanvasChanged() const
{
	return fOldPaneCanvas != fCanvas || fOldCanvasPane != fPane;
}


//========================================================================================
//  BR_CDrawModeSetRestore
//
//  Use a stack-based instance of this class to set pane draw mode and later
//  restore it.
//========================================================================================

class BR_CDrawModeSetRestore : public _BR_CAutoDestructObject
{
public:
	BR_CDrawModeSetRestore(BR_CView* pane,
						   BR_DrawMode drawMode);
	virtual~ BR_CDrawModeSetRestore();

private:
	BR_CView* fPane;
	BR_DrawMode fOldDrawMode;
};

//========================================================================================
//  BR_CTextColorSetRestore
//
//  Use a stack-based instance of this class to temporarily set the text color
//  and later restore
//========================================================================================

class BR_CTextColorSetRestore : public _BR_CAutoDestructObject
{
public:
	BR_CTextColorSetRestore(BR_CView* pane,
							const BR_CColor& textColor);
	~BR_CTextColorSetRestore();

private:
	BR_CView* fPane;
	BR_CColor fOldTextColor;
};

//========================================================================================
//  BR_CTextBackgroundColorSetRestore
//
//  Use a stack-based instance of this class to temporarily set the text background color
//  and later restore
//========================================================================================

class BR_CTextBackgroundColorSetRestore : public _BR_CAutoDestructObject
{
public:
	BR_CTextBackgroundColorSetRestore(BR_CView* pane,
									  const BR_CColor& textBackgroundColor);
	~BR_CTextBackgroundColorSetRestore();

private:
	BR_CView* fPane;
	BR_CColor fOldTextBackgroundColor;
};

//========================================================================================
// CLASS BR_CIntersectClipRect
// Use this class to intersect the clip region and restore it later
//========================================================================================

class BR_CIntersectClipRect : public _BR_CAutoDestructObject
{
public:
	BR_CIntersectClipRect(BR_CView* pane,
						  const BR_CRectangle& rect);
	virtual~ BR_CIntersectClipRect();

private:
	BR_CView* fPane;

	//----------------------------------------------------------------------------------------
	// Macintosh
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_MAC
private:
	RgnHandle fSaveRegion;
#endif

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
private:
	unsigned short fSaveDCIndex;
#endif

};


#endif


