#if !defined(BRGREXCE_H) && !defined(__BEDRC__)
#define BRGREXCE_H
//========================================================================================
//
//     File:			BRGrExce.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	7/28/92
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BREXCEPT_H
#include "BRExcept.h"
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

#ifndef BROBJECT_H
#include "BRObject.h"
#endif

#ifndef BRCHRSTR_H
#include "BRChrStr.h"
#endif

#ifndef BRFONT_H
#include "BRFont.h"
#endif

#ifndef BRPEN_H
#include "BRPen.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CView;
class BR_CCanvas;
class BR_CPicture;

//========================================================================================
// BR_XGraphics_Error:
//
// The base graphics exception class.  We don't provide any BRTryBlo information
// because it's only important if you want to do something about an fError.  And
// if you do, you want to catch by a specific exception class, so we can provide
// BRTryBlo information much further down the hierarchy.
//========================================================================================

class BR_XGraphics_Error : public BR_XBedException
{
public:
	BR_XGraphics_Error();
	virtual~ BR_XGraphics_Error();

	_BR_EXCEPTION_DEFINE(BR_XGraphics_Error);
};

//========================================================================================
// BR_XGraphics_Tool:
//
// Something went wrong with graphics tools.
//========================================================================================

class BR_CGraphicsTool;

class BR_XGraphics_Tool : public BR_XGraphics_Error
{
public:
	BR_XGraphics_Tool(const BR_CGraphicsTool* graphicsTool);
	virtual~ BR_XGraphics_Tool();

	const BR_CGraphicsTool* GetGraphicsTool() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_Tool);

private:
	const BR_CGraphicsTool* fGraphicsTool;
};

//========================================================================================
// BR_XGraphics_ToolSelectFailed:
//
// The application was trying to Select a graphics tool and the OS failed.
//========================================================================================

class BR_XGraphics_ToolSelectFailed : public BR_XGraphics_Tool
{
public:
	BR_XGraphics_ToolSelectFailed(const BR_CGraphicsTool* graphicsTool,
								  const BR_CView* pane);
	virtual~ BR_XGraphics_ToolSelectFailed();

	const BR_CView* GetPane() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_ToolSelectFailed);

private:
	const BR_CView* fPane;
};

//========================================================================================
//	BR_XGraphics_CreateToolFailed:
//
// We were trying to creare a new graphics tool and couldn't Create the unerlying
// OS counterpart of the C++ object (like a GDI object in Windows).
//========================================================================================

class BR_XGraphics_CreateToolFailed : public BR_XGraphics_Tool
{
public:
	BR_XGraphics_CreateToolFailed(const BR_CGraphicsTool* graphicsTool);
	virtual~ BR_XGraphics_CreateToolFailed();

	_BR_EXCEPTION_DEFINE(BR_XGraphics_CreateToolFailed);
};

//========================================================================================
// BR_XGraphics_Unknown:
//
// Thrown When something happens in graphics stuff and we're not sure what it is
//========================================================================================

class BR_XGraphics_Unknown : public BR_XGraphics_Error
{
public:
	BR_XGraphics_Unknown();
	virtual~ BR_XGraphics_Unknown();

	_BR_EXCEPTION_DEFINE(BR_XGraphics_Unknown);
};

//========================================================================================
// BR_XGraphics_FontNotFound:
//
// Thrown When we cannot find the font the application wants.
//========================================================================================

class BR_XGraphics_FontNotFound : public BR_XGraphics_Error
{
public:
	BR_XGraphics_FontNotFound();
	virtual~ BR_XGraphics_FontNotFound();

	_BR_EXCEPTION_DEFINE(BR_XGraphics_FontNotFound);
};

//========================================================================================
// BR_XGraphics_FontIdNotFound:
//
// Thrown When the application asks for font by module and name string Id and
// string load fails.
//========================================================================================

class BR_CModule;

class BR_XGraphics_FontIdNotFound : public BR_XGraphics_FontNotFound
{
public:
	BR_XGraphics_FontIdNotFound(const BR_CModule* module,
								BR_CFont::FontId nNameStringId);
	virtual~ BR_XGraphics_FontIdNotFound();

	const BR_CModule* GetModule() const;
	/* We tried to load font name from this module.  NULL means Bedrock. */

	BR_CFont::FontId GetNameId() const;
	/* This is the string Id that the application passed. */

	_BR_EXCEPTION_DEFINE(BR_XGraphics_FontIdNotFound);

private:
	const BR_CModule* fModule;
	BR_CFont::FontId fFontId;
};

//========================================================================================
// BR_XGraphics_FontNameNotFound:
//
// The application asked for font by name and that font did not exist.
//========================================================================================

class BR_XGraphics_FontNameNotFound : public BR_XGraphics_FontNotFound
{
public:
	BR_XGraphics_FontNameNotFound(const BR_TString<BR_Char>& nameString);
	virtual~ BR_XGraphics_FontNameNotFound();

	void GetName(BR_TString<BR_Char>& NameString) const;
	/* The application passed this string as font name. */

	_BR_EXCEPTION_DEFINE(BR_XGraphics_FontNameNotFound);

private:
	const BR_CDynamicCharString fFontName;
};

//========================================================================================
//BR_XGraphics_FontStyleNotFound:
//
// The font fStyle that the application asked for does not exist for the specified
// typeface.
//========================================================================================

class BR_XGraphics_FontStyleNotFound : public BR_XGraphics_FontNotFound
{
public:
	BR_XGraphics_FontStyleNotFound(const BR_TString<BR_Char>& nameString,
								   BR_CFont::FontStyle fStyle);
	virtual~ BR_XGraphics_FontStyleNotFound();

	BR_CFont::FontStyle GetFontStyle() const;
	// The application asked for this font fStyle. 

	void GetName(BR_TString<BR_Char>& nameString) const;
	// The typeface name that doesn't have the specified fStyle.

	_BR_EXCEPTION_DEFINE(BR_XGraphics_FontStyleNotFound);

private:
	const BR_CDynamicCharString fFontName;
	BR_CFont::FontStyle fFontStyle;
};

//========================================================================================
// BR_XGraphics_PenStyleNotSupported:
//
// The pen fStyle that the application requested is not supported for the kind of
// drawing operation requested (e.g. we don't Draw dashed circles on the Mac).
//========================================================================================

class BR_XGraphics_PenStyleNotSupported : public BR_XGraphics_Error
{
public:
	BR_XGraphics_PenStyleNotSupported(BR_CPen::PenStyle fStyle);
	virtual~ BR_XGraphics_PenStyleNotSupported();

	BR_CPen::PenStyle GetPenStyle() const;
	// The application asked for this pen fStyle.

	_BR_EXCEPTION_DEFINE(BR_XGraphics_PenStyleNotSupported);

private:
	BR_CPen::PenStyle fPenStyle;
};

//========================================================================================
// BR_XGraphics_IconLoadFailed:
//
// We were trying to load an icon from a module, and failed.
//========================================================================================

class BR_XGraphics_IconLoadFailed : public BR_XGraphics_Error
{
public:
	BR_XGraphics_IconLoadFailed(const BR_CModule* module,
								BR_ResourceId resourceId);
	virtual~ BR_XGraphics_IconLoadFailed();

	const BR_CModule* GetModule() const;
	BR_ResourceId GetResId() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_IconLoadFailed);

private:
	const BR_CModule* fModule;
	BR_ResourceId fResourceId;
};

//========================================================================================
// BR_XGraphics_CursorLoadFailed:
//
// We were trying to load a cursor from a module, and failed.
//========================================================================================

class BR_XGraphics_CursorLoadFailed : public BR_XGraphics_Error
{
public:
	BR_XGraphics_CursorLoadFailed(const BR_CModule* module,
								  BR_ResourceId resourceId);
	virtual~ BR_XGraphics_CursorLoadFailed();

	const BR_CModule* GetModule() const;
	BR_ResourceId GetResId() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_CursorLoadFailed);

private:
	const BR_CModule* fModule;
	BR_ResourceId fResourceId;
};

//========================================================================================
// BR_XGraphics_CreateContextFailed:
//
// We were trying to Create drawing BRTryBlo for a canvas (DC in Windows or a
// GWorld on Mac and we failed).
//========================================================================================

class BR_XGraphics_CreateContextFailed : public BR_XGraphics_Error
{
public:
	BR_XGraphics_CreateContextFailed(const BR_CCanvas* canvas,
									 const BR_CView* pane);
	virtual~ BR_XGraphics_CreateContextFailed();

	const BR_CView* GetPane() const;
	const BR_CCanvas* GetCanvas() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_CreateContextFailed);

private:
	const BR_CCanvas* fCanvas;
	const BR_CView* fPane;
};

//========================================================================================
// BR_XGraphics_InvalidPictureFile:
//
// We were trying to Create drawing BRTryBlo for a canvas (DC in Windows or a
// GWorld on Mac and we failed).
//========================================================================================

class BR_XGraphics_InvalidPictureFile : public BR_XGraphics_Error
{
public:
	BR_XGraphics_InvalidPictureFile(const BR_CPicture* picture);
	virtual~ BR_XGraphics_InvalidPictureFile();

	const BR_CPicture* GetPicture() const;

	_BR_EXCEPTION_DEFINE(BR_XGraphics_InvalidPictureFile);

private:
	const BR_CPicture* fPicture;
};

#endif

