#if !defined(BRGRAPHT_H) && !defined(__BEDRC__)
#define BRGRAPHT_H
//========================================================================================
//
//     File:			BRGraphT.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	11/24/90
//
//     COPYRIGHT 1990-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BROBJECT_H
#include "BRObject.h"  // always include the base class
#endif

#ifndef BRGRCOMM_H
#include "BRGrComm.h"
#endif

//========================================================================================
//	Forward class declarations
//========================================================================================

class BR_CView;
class BR_CGraphicsToolSelector;
class BR_CBedToolSelector;
class BR_CCanvas;

//========================================================================================
//	BR_CBedDeferredTool
//
//	This is a class for "exemplar" - like ctors in BR_CPen, etc, which are used by cDeferred tools
//========================================================================================

class BR_CBedDeferredTool
{
public:
	BR_CBedDeferredTool();
};

//========================================================================================
//	BR_CGraphicsTool
//
//	This is a class for "exemplar" - like ctors in BR_CPen, etc, which are used by cDeferred tools
//========================================================================================
class BR_CGraphicsTool : public BR_CObject
{
	friend BR_CGraphicsToolSelector;
	friend BR_CCanvas;
	friend BR_CBedToolSelector;

	// ***KVV: This is temporary.  I don't like friends, but we need to get people
	//  to stop using old selection methods in graphics tools directly. Then we will
	//  make a big comment a-la "Use these methods and you'll implode.

public:
	virtual~ BR_CGraphicsTool();

protected:
	BR_CGraphicsTool();
	BR_CGraphicsTool(const BR_CGraphicsTool& graphicsTool);

	BR_Boolean IsSelected() const;
	unsigned short GetSelectedCount() const;
	void AssertIsNotSelected();

	void Select(BR_CView& pane,
				GraphicsToolSelectionOptions selectionOptions,
				BR_SGraphicsToolSuspendResumeState* state);
	virtual void SetupTool(BR_CView& pane,
						   GraphicsToolSelectionOptions selectionOptions,
						   BR_SGraphicsToolSuspendResumeState* state) = 0;
	virtual void Unselect(BR_CView& pane,
						  GraphicsToolSelectionOptions selectionOptions,
						  BR_SGraphicsToolSuspendResumeState* state);
	virtual void RestoreNullTool(BR_CView& pane) = 0;

	virtual BR_CGraphicsTool* GetCurrentTool(const BR_CCanvas& canvas) const = 0;
	virtual void SetCurrentTool(BR_CCanvas& canvas,
								BR_CGraphicsTool* graphicsTool) const = 0;

private:
	unsigned short fSelectedCount;			// Number of times the tool was selected

	BR_SETCLASSNAME(BR_CGraphicsTool);
};

//----------------------------------------------------------------------------------------
//	BR_CGraphicsTool::IsSelected
//----------------------------------------------------------------------------------------
inline BR_Boolean BR_CGraphicsTool::IsSelected() const
{
	return (fSelectedCount != 0);
}

//----------------------------------------------------------------------------------------
//	BR_CGraphicsTool::GetSelectedCount
//----------------------------------------------------------------------------------------
inline unsigned short BR_CGraphicsTool::GetSelectedCount() const
{
	return (fSelectedCount);
}

#endif


