#if !defined(BRFLOATW_H) && !defined(__BEDRC__)
#define BRFLOATW_H
//========================================================================================
//
//     File:			BRFloatW.h
//     Release Version:	$ 1.0d1 $
//
//     Creation Date:	May 8, 1992
//
//     COPYRIGHT 1992-1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRWINDOW_H
#include "BRWindow.h"
#endif

//==========================================================================
//	Forward Declarations
//==========================================================================

class BR_CMenuBar;

//==========================================================================
//	CLASS BR_CFloatingWindow
//==========================================================================

class BR_CFloatingWindow : public BR_CWindow
{
public:
	BR_CFloatingWindow(BR_CView* enclosure,
					   BR_CBureaucrat* supervisor,
					   const BR_CModule& module,
					   BR_SResource& winResource);

	BR_CFloatingWindow(BR_CView* enclosure,
					   BR_CBureaucrat* supervisor,
					   BR_Distance width,
					   BR_Distance height,
					   BR_Coordinate x,
					   BR_Coordinate y,
					   ViewStyle style,
					   ViewUnits units);

	virtual~ BR_CFloatingWindow();

	// Menu methods
	BR_CMenuBar* SetMenuBar(BR_CMenuBar* newMenuBar);
	BR_CMenuBar* GetMenuBar() const;
	void DrawMenuBar();

private:
	BR_CMenuBar* fMenuBar;

	//----------------------------------------------------------------------------------------
	// Windows
	//----------------------------------------------------------------------------------------
#ifdef BR_BUILD_WIN
public:
	LONG Dispatch(WORD wMessage,
				  WORD wParam,
				  LONG lParam,
				  BR_Boolean callDefaultProc = TRUE);

#endif

	BR_SETCLASSNAME(BR_CFloatingWindow);
};

//--------------------------------------------------------------------------
// BR_CFloatingWindow::DrawMenuBar
//--------------------------------------------------------------------------
inline void BR_CFloatingWindow::DrawMenuBar()
{
#ifdef BR_BUILD_MAC
    ::DrawMenuBar();
#endif

#ifdef BR_BUILD_WIN
    ::DrawMenuBar(GetPlatformWindow());
#endif
}

//--------------------------------------------------------------------------
// BR_CFloatingWindow::GetMenuBar
//--------------------------------------------------------------------------
inline BR_CMenuBar* BR_CFloatingWindow::GetMenuBar() const
{
	return fMenuBar;
}


#endif

